/*
 *   Copyright (C) 2011-2019, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#if defined(__WXMSW__)
  //to be filled
#else
 #include <sys/mman.h>  //allow for memory locking of keyinfo
#endif


#include "mylogin.h"
#include "globals.h"
#include "dolonu.h"

//(*InternalHeaders(mylogin)
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/font.h>
//*)

//(*IdInit(mylogin)
const long mylogin::ID_STATICTEXT1 = wxNewId();
const long mylogin::ID_TEXTCTRL1 = wxNewId();
const long mylogin::ID_BUTTON1 = wxNewId();
const long mylogin::ID_STATICTEXT2 = wxNewId();
const long mylogin::ID_TEXTCTRL2 = wxNewId();
const long mylogin::ID_LEGACY_BOX = wxNewId();
const long mylogin::ID_TIMER1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(mylogin,wxDialog)
	//(*EventTable(mylogin)
	//*)
END_EVENT_TABLE()

mylogin::mylogin(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
    FILE *fp;
    char buff[202];
    wxString salt_str;
    int rs,i;


	//(*Initialize(mylogin)
	wxFlexGridSizer* FlexGridSizer1;

	Create(parent, id, _("lgn"), wxDefaultPosition, wxDefaultSize, wxSTAY_ON_TOP|wxDEFAULT_DIALOG_STYLE, _T("id"));
	FlexGridSizer1 = new wxFlexGridSizer(0, 1, 0, 0);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Type your Passphrase:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	wxFont StaticText1Font(13,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText1->SetFont(StaticText1Font);
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	pw_ctrl = new wxTextCtrl(this, ID_TEXTCTRL1, wxEmptyString, wxDefaultPosition, wxSize(534,22), wxTE_PASSWORD, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	pw_ctrl->SetFocus();
	wxFont pw_ctrlFont(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	pw_ctrl->SetFont(pw_ctrlFont);
	FlexGridSizer1->Add(pw_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button1 = new wxButton(this, ID_BUTTON1, _("Login"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	Button1->SetDefault();
	Button1->SetBackgroundColour(wxColour(250,150,150));
	wxFont Button1Font(13,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button1->SetFont(Button1Font);
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText2 = new wxStaticText(this, ID_STATICTEXT2, _("Attention: NEVER leave Academic Signature unattended in logged-in state!"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT2"));
	StaticText2->SetForegroundColour(wxColour(197,5,5));
	StaticText2->SetBackgroundColour(wxColour(250,212,212));
	wxFont StaticText2Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText2->SetFont(StaticText2Font);
	FlexGridSizer1->Add(StaticText2, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	salt_ctrl = new wxTextCtrl(this, ID_TEXTCTRL2, _("Salt: "), wxDefaultPosition, wxSize(570,22), 0, wxDefaultValidator, _T("ID_TEXTCTRL2"));
	salt_ctrl->Disable();
	wxFont salt_ctrlFont(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	salt_ctrl->SetFont(salt_ctrlFont);
	FlexGridSizer1->Add(salt_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_TOP, 5);
	Legacy_box = new wxCheckBox(this, ID_LEGACY_BOX, _("legacy passphr\ninterpretation"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_LEGACY_BOX"));
	Legacy_box->SetValue(false);
	wxFont Legacy_boxFont(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Legacy_box->SetFont(Legacy_boxFont);
	FlexGridSizer1->Add(Legacy_box, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	SetSizer(FlexGridSizer1);
	Timer1.SetOwner(this, ID_TIMER1);
	Timer1.Start(200, false);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_TEXTCTRL1,wxEVT_COMMAND_TEXT_ENTER,(wxObjectEventFunction)&mylogin::OnTryLogin);
	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&mylogin::OnTryLogin);
	Connect(ID_TIMER1,wxEVT_TIMER,(wxObjectEventFunction)&mylogin::OnCheck_exit);
	//*)
	cntfalse=0;
	toleave=false;
	legacy=false;
   //load salt
    if(!wxFile::Exists(sec_path + _("/salt.txt")))
    {
        throwout(_("Fatal Error NO SALT found in Login 8-O\nNo access without correct salt!\nYou don't happen to have a backup copy somewhere?"));
        toleave=true;
    }
    fp=fopen((const char*)(sec_path + _("/salt.txt")).mb_str(wxConvLocal), "r");
    rs=fscanf(fp," salt:%100s",buff);
    if(rs!= 1) throwout(_("error,\nsalt number could not be read !?"),10);
    salt_str= wxString::FromUTF8(buff);
    salt_ctrl->SetValue(_("Salt: ") + salt_str);
    if( !salt.storhex(&salt_str))
    {
        throwout(_("Fatal Error!\nLoading Salt failed!!\nNo access without correct salt!"));
        toleave=true;
    }
    //now also read stretchfactor
    rs=fscanf(fp," stretchfactor: %i ",&i);
    if(rs!= 1)
    {
        throwout(_("warning,\nStretchfactor not specified!\nassuming 1"),3);
        stretch=1;
    }
    else
    {
        if(i<1 || i>400) //unreasonable value
        {
            throwout(_("warning,\nunreasonable Stretchfactor declared!\nassuming 1"),3);
            stretch=1;
        }
        else stretch=i;
    }

    if(fp!=NULL) fclose(fp);
    //lock pwctrl

}
/******************************************************************/
mylogin::~mylogin()
{
	//(*Destroy(mylogin)
	//*)
}

/******************************************************************/
void mylogin::OnTryLogin(wxCommandEvent& event)
{
    longnumber lg_ky, hky,fromfile,nky;
    wxString hlp;

    if(! wxFileExists(sec_path + _("/paphr_hash.flea"))) //fatal error
    {
        throwout(_("Error in Login 8-O"));
        EndModal(0);//main loop should end!
        return;
    }
    if(!fromfile.lonu_from_file(sec_path + _("/paphr_hash.flea")))
    {
        throwout(_("Error 2 in Login 8-O"));
        EndModal(0);//main loop should end!
        return;
    }
    legacy= Legacy_box->GetValue();
    hlp=pw_ctrl->GetLineText(0);
    //blank pwctrl
    pw_ctrl->SetValue(_("deadbeef is bad food"));
    //now the new preform Step for Salting and Stretching
    if(!kyprep(&hky, &hlp, &salt, &stretch_ell, stretch,ss_klen, legacy ))  //make ky
    {
        throwout(_("Fatal error in kyprep!!"));
        return;
    }
    zugang.copynum(&hky);
    if (!legacy) hlp.Empty();
    #if defined(__WXMSW__)
        VirtualLock(zugang.ad,zugang.length);
    #else
      mlock(zugang.ad,zugang.length);
    #endif
    hky.randomize(5,NULL,32,0,0); //runden, mateadresse, outlength, cagesize, warnflag
    hky.setsize(true);
    hky.shrinktofit();
    if(hky.compare(&fromfile) ==0)
    {
        is_armed=true;
        lastarmed=time(NULL);
        if(legacy) //modernize!
        {
                if(!kyprep(&nky, &hlp, &salt, &stretch_ell, stretch,ss_klen, false ))  //make ky
                {
                    throwout(_("Fatal error in kyprep!!"));
                    return;
                }
                hlp.Empty();
                throwout(_("recoding to non-legacy!"),2);
                recode_all(&nky, &zugang);
                zugang.copynum(&nky);
                //update logincheck
                nky.randomize(5,NULL,32,0,0); //runden, mateadresse, outlength, cagesize, warnflag
                nky.setsize(true);
                nky.shrinktofit();
                nky.lonu_to_file(sec_path + _("/paphr_hash.flea"));
        }
        EndModal(1);
        return;
    }
    throwout(_("Wrong Passphrase!"),3);
    cntfalse++;
    if(cntfalse >2)
    {
        hlp=_("In case you forgot your passphrase but have leftover data\nfrom a previous installation causing unwanted passphrase requests\n");
        hlp +=_("you may manually remove or empty the (sub-)directory:\n\n" );
        hlp += sec_path;
        hlp += _("\n\n and do a fresh install to be able to reenter\ninto the regular hatching process.");
        throwout(hlp,90);
        EndModal(0);
    }
    if(cntfalse ==2)
    {
        throwout(_("If you just updated from prior ver 45\nand had special Characters in passphr,\n you may try to select legacy passphr treatment"),5);
    }
    return;
}
/******************************************************/


void mylogin::OnCheck_exit(wxTimerEvent& event)
{
    if(toleave)
    {
        EndModal(0);
        return;
    }
}
/***************************************************************/
