/*
 *   Copyright (C) 2011-2019, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <wx/arrstr.h>
#include <wx/dir.h>
#include <wx/busyinfo.h>


#include "gpg_enc_dialog.h"
#include "gpg_add_pub.h"
#include "globals.h"
#include "gnupg_globals.h"
#include "AskDialog.h"
#include "gpg_wrap.h"

#include <wx/filename.h>


//(*InternalHeaders(gpg_enc_dialog)
#include <wx/font.h>
#include <wx/intl.h>
#include <wx/string.h>
//*)

//(*IdInit(gpg_enc_dialog)
const long gpg_enc_dialog::ID_BUTTON1 = wxNewId();
const long gpg_enc_dialog::ID_STATICTEXT1 = wxNewId();
const long gpg_enc_dialog::ID_STATICTEXT3 = wxNewId();
const long gpg_enc_dialog::ID_TEXTCTRL2 = wxNewId();
const long gpg_enc_dialog::ID_BUTTON5 = wxNewId();
const long gpg_enc_dialog::ID_STATICTEXT2 = wxNewId();
const long gpg_enc_dialog::ID_TEXTCTRL1 = wxNewId();
const long gpg_enc_dialog::ID_STATICTEXT4 = wxNewId();
const long gpg_enc_dialog::ID_TEXTCTRL4 = wxNewId();
const long gpg_enc_dialog::ID_TEXTCTRL5 = wxNewId();
const long gpg_enc_dialog::ID_BUTTON6 = wxNewId();
const long gpg_enc_dialog::ID_BUTTON3 = wxNewId();
const long gpg_enc_dialog::ID_TIMER1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(gpg_enc_dialog,wxDialog)
	//(*EventTable(gpg_enc_dialog)
	//*)
END_EVENT_TABLE()

gpg_enc_dialog::gpg_enc_dialog(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
	//(*Initialize(gpg_enc_dialog)
	wxFlexGridSizer* FlexGridSizer1;

	Create(parent, id, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("id"));
	FlexGridSizer1 = new wxFlexGridSizer(0, 3, 0, 0);
	Button1 = new wxButton(this, ID_BUTTON1, _("Exit"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	Button1->SetBackgroundColour(wxColour(253,208,208));
	wxFont Button1Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button1->SetFont(Button1Font);
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("GnuPG Encipher File"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	wxFont StaticText1Font(14,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText1->SetFont(StaticText1Font);
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText3 = new wxStaticText(this, ID_STATICTEXT3, _("Document File:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT3"));
	wxFont StaticText3Font(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText3->SetFont(StaticText3Font);
	FlexGridSizer1->Add(StaticText3, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	fnam_ctrl = new wxTextCtrl(this, ID_TEXTCTRL2, wxEmptyString, wxDefaultPosition, wxSize(648,21), 0, wxDefaultValidator, _T("ID_TEXTCTRL2"));
	wxFont fnam_ctrlFont(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	fnam_ctrl->SetFont(fnam_ctrlFont);
	FlexGridSizer1->Add(fnam_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button5 = new wxButton(this, ID_BUTTON5, _("Select Plainfile"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON5"));
	wxFont Button5Font(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button5->SetFont(Button5Font);
	FlexGridSizer1->Add(Button5, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	StaticText2 = new wxStaticText(this, ID_STATICTEXT2, _("Name of Cipher:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT2"));
	wxFont StaticText2Font(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText2->SetFont(StaticText2Font);
	FlexGridSizer1->Add(StaticText2, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	signam_ctrl = new wxTextCtrl(this, ID_TEXTCTRL1, wxEmptyString, wxDefaultPosition, wxSize(648,21), 0, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	wxFont signam_ctrlFont(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	signam_ctrl->SetFont(signam_ctrlFont);
	FlexGridSizer1->Add(signam_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(20,78,1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	StaticText4 = new wxStaticText(this, ID_STATICTEXT4, _("Public Key of Recipient.\nDo not fetch from Keyserver! \nExplicitly imported from Source !YOU! evaluated as trustworthy."), wxDefaultPosition, wxSize(548,64), wxALIGN_CENTRE|wxDOUBLE_BORDER, _T("ID_STATICTEXT4"));
	StaticText4->SetForegroundColour(wxColour(213,5,5));
	wxFont StaticText4Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText4->SetFont(StaticText4Font);
	FlexGridSizer1->Add(StaticText4, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	FlexGridSizer1->Add(20,79,1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	pubkyid_ctrl = new wxTextCtrl(this, ID_TEXTCTRL4, wxEmptyString, wxDefaultPosition, wxSize(132,22), 0, wxDefaultValidator, _T("ID_TEXTCTRL4"));
	wxFont pubkyid_ctrlFont(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	pubkyid_ctrl->SetFont(pubkyid_ctrlFont);
	FlexGridSizer1->Add(pubkyid_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_TOP, 5);
	kylabl_ctrl = new wxTextCtrl(this, ID_TEXTCTRL5, wxEmptyString, wxDefaultPosition, wxSize(647,22), 0, wxDefaultValidator, _T("ID_TEXTCTRL5"));
	kylabl_ctrl->SetForegroundColour(wxColour(210,8,8));
	wxFont kylabl_ctrlFont(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	kylabl_ctrl->SetFont(kylabl_ctrlFont);
	FlexGridSizer1->Add(kylabl_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_TOP, 5);
	Button6 = new wxButton(this, ID_BUTTON6, _("Select\nrecipient key"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON6"));
	wxFont Button6Font(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button6->SetFont(Button6Font);
	FlexGridSizer1->Add(Button6, 1, wxALL|wxALIGN_LEFT|wxALIGN_TOP, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button3 = new wxButton(this, ID_BUTTON3, _("Make GnuPG Cipher"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON3"));
	Button3->SetBackgroundColour(wxColour(197,198,252));
	wxFont Button3Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button3->SetFont(Button3Font);
	FlexGridSizer1->Add(Button3, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	SetSizer(FlexGridSizer1);
	Timer1.SetOwner(this, ID_TIMER1);
	Timer1.Start(1000, false);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&gpg_enc_dialog::OnExit);
	Connect(ID_BUTTON5,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&gpg_enc_dialog::OnSelPlain);
	Connect(ID_BUTTON6,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&gpg_enc_dialog::OnSelect_public);
	Connect(ID_BUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&gpg_enc_dialog::OnMakeCipher);
	Connect(ID_TIMER1,wxEVT_TIMER,(wxObjectEventFunction)&gpg_enc_dialog::OnTimer1Trigger);
	//*)

    fnam_ctrl->DragAcceptFiles(true);
    fnam_ctrl->Connect(wxEVT_DROP_FILES, wxDropFilesEventHandler(gpg_enc_dialog::OnDropFile), NULL, this);



	//set pubky
    tellerror=false;
    if(get_pub_labels()<1)
    {
        //create key first
        throwout(_("Flawed installation of GnuPG\nno public keys found!\n must create one first\ndirectly in GnuPG"),3);
        tellerror=true;
    }
   if(!tellerror)
   {
	  pubkyid_ctrl->SetValue(pb_kyid[pubk_sel]);
      kylabl_ctrl->SetValue(pb_kylabel[pubk_sel]);
   }
}
/******************************************************************/
gpg_enc_dialog::~gpg_enc_dialog()
{
	//(*Destroy(gpg_enc_dialog)
	//*)
}

/***************************************************************/
void gpg_enc_dialog::OnMakeCipher(wxCommandEvent& event)
{
    bool result;
    wxString kid,fnam,snam,msg;

    //throwout(_("Do not use public keys blindly downloaded from servers!!\nMake sure you critically assessed\n the trustworthyness of the public key !YOURSELF!\nin the context of the \"Mosaic of Trust\"\n"),10);
    kid=pubkyid_ctrl->GetLineText(0);
    fnam=fnam_ctrl->GetLineText(0);
    //check for existence
    if(!wxFile::Exists(fnam))
    {
        throwout(_("file to GnuPG-encipher does not exist!\nDo Nothing."),3);
        return;
    }
    snam=signam_ctrl->GetLineText(0);
    if(wxFile::Exists(snam + _(".gpg")))
    {
        throwout(_("Cipher already exists\nPlease change cipher name before enciphering!"),3);
        return;
    }

    result=gpg_encode(kid, fnam, snam, &msg);
    if(!result)
    {
        throwout(_("encoding not successful\n 8-0\n\n")+msg,12);
    }
    else
    {
        throwout(_("encoding successful\n :-))\n\n")+msg,6);
    }
    return;
}
/***************************************************************/
void gpg_enc_dialog::OnExit(wxCommandEvent& event)
{
       EndModal(1);
}
/*********************************************************************/
void gpg_enc_dialog::OnSelPlain(wxCommandEvent& event)
{
    wxString plainnam,cry_d;

    if(cur_cry_path.IsEmpty())
    {
        cry_d = cry_path; //first call
    }
    else
    {
        cry_d = cur_cry_path;
    }
    plainnam = wxFileSelector(_("Select a file to encipher"),cry_d,_(""),_(""),_("all files(*.*)|*.*"));
    //check if exists
    if(plainnam.IsEmpty()) return;
    if(!wxFileExists(plainnam)){throwout(_("Plainfile file does not exist"),2); return;}
    else
    {
        fnam_ctrl->SetValue(plainnam);
        signam_ctrl->SetValue(plainnam + _(".gpg"));
        cur_cry_path= ((wxFileName)plainnam).GetPath(); //get new path and store into cur_doc_path
    }
    //check for existence of cipher
    if(wxFile::Exists(plainnam + _(".gpg")))
    {
        throwout(_("Cipher already exists\nPlease change cipher name before enciphering!"),3);
    }


    return;
}
/**************************************************************************/
void gpg_enc_dialog::OnSelect_public(wxCommandEvent& event)
{
    if(!checkarm()){Close();}
    if (to_quit) Close();

    gpg_add_pub dialog(this);
    dialog.ShowModal();

    pubkyid_ctrl->SetValue(pb_kyid[pubk_sel]);
    kylabl_ctrl->SetValue(pb_kylabel[pubk_sel]);
    return;
}
/*******************************************************************************/
void gpg_enc_dialog::OnTimer1Trigger(wxTimerEvent& event)
{
    if(tellerror) EndModal(0);
    else{
        Timer1.Start(1000,wxTIMER_ONE_SHOT);
    }
}
/******************************************************************************/
/*******************************************************/
void gpg_enc_dialog::OnDropFile(wxDropFilesEvent& event)
    {
        int filno;
        drop_succ=false;
        wxString fnam;

        if (event.GetNumberOfFiles() > 0) {

            wxString* dropped = event.GetFiles();
            wxASSERT(dropped);

            wxBusyCursor busyCursor;
            wxWindowDisabler disabler;
            wxBusyInfo busyInfo(_("Adding file, wait please..."));

            wxString name;
            filno = event.GetNumberOfFiles();
            if(filno!=1)
            {
				throwout(_("Can only enter single filename here.\nDrop rejected!"),3);
				return;
			}
			if( wxDirExists( 	dropped[0]	))
            {
                throwout(_("Directoryname!\nCan only enter single filename here.\nMust build archive of directory and encrypt.\nDrop rejected!"),3);
                return;
            }
			name = dropped[0];
			if (!wxFileExists(name))
            {
				throwout(_("File does not exist\nDrop rejected!"),5);
				return;
			}

            wxTextCtrl* textCtrl = dynamic_cast<wxTextCtrl*>(event.GetEventObject());
            wxASSERT(textCtrl);
            textCtrl->Clear();
            textCtrl->SetValue(name);
            drop_succ=true;
            fnam=name;
            cur_doc_path= ((wxFileName)fnam).GetPath(); //get new path and store into cur_doc_path

    if(!wxFileExists(fnam)){throwout(_("Plainfile file does not exist"),2); return;}
    else
    {
        signam_ctrl->SetValue(fnam + _(".gpg"));
        cur_cry_path= ((wxFileName)fnam).GetPath(); //get new path and store into cur_doc_path
    }
    //check for existence of cipher
    if(wxFile::Exists(fnam + _(".gpg")))
    {
        throwout(_("Cipher already exists\nPlease change cipher name before enciphering!"),3);
    }

            return;
        }
    }
/*********************************************************/

