/*
 *   Copyright (C) 2011-2012, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#ifndef GPG_ADD_PUB_H
#define GPG_ADD_PUB_H

//(*Headers(gpg_add_pub)
#include <wx/dialog.h>
#include <wx/sizer.h>
#include <wx/button.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/timer.h>
#include <wx/listbox.h>
//*)

class gpg_add_pub: public wxDialog
{
	public:

		gpg_add_pub(wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		virtual ~gpg_add_pub();

		//(*Declarations(gpg_add_pub)
		wxTextCtrl* armor_ctrl;
		wxButton* Button4;
		wxButton* Button1;
		wxButton* Button2;
		wxButton* Button3;
		wxStaticText* StaticText1;
		wxTimer Timer1;
		wxStaticText* StaticText3;
		wxListBox* kylist_ctrl;
		wxButton* Button5;
		wxButton* Button6;
		//*)

	protected:

		//(*Identifiers(gpg_add_pub)
		static const long ID_BUTTON1;
		static const long ID_STATICTEXT1;
		static const long ID_BUTTON5;
		static const long ID_LISTBOX1;
		static const long ID_BUTTON4;
		static const long ID_BUTTON2;
		static const long ID_BUTTON3;
		static const long ID_TEXTCTRL2;
		static const long ID_BUTTON6;
		static const long ID_STATICTEXT3;
		static const long ID_TIMER1;
		//*)

	private:

		//(*Handlers(gpg_add_pub)
		void OnExit(wxCommandEvent& event);
		void OnLoadFromFile(wxCommandEvent& event);
		void OnLoad_text(wxCommandEvent& event);
		void OnDelete_sel(wxCommandEvent& event);
		void OnExport(wxCommandEvent& event);
		void OnSign(wxCommandEvent& event);
		void OnTimer1Trigger(wxTimerEvent& event);
		//*)

		bool tellerror;

		DECLARE_EVENT_TABLE()
};

#endif
