/*
 *   Copyright (C) 2011-2019, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


//(*InternalHeaders(ellip_ky_sav)
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/font.h>
//*)

#include <wx/filename.h>
#include <wx/dirdlg.h>

#include "globals.h"
#include "ellky_load1.h"
#include <wx/filedlg.h>
#include <wx/textdlg.h>
#include "PWShow.h"
#include "AskDialog.h"
#include "AskInput.h"

#include "ellip_ky_sav.h"
#include "DomainSelector.h"


//(*IdInit(ellip_ky_sav)
const long ellip_ky_sav::ID_BUTTON1 = wxNewId();
const long ellip_ky_sav::ID_STATICTEXT1 = wxNewId();
const long ellip_ky_sav::ID_STATICTEXT11 = wxNewId();
const long ellip_ky_sav::ID_STATICTEXT10 = wxNewId();
const long ellip_ky_sav::ID_STATICTEXT2 = wxNewId();
const long ellip_ky_sav::ID_TEXTCTRL1 = wxNewId();
const long ellip_ky_sav::ID_STATICTEXT3 = wxNewId();
const long ellip_ky_sav::ID_TEXTCTRL2 = wxNewId();
const long ellip_ky_sav::ID_STATICTEXT4 = wxNewId();
const long ellip_ky_sav::ID_TEXTCTRL3 = wxNewId();
const long ellip_ky_sav::ID_STATICTEXT9 = wxNewId();
const long ellip_ky_sav::ID_TEXTCTRL7 = wxNewId();
const long ellip_ky_sav::ID_STATICTEXT5 = wxNewId();
const long ellip_ky_sav::ID_TEXTCTRL4 = wxNewId();
const long ellip_ky_sav::ID_BUTTON9 = wxNewId();
const long ellip_ky_sav::ID_BUTTON6 = wxNewId();
const long ellip_ky_sav::ID_BUTTON4 = wxNewId();
const long ellip_ky_sav::ID_STATICTEXT6 = wxNewId();
const long ellip_ky_sav::ID_STATICTEXT7 = wxNewId();
const long ellip_ky_sav::ID_TEXTCTRL5 = wxNewId();
const long ellip_ky_sav::ID_STATICTEXT8 = wxNewId();
const long ellip_ky_sav::ID_TEXTCTRL6 = wxNewId();
const long ellip_ky_sav::ID_BUTTON5 = wxNewId();
const long ellip_ky_sav::ID_CHECKBOX1 = wxNewId();
const long ellip_ky_sav::ID_BUTTON2 = wxNewId();
const long ellip_ky_sav::ID_CHECKBOX2 = wxNewId();
const long ellip_ky_sav::ID_BUTTON3 = wxNewId();
const long ellip_ky_sav::ID_BUTTON8 = wxNewId();
const long ellip_ky_sav::ID_BUTTON10 = wxNewId();
const long ellip_ky_sav::ID_BUTTON7 = wxNewId();
const long ellip_ky_sav::ID_TIMER1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(ellip_ky_sav,wxDialog)
	//(*EventTable(ellip_ky_sav)
	//*)
END_EVENT_TABLE()

ellip_ky_sav::ellip_ky_sav(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
    wxString loctray;


    if(!checkarm()){Close();}
nostop=true;
	//(*Initialize(ellip_ky_sav)
	wxFlexGridSizer* FlexGridSizer1;
	Create(parent, id, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE|wxRAISED_BORDER, _T("id"));
	SetForegroundColour(wxColour(126,5,5));
	SetBackgroundColour(wxColour(255,227,227));
	FlexGridSizer1 = new wxFlexGridSizer(0, 2, 0, 0);
	Button1 = new wxButton(this, ID_BUTTON1, _("Cancel/Exit"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	Button1->SetDefault();
	Button1->SetBackgroundColour(wxColour(250,175,211));
	wxFont Button1Font(10,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button1->SetFont(Button1Font);
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Make/Load/Save private elliptic key"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	StaticText1->SetForegroundColour(wxColour(172,9,9));
	wxFont StaticText1Font(14,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText1->SetFont(StaticText1Font);
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText11 = new wxStaticText(this, ID_STATICTEXT11, _("Add your \nacronym to ID"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT11"));
	wxFont StaticText11Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText11->SetFont(StaticText11Font);
	FlexGridSizer1->Add(StaticText11, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	StaticText10 = new wxStaticText(this, ID_STATICTEXT10, _("This dialog demands privacy! Do not show it to the world!\nClosing after 3 minutes of inactivity for security reasons!"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT10"));
	wxFont StaticText10Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText10->SetFont(StaticText10Font);
	FlexGridSizer1->Add(StaticText10, 1, wxALL|wxALIGN_TOP|wxALIGN_CENTER_HORIZONTAL, 5);
	StaticText2 = new wxStaticText(this, ID_STATICTEXT2, _("Key_ID"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT2"));
	wxFont StaticText2Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText2->SetFont(StaticText2Font);
	FlexGridSizer1->Add(StaticText2, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	id_ctrl = new wxTextCtrl(this, ID_TEXTCTRL1, _("-"), wxDefaultPosition, wxSize(207,23), 0, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	wxFont id_ctrlFont(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	id_ctrl->SetFont(id_ctrlFont);
	FlexGridSizer1->Add(id_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	StaticText3 = new wxStaticText(this, ID_STATICTEXT3, _("Full Name"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT3"));
	wxFont StaticText3Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText3->SetFont(StaticText3Font);
	FlexGridSizer1->Add(StaticText3, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	fullname_ctrl = new wxTextCtrl(this, ID_TEXTCTRL2, _("-"), wxDefaultPosition, wxSize(391,23), 0, wxDefaultValidator, _T("ID_TEXTCTRL2"));
	wxFont fullname_ctrlFont(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	fullname_ctrl->SetFont(fullname_ctrlFont);
	FlexGridSizer1->Add(fullname_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	StaticText4 = new wxStaticText(this, ID_STATICTEXT4, _("Key Domain: "), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT4"));
	wxFont StaticText4Font(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText4->SetFont(StaticText4Font);
	FlexGridSizer1->Add(StaticText4, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	domnam_ctrl = new wxTextCtrl(this, ID_TEXTCTRL3, _("-"), wxDefaultPosition, wxSize(250,23), wxTE_READONLY, wxDefaultValidator, _T("ID_TEXTCTRL3"));
	wxFont domnam_ctrlFont(6,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	domnam_ctrl->SetFont(domnam_ctrlFont);
	FlexGridSizer1->Add(domnam_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	StaticText9 = new wxStaticText(this, ID_STATICTEXT9, _("Default Domain:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT9"));
	wxFont StaticText9Font(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText9->SetFont(StaticText9Font);
	FlexGridSizer1->Add(StaticText9, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	currdom_ctrl = new wxTextCtrl(this, ID_TEXTCTRL7, _("-"), wxDefaultPosition, wxSize(247,22), wxTE_READONLY, wxDefaultValidator, _T("ID_TEXTCTRL7"));
	wxFont currdom_ctrlFont(6,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	currdom_ctrl->SetFont(currdom_ctrlFont);
	FlexGridSizer1->Add(currdom_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	StaticText5 = new wxStaticText(this, ID_STATICTEXT5, _("Secret Key(hex): "), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT5"));
	wxFont StaticText5Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText5->SetFont(StaticText5Font);
	FlexGridSizer1->Add(StaticText5, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	d_ctrl = new wxTextCtrl(this, ID_TEXTCTRL4, _("-"), wxDefaultPosition, wxSize(511,19), wxTE_PROCESS_ENTER|wxTE_PASSWORD, wxDefaultValidator, _T("ID_TEXTCTRL4"));
	d_ctrl->SetForegroundColour(wxColour(210,8,8));
	d_ctrl->SetBackgroundColour(wxColour(250,219,219));
	wxFont d_ctrlFont(6,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	d_ctrl->SetFont(d_ctrlFont);
	FlexGridSizer1->Add(d_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	Button9 = new wxButton(this, ID_BUTTON9, _("show priv key \nfor 30 sec"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON9"));
	Button9->SetForegroundColour(wxColour(140,16,16));
	Button9->SetBackgroundColour(wxColour(247,202,202));
	wxFont Button9Font(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button9->SetFont(Button9Font);
	FlexGridSizer1->Add(Button9, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	Button6 = new wxButton(this, ID_BUTTON6, _("Load stored Key"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON6"));
	wxFont Button6Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button6->SetFont(Button6Font);
	FlexGridSizer1->Add(Button6, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button4 = new wxButton(this, ID_BUTTON4, _("Refresh_A"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON4"));
	wxFont Button4Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button4->SetFont(Button4Font);
	FlexGridSizer1->Add(Button4, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText6 = new wxStaticText(this, ID_STATICTEXT6, _("Public Key(not stored in private set):"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT6"));
	wxFont StaticText6Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText6->SetFont(StaticText6Font);
	FlexGridSizer1->Add(StaticText6, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText7 = new wxStaticText(this, ID_STATICTEXT7, _("A_X:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT7"));
	wxFont StaticText7Font(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText7->SetFont(StaticText7Font);
	FlexGridSizer1->Add(StaticText7, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	Ax_ctrl = new wxTextCtrl(this, ID_TEXTCTRL5, _("-"), wxDefaultPosition, wxSize(509,23), wxTE_MULTILINE|wxTE_READONLY|wxVSCROLL, wxDefaultValidator, _T("ID_TEXTCTRL5"));
	Ax_ctrl->SetForegroundColour(wxColour(10,144,49));
	wxFont Ax_ctrlFont(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Ax_ctrl->SetFont(Ax_ctrlFont);
	FlexGridSizer1->Add(Ax_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	StaticText8 = new wxStaticText(this, ID_STATICTEXT8, _("A_Y:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT8"));
	wxFont StaticText8Font(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText8->SetFont(StaticText8Font);
	FlexGridSizer1->Add(StaticText8, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	Ay_ctrl = new wxTextCtrl(this, ID_TEXTCTRL6, _("-"), wxDefaultPosition, wxSize(509,24), wxTE_MULTILINE|wxTE_READONLY|wxVSCROLL, wxDefaultValidator, _T("ID_TEXTCTRL6"));
	Ay_ctrl->SetForegroundColour(wxColour(7,136,11));
	wxFont Ay_ctrlFont(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Ay_ctrl->SetFont(Ay_ctrlFont);
	FlexGridSizer1->Add(Ay_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	Button5 = new wxButton(this, ID_BUTTON5, _("Make New Key"), wxDefaultPosition, wxSize(117,28), 0, wxDefaultValidator, _T("ID_BUTTON5"));
	wxFont Button5Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button5->SetFont(Button5Font);
	FlexGridSizer1->Add(Button5, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	allDomains = new wxCheckBox(this, ID_CHECKBOX1, _("allow other domains for new key"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_CHECKBOX1"));
	allDomains->SetValue(false);
	wxFont allDomainsFont(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	allDomains->SetFont(allDomainsFont);
	FlexGridSizer1->Add(allDomains, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	Button2 = new wxButton(this, ID_BUTTON2, _("Store internally"), wxDefaultPosition, wxSize(119,23), 0, wxDefaultValidator, _T("ID_BUTTON2"));
	Button2->SetBackgroundColour(wxColour(195,221,244));
	wxFont Button2Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button2->SetFont(Button2Font);
	FlexGridSizer1->Add(Button2, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	PubAlso = new wxCheckBox(this, ID_CHECKBOX2, _("Store Public part also"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_CHECKBOX2"));
	PubAlso->SetValue(true);
	wxFont PubAlsoFont(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	PubAlso->SetFont(PubAlsoFont);
	FlexGridSizer1->Add(PubAlso, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	Button3 = new wxButton(this, ID_BUTTON3, _("Export Publ. Part"), wxDefaultPosition, wxSize(121,24), 0, wxDefaultValidator, _T("ID_BUTTON3"));
	Button3->SetBackgroundColour(wxColour(164,250,171));
	wxFont Button3Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Arial"),wxFONTENCODING_DEFAULT);
	Button3->SetFont(Button3Font);
	FlexGridSizer1->Add(Button3, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	Button8 = new wxButton(this, ID_BUTTON8, _("Import Secret Key from File"), wxDefaultPosition, wxSize(248,25), 0, wxDefaultValidator, _T("ID_BUTTON8"));
	Button8->SetBackgroundColour(wxColour(251,252,184));
	wxFont Button8Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button8->SetFont(Button8Font);
	FlexGridSizer1->Add(Button8, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	Button10 = new wxButton(this, ID_BUTTON10, _("produce internal\nPublic Key entry"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON10"));
	Button10->SetBackgroundColour(wxColour(192,226,243));
	wxFont Button10Font(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button10->SetFont(Button10Font);
	FlexGridSizer1->Add(Button10, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	Button7 = new wxButton(this, ID_BUTTON7, _("Export Secret Key to File"), wxDefaultPosition, wxSize(247,27), wxDOUBLE_BORDER, wxDefaultValidator, _T("ID_BUTTON7"));
	Button7->SetBackgroundColour(wxColour(249,233,233));
	wxFont Button7Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button7->SetFont(Button7Font);
	FlexGridSizer1->Add(Button7, 1, wxALL|wxALIGN_RIGHT|wxALIGN_TOP, 5);
	SetSizer(FlexGridSizer1);
	Timer1.SetOwner(this, ID_TIMER1);
	Timer1.Start(6000, false);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ellip_ky_sav::OnCancel);
	Connect(ID_TEXTCTRL4,wxEVT_COMMAND_TEXT_ENTER,(wxObjectEventFunction)&ellip_ky_sav::On_A_refresh);
	Connect(ID_BUTTON9,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ellip_ky_sav::OnShowprivkey);
	Connect(ID_BUTTON6,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ellip_ky_sav::OnLoadFromFile);
	Connect(ID_BUTTON4,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ellip_ky_sav::On_A_refresh);
	Connect(ID_BUTTON5,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ellip_ky_sav::OnMakeNewKey);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ellip_ky_sav::OnStore);
	Connect(ID_BUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ellip_ky_sav::OnPublicElPartExport);
	Connect(ID_BUTTON8,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ellip_ky_sav::OnImportprivkey);
	Connect(ID_BUTTON10,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ellip_ky_sav::OnMakePubEntry);
	Connect(ID_BUTTON7,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ellip_ky_sav::OnExportSecret);
	Connect(ID_TIMER1,wxEVT_TIMER,(wxObjectEventFunction)&ellip_ky_sav::OnTimer1Trigger);
	//*)

	//fill all fields with default values
	//id
	stretchfac= 50;  //soll 50
	half_min_counter=0;
	id_ctrl->SetValue(elky.id);
	fullname_ctrl->SetValue(elky.fullnam);
	domnam_ctrl->SetValue(elky.domnam);
	wxString number;
	elky.d.writehex(&number);
	d_ctrl->SetValue(number);
	//get corresponding domain
	if(elky.domnam == gdom.name) locell.copyell(&gdom);
	else
	{
        elfl=e_ls.getelp(&locell,elky.domnam);
        if(elfl<0)
        {
            throwout(_("Domain of Key unknown!\nMust import key-domain first\ncannot use key."),8);
            locell.copyell(&gdom);
        }
	}

	//build Ax and Ay
    elky.A.copy_ep(&(locell.d0));
    elky.A.mult_p_qj(&(elky.d),&(locell));
    //und eintragen
	elky.A.x.writehex(&number);
	Ax_ctrl->SetValue(number);
	idext=_("-") + number.Left(2);
	elky.A.y.writehex(&number);
	Ay_ctrl->SetValue(number);
	idext += number.Left(2);
	currdom_ctrl->SetValue(gdom.name);

    if(!wxDirExists(kytray))
    {
        //select one
        loctray=wxDirSelector(_("key_tray folder not found, select alternative!"));
        if(loctray == _(""))       //.IsEmpty() )
        {
            throwout(_("Aborting"),1);
            return;
        }
        else kytray=loctray + wxFileName::GetPathTerminators();
    }


nostop=false;
}
/*****************************************************/
ellip_ky_sav::~ellip_ky_sav()
{
	//(*Destroy(ellip_ky_sav)
	//*)
}
/*************************************************************/
void ellip_ky_sav::OnCancel(wxCommandEvent& event)
{
    Close();
}
/****************************************************************/
void ellip_ky_sav::OnStore(wxCommandEvent& event)
{
    wxString txt,txd, idext2;
    wxString h2;
    FILE *knamfil, *kfil;
    int res_here,answer;
    longnumber tempd;

nostop=true;
    half_min_counter=0;
    if(!checkarm()){Close();}
    //extract d
    txt=d_ctrl->GetLineText(0);
    if(!((elky.d).storhex(&txt))) //da muss hex ausgelesen werden
    {
        throwout(_("error reading elliptic privKey d"));
        return;
    }
        //extract name & id
    elky.id=id_ctrl->GetLineText(0);
    elky.fullnam=fullname_ctrl->GetLineText(0);
    //check if names were set
    if(elky.id.Left(3)==_("ID?"))  //first three chars are ID?
    {
        throwout(_("Surely you don't want to save a key with ID \"ID?...\" \nPlease select reasonable ID and Name!"),20);
        nostop=false;
        return;
    }
    if(elky.fullnam==_("NAME?"))  //first three chars are ID?
    {
        throwout(_("Surely you don't want to save a key with Name \"NAME?...\" \nPlease fill in your true Name!"),20);
        nostop=false;
        return;
    }
    //get current ID extension
    idext2=elky.id.Right(5);
    if(idext != idext2) //improper idext
    {
        AskDialog adlg(this, _("improper ID extension!\n Do you want to enforce it?"));
        answer=adlg.ShowModal();
        if(answer == 0)
        {
            throwout(_("Fixing, then proceeding"),2);
            //if "-" ext present, replace last four chars
            if(idext2.Left(1) == _("-")) //incorrect ext
            {
                elky.id.Replace(idext2,idext);
            }
            else //ext missing -> add
            {
                elky.id += idext;
            }
            //update ID text field
            id_ctrl->SetValue(elky.id);
        }
        else
        {
            throwout(_("Well then, so be it.....\ndon't complain about ID collisions later!"));
        }
    }

    //if not there append the chars from public key
    //change blanks to underscore
    (elky.id).Replace(_(" "),_("_"));
    elky.fullnam=fullname_ctrl->GetLineText(0);
    (elky.fullnam).Replace(_(" "),_("_"));
    elky.domnam= domnam_ctrl->GetLineText(0);
    //check for ID already in use
    res_here=keyid_free(elky.id,false);
    if((res_here & 1) == 1)
    {
        throwout(_("ID in use already for private key\nYou should try another Key ID!"),20);
        return;
    }
    if((res_here & 2) == 2)
    {
        throwout(_("ID in use already for publice key\nYou should try another Key ID!"),20);
        return;
    }
    //open keynamfile, append name and id, close keynamfile
    if(S_FIL) unlockinplace(sec_path + _("/ell_knamfile.knf"),&zugang); // unlock keynamefile
    h2= sec_path + _("/ell_knamfile.knf");
    if((knamfil = fopen((const char*)h2.mb_str(wxConvLocal),"a"))== NULL) return;
    fprintf(knamfil, "\n id: %s  Name: %s  ",(const char*)elky.id.mb_str(wxConvUTF8),
                  (const char*)elky.fullnam.mb_str(wxConvUTF8));
    fclose(knamfil);
    if(S_FIL) lockinplace(sec_path + _("/ell_knamfile.knf"),&zugang); // lock again

    //open keyfile, store all data and close
    if(S_FIL) unlockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // unlock keynamefile
    h2= sec_path + _("/ell_Keyfile.kyf");
    if((kfil = fopen((const char*)h2.mb_str(wxConvLocal), "a"))== NULL) return;
    fprintf(kfil, "\n id: %s  Name: %s DomainName: %s",(const char*)elky.id.mb_str(wxConvUTF8),
                  (const char*)elky.fullnam.mb_str(wxConvUTF8),(const char*)elky.domnam.mb_str(wxConvUTF8));
    // doublecrypt: hier vorher extra verschlüsseln
    tempd.copynum(&(elky.d));
    tempd.shrinktofit();
    tempd.lonu_lock(&zugang);
    tempd.writehex(&txd);
    //elky.d.writehex(&txd);
    fprintf(kfil,"\n d: %s ", (const char*)txd.mb_str(wxConvUTF8));
    fprintf(kfil," \n");
    fclose(kfil);
    if(S_FIL) lockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // unlock keynamefile
    throwout(_("Private key securely stored\n in internal storage"),3);
    if(PubAlso)
    {
    //refresh public part
      On_A_refresh(event);
    //store public part

      if(S_FIL) unlockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // unlock keynamefile
      if((knamfil = fopen((const char*)(sec_path + _("/e_ell_knamfile.knf")).mb_str(wxConvLocal), "a"))== NULL) return;
      fprintf(knamfil, "id: %s  Name: %s  \n",(const char*)(elky.id).mb_str(wxConvUTF8),
                  (const char*)(elky.fullnam).mb_str(wxConvUTF8));
      fclose(knamfil);
      if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock again

    // to do: decrypt keyfile
    //open keyfile, store all data and close
      if(S_FIL) unlockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // unlock keynamefile
      if((kfil = fopen((const char*)(sec_path + _("/e_ell_Keyfile.kyf")).mb_str(wxConvLocal), "a"))== NULL) return;
      fprintf(kfil, "id: %s  Name: %s DomName: %s\n",(const char*)(elky.id).mb_str(wxConvUTF8),
                  (const char*)(elky.fullnam).mb_str(wxConvUTF8),(const char*)(elky.domnam).mb_str(wxConvUTF8) );
      (elky.A.x).writehex(&txt);
      (elky.A.y).writehex(&txd);

      fprintf(kfil,"Ax: %s \n Ay: %s \n \n", (const char*)txt.mb_str(wxConvUTF8), (const char*)txd.mb_str(wxConvUTF8));
      fclose(kfil);
      if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // unlock keynamefile
      throwout(_("public key also file saved to \nprotected internal storage!"),2);
    }
    half_min_counter = 0;
    nostop=false;
    return;
}
/************************************************************/
void ellip_ky_sav::On_A_refresh(wxCommandEvent& event)
{
    wxString txt;
    e_p PA;
    longnumber old_d;

nostop=true;
    half_min_counter=0;
    if(!checkarm()){Close();}
    old_d.copynum(&(elky.d));
    //aktuelles d einlesen
    txt=d_ctrl->GetLineText(0);
    if(!((elky.d).storhex(&txt))) //da muss hex ausgelesen werden
    {
        throwout(_("error reading elliptic privKey d\n keeping original"));
        //zuruecksetzen
        old_d.writehex(&txt);
        d_ctrl->SetValue(txt);
        old_d.wipezero();
        return;
    }
    old_d.wipezero(); // zur sicherheit
    //checken, ob in dieser domain zu groß
    if(locell.q.compare(&(elky.d)) <= 0)
    {
        throwout(_("Warning! d too large for domain, modreduced!"));
        elky.d.lonumodulo_qqq(&(locell.q));
    }
    elky.d.writehex(&txt);
    d_ctrl->SetValue(txt);
    //A aus aktueller domain berechnen
    elky.A.copy_ep(&(locell.d0));
    elky.A.mult_p_qj(&(elky.d),&(locell));
    //und eintragen
    elky.A.x.writehex(&txt);
    idext= _("-") + txt.Left(2);
    Ax_ctrl->SetValue(txt);
    elky.A.y.writehex(&txt);
    idext += txt.Left(2);
    Ay_ctrl->SetValue(txt);
    //aktuelle Domain aktualisieren
    domnam_ctrl->SetValue(locell.name);
    half_min_counter = 0;
nostop=false;
    return;
}
/***************************************************************/
void ellip_ky_sav::OnMakeNewKey(wxCommandEvent& event)
{
    longnumber nk;
    wxString txt;
    int res;

nostop=true;
    half_min_counter=0;
    if(!checkarm()){Close();}
    locell.copyell(&gdom);
    //if selected ask for other domain
    if(allDomains->IsChecked())
    {
        //select active domain
        DomainSelector dialog(this);
        res=dialog.ShowModal();
        if(res<0)
        {
            throwout(_("no new domain selected\nleave old default."),2);
        }
        //else load new domain locally and use
        else
        {
            elfl=e_ls.getelp(&locell,(*(e_ls.rpt+res))->name);
            if(elfl<0)
            {
                throwout(_("Domain of Key unknown!\nMust import key-domain first\nusing default domain instead."),8);
                locell.copyell(&gdom);
            }
        }

    }

    zuf.p_makerandom(&nk,(int)((locell.q).size+3));
    nk.randomize(2);
    nk.lonumodulo_qqq_e(&(locell.q));
    nk.writehex(&txt);
    d_ctrl->SetValue(txt);
    fullname_ctrl->SetValue(_("NAME?"));
    domnam_ctrl->SetValue(locell.name);
    //gdom.copyell((*(e_ls.rpt + res)));
    //currdom_ctrl->SetValue((*(e_ls.rpt + res))->name);
    //A aus aktueller domain berechnen
    //elky.A.copy_ep(&(gdom.d0));
    //elky.A.mult_p_q(&(elky.d),&(gdom));
    On_A_refresh( event);
    id_ctrl->SetValue(_("ID?") + idext);
    currdom_ctrl->SetValue(gdom.name);
nostop=false;
    return;
}
/***************************************************************/
void ellip_ky_sav::OnLoadFromFile(wxCommandEvent& event)
//load from internal storage
{
            // neuer Dialog
nostop= true;
    half_min_counter=0;
    if(!checkarm()){Close();}
    ellky_load1 dialog(this);
    dialog.ShowModal();
    // ende Dialog
    //alles korrekt eintragen
	id_ctrl->SetValue(elky.id);
	fullname_ctrl->SetValue(elky.fullnam);
	domnam_ctrl->SetValue(elky.domnam);
	wxString number;
	elky.d.writehex(&number);
	d_ctrl->SetValue(number);
	//get corresponding domain
	if(elky.domnam == gdom.name) locell.copyell(&gdom);
	else
	{
        elfl=e_ls.getelp(&locell,elky.domnam);
        if(elfl<0)
        {
            throwout(_("Domain of Key unknown!\nMust import key-domain first\ncannot use key."),8);
            locell.copyell(&gdom);
        }
	}
	//jetzt A ermitteln
    On_A_refresh( event);
nostop=false;
    return;
}
/****************************************************************/
void ellip_ky_sav::OnPublicElPartExport(wxCommandEvent& event)
{
    FILE *exfil;
    char buff[3202];
    wxString hlp,keyfilename,errmsg,exdir,sep;
    int res;

nostop=true;
    if(!checkarm()){Close();}

    //if not in private abort
    if(priv_keyid_free(elky.id,false))
    {
            throwout(_("There is not yet a private key stored locally with this ID!\nExporting public part doesn't make sense!\nPlease store private Key first, Aborting!"),5);
            return;
    }
    throwout(_("refreshing public component"),1);
    On_A_refresh( event);

    hlp=id_ctrl->GetLineText(0) +_(".pell");
    hlp.Replace(_(" "),_("_"));
    if(hlp.Len()>600) hlp.Truncate(600);
    keyfilename=hlp;
    //get directory
    sep=wxFileName::GetPathTerminators();
/******
    wxDirDialog dlg(NULL, _("Choose writeout directory"),kytray, wxDD_DEFAULT_STYLE);
    res= dlg.ShowModal();
    if(res== wxID_OK) //user slected a directory
    {
        exdir=dlg.GetPath();
    }
    else
    {
        throwout(_("cancelled, aborting"),2);
        return;
    }
    ****/
    exdir=wxFileSelector(_("Choose filename for export, please leave \".pell\" extension."),kytray,elky.id,_(".pell"),_("*.pell"),wxFD_SAVE|wxFD_OVERWRITE_PROMPT);
    if ( exdir.empty() )
    {
        throwout(_("cancelled\naborting."),3);
        return;
    }
    if(exdir.Len()>800)
    {
        throwout(_("more than 800 byte Filename! Are you nuts?\naborting."),5);
        return;
    }
    //strcpy(buff, (const char*) (exdir+sep+hlp).mb_str(wxConvLocal));
    strcpy(buff, (const char*) (exdir).mb_str(wxConvLocal));
    exfil=fopen(buff, "w");
    if(exfil==NULL)
    {
        errmsg=_("Error!\nCannot open file in selected directory\nPlease check if directory exists!\nexpected: ");
        errmsg += exdir;
        errmsg += _("\naborting!");
        throwout(errmsg);
        return;
    }
    hlp=id_ctrl->GetLineText(0);
    hlp.Replace(_(" "),_("_"));
    if(hlp.Len()>600) hlp.Truncate(600);
    strcpy(buff, (const char*) (hlp).mb_str(wxConvUTF8));
    fprintf(exfil,"ID_of_key: %s \n",buff);

    hlp=fullname_ctrl->GetLineText(0);
    hlp.Replace(_(" "),_("_"));
    if(hlp.Len()>600) hlp.Truncate(600);
    strcpy(buff, (const char*) (hlp).mb_str(wxConvUTF8));
    fprintf(exfil,"Name_of_Keyholder: %s \n",buff);

    elky.domnam= domnam_ctrl->GetLineText(0);
    hlp=elky.domnam;
    hlp.Replace(_(" "),_("_"));
    if(hlp.Len()>600) hlp.Truncate(600);
    strcpy(buff, (const char*) (hlp).mb_str(wxConvUTF8));
    fprintf(exfil,"EllipCurve_Domain_Name: %s \n",buff);

    elky.A.x.writehex(&hlp);
    if(hlp.Len()>600) hlp.Truncate(600);
    strcpy(buff, (const char*) (hlp).mb_str(wxConvUTF8));
    fprintf(exfil,"Ax: %s \n",buff);
    elky.A.y.writehex(&hlp);
    if(hlp.Len()>600) hlp.Truncate(600);
    strcpy(buff, (const char*) (hlp).mb_str(wxConvUTF8));
    fprintf(exfil,"Ay: %s \n",buff);
    fclose(exfil);
    throwout(_("Public key exported to \n\n") + exdir, 5);
    half_min_counter = 0;
nostop=false;
    return;
}
/**************************************************************/

void ellip_ky_sav::OnExportSecret(wxCommandEvent& event)
{
    FILE *pkf;
    longnumber kciph,loczug,loc_salt;
    wxString h,h1,txt,npw,exportdir,sep;
    int res,newpw,npwentered;
    //char buff[200];

    // first refresh elky from fields!
    //extract d
 nostop=true;
    half_min_counter=0;
    if(!checkarm()){Close();}
    txt=d_ctrl->GetLineText(0);
    if(!((elky.d).storhex(&txt))) //da muss hex ausgelesen werden
    {
        throwout(_("error reading elliptic privKey d"));
        return;
    }
        //extract name & id
    elky.id=id_ctrl->GetLineText(0);
    elky.fullnam=fullname_ctrl->GetLineText(0);
    //check if names were set
    if((elky.id.Left(3)==_("ID?"))||(elky.fullnam==_("NAME?")))
    {
        throwout(_("Surely you don't want to export a key with ID \"ID?\"\nand Name \"NAME?\"\nPlease select reasonable ID and Name!"),20);
        nostop=false;
        return;
    }
    //change blanks to underscore
    (elky.id).Replace(_(" "),_("_"));
    elky.fullnam=fullname_ctrl->GetLineText(0);
    (elky.fullnam).Replace(_(" "),_("_"));
    elky.domnam= domnam_ctrl->GetLineText(0);
    AskInput idlg(this,_("Give key_export password:"),&npw);
    npwentered=idlg.ShowModal();
    if(npwentered==1)
        {
            loc_salt.makerandom(ss_klen);
            //prior normalization of salt
            loc_salt.setsize(true);
            loc_salt.shrinktofit(2);
            if(!kyprep(&loczug,&npw,&loc_salt,&stretch_ell,stretchfac,ss_klen))  //changed stretch to 150
            {
                throwout(_("error, key preparation failed"));
                return;
            }
        }
    else return;
    //open file keyname.prv
    h1=elky.id + _(".prv");
    sep=wxFileName::GetPathTerminators();


    //get filename and path to export
    /** wxDirDialog exdlg(NULL, _("Choose writeout directory"),kytray, wxDD_DEFAULT_STYLE);
    res= exdlg.ShowModal();
    if(res== wxID_OK) //user slected a directory
    {
        exportdir=exdlg.GetPath();
        throwout(_("you selected: \n")+exportdir,20);
    }
    else
    {
        throwout(_("cancelled, aborting"),2);
        return;
    }
    if((pkf=fopen((const char*)(exportdir+sep+h1).mb_str(wxConvLocal),"w")) == NULL)
    {
        throwout(_("Error! opening file failed!?!"));
        return;
    }  ***/
    exportdir=wxFileSelector(_("Choose folder and name for export (\".ciph\" will be added)"),kytray,elky.id,_(""),_(""),wxFD_SAVE);
    if(wxFile::Exists(exportdir + _(".ciph")))
    {
        throwout(_("Name collision for key cipher!\n")+exportdir + _(".ciph")+_(" already exixts.\nChose other name, aborting"));
        return;
    }
    if ( exportdir.empty() )
    {
        throwout(_("cancelled\naborting."),3);
        return;
    }
    if((pkf=fopen((const char*)(exportdir).mb_str(wxConvLocal),"w")) == NULL)
    {
        throwout(_("Error! opening file failed!?!"));
        return;
    }
    fprintf(pkf,"id: %s \n",(const char*)elky.id.mb_str(wxConvUTF8));
    fprintf(pkf,"fullnam: %s \n",(const char*)elky.fullnam.mb_str(wxConvUTF8));
    fprintf(pkf,"domnam: %s \n",(const char*)elky.domnam.mb_str(wxConvUTF8));
    kciph.copynum( &(elky.d));
    if(!kciph.lonu_lock(&loczug,_("Fleas_o5")))
    {
        throwout(_("Security Alert!\n could not encipher private key on level 2\ncheck and delete file fragments manually!"));
        fclose(pkf);
        return;
    }
    kciph.writehex(&h);
    fprintf(pkf,"d: %s ",(const char*)h.mb_str(wxConvUTF8));
    fclose(pkf);
    if(S_FIL)
    {
        //if(!lockinplace(exportdir+sep+h1,&loczug,_("Fleas_o5")))  //back to Fleas_05
        if(!lockinplace(exportdir,&loczug,_("Fleas_o5")))  //back to Fleas_05
        {
           throwout(_("Security Alert!\n could not lock private keyfile\ncheck and delete file fragments manually!"));
        }
        //prepend salt:  algo:
        //open file keyname.pre
        //h1=exportdir+sep+ elky.id + _(".pre");
        h1=exportdir+ _("pre");
        if((pkf=fopen((const char*)h1.mb_str(wxConvLocal),"w")) == NULL)
        {
            throwout(_("Error! opening prepend-file failed!?!"));
            return;
        }
        wxString salt_str;
        loc_salt.writehex(&salt_str);
        fprintf(pkf,"salt: %s \n",(const char*)salt_str.mb_str(wxConvUTF8));
        fprintf(pkf,"algo: Fleas_o5 \n");  //later back to Fleas_o5
        fprintf(pkf,"stretch: %i %s \n",stretchfac, (const char*)(stretch_ell.name).mb_str(wxConvUTF8));
        fclose(pkf);
        //concat
        //if(!fileconcat(h1, exportdir+sep+elky.id + _(".prv_o5"), exportdir+sep+elky.id +_(".ciph"), _("end_header_info::"))) //back to prv_o5
        if(!fileconcat(h1, exportdir + _("_o5"), exportdir +_(".ciph"), _("end_header_info::"))) //back to prv_o5
        {
          throwout(_("Error!\nFailed to create ciph-file from components"),20);
        }
        else throwout(_("private key cipher created \nin selected directory!"),2);
        //delete concat wells
        wxRemoveFile(h1);
        //wxRemoveFile(exportdir+sep+elky.id + _(".prv_o5")); //back to prv_o5
        wxRemoveFile(exportdir + _("_o5")); //back to prv_o5
        loczug.wipezero();
    }
    throwout(_("Secret key exported to \n\n") +exportdir + _(".ciph") +_("\n\n,a Fleas_o5 encrypted file for transfer to other \ninstallation of academic signature"),8);
    half_min_counter = 0;
nostop=false;
    return;
}
/********************************************************************/

void ellip_ky_sav::OnImportprivkey(wxCommandEvent& event)
{
    wxString importfile,outfile,h,c_ext,algo,kpath;
    el_priv loky;
    wxString txa,tya;
    FILE  *pkf;
    char buff1[1604],buff3[2048];
    int rcnt,i, loc_stretch;
    bool dom_match=true, loadsuccess=false;
    longnumber oldphrase;

    longnumber loc_salt;
    wxString loc_se_id=_("empty"),hs;
    bool st_and_salt=false;
    ellipse *loc_se_pt;
    wxString headnam;
    wxString ciphnam;

nostop=true;
    half_min_counter=0;
    if(!checkarm()){Close();}
/*
    throwout(_(" Inactive for security reasons\n must manually copy and paste from dialog window \nif necessary!"));
    return;
*/
    importfile = wxFileSelector(_("Choose a file to import"),kytray,_(""),_("ciph|prv_o5"),_("salted&stretched (*.ciph)|*.ciph|o5 encoded nude(*.prv_o5)|*.prv_o5"));
    if(importfile.IsEmpty())
    {
        wxMessageBox(_("importfile doesn't exist!\nDo nothing!"));
        return;
    }
    //decide which algo according to last two chars
    c_ext= importfile.Right(5);
    if(c_ext== _(".ciph"))
    {
        //salted,stretched o5
        //separate files
       kpath=((wxFileName) importfile).GetPath(wxPATH_GET_VOLUME|wxPATH_GET_SEPARATOR);
       headnam= ((wxFileName) importfile).GetName();
       ciphnam=headnam + _(".prv");
       headnam= headnam +_(".head");
       //get filenames without path
       if(!splicefile(importfile, headnam, ciphnam, _("end_header_info::")))
       {
        throwout(_("Splicing cipher file not successful\nAborting"),20);
        return;
       }
        //read pars to loc
        pkf=fopen((const char*)(kpath+headnam).mb_str(wxConvLocal), "r");
        if(pkf==NULL){throwout(_("error opening head-file of cipher"),4); return;}
        rcnt= fscanf(pkf,"salt: %400s ",buff1);
        if(rcnt != 1) {throwout(_("error reading salt"),4); fclose(pkf); return;}
        hs=wxString::FromUTF8(buff1);
        loc_salt.storhex(&hs);

        rcnt= fscanf(pkf,"algo: %400s ",buff1);
        if(rcnt != 1) {throwout(_("error reading algo"),4); fclose(pkf); return;}
        algo=wxString::FromUTF8(buff1);

        rcnt= fscanf(pkf,"stretch: %i ",&loc_stretch);
        if(rcnt != 1) {throwout(_("error reading stretch"),4); fclose(pkf); return;}

        rcnt= fscanf(pkf,"%400s ",buff1);
        if(rcnt != 1) {throwout(_("error reading stretch_ell id"),4); fclose(pkf); return;}
        loc_se_id=wxString::FromUTF8(buff1);
        fclose(pkf);
        loc_se_pt = &stretch_ell;
        if(loc_se_id != stretch_ell.name) //if unusual stretcher ellipse
        {
            throwout(_("Warning!\n unusual stretcher ellipse."),3);
            if(e_ls.getelp(loc_se_pt, loc_se_id)==-1)
            {
                throwout(_("Error: unknown stretch ellipse!,\naborting!"),5);
                return;
            }
        }

        outfile=importfile.Left(importfile.Len()-5) +_(".prv");
        //delete rest
        //st_and_salt=wxRemoveFile(importfile);
        headnam=((wxFileName) importfile).GetPath(wxPATH_GET_VOLUME|wxPATH_GET_SEPARATOR) +headnam;
        st_and_salt=wxRemoveFile(headnam);
        st_and_salt=true;
    }
    else{
      c_ext= importfile.Right(3);
      algo=_("Fleas_o5");

      if(c_ext == _("_x5")) algo=_("Fleas_x5");
      if(c_ext == _("_o5")) algo=_("Fleas_o5");
      else throwout(_("warning: could not determine\nsymmetric algorithm\nguessing"),1);
      outfile=importfile.Left(importfile.Len()-3);
    }


    wxPasswordEntryDialog mypw(this,_("Give private key export passwd!"), _("Passphrase Dialog"));
    mypw.ShowModal();
    h=mypw.GetValue();
    if(h.IsEmpty())
    {
       throwout(_("Empty passphrase - aborting"),3);
       //oldphrase.copynum(&zugang); //later introduce dialog
       return;
    }
    else oldphrase.stortext(&h);
    //reform key
    if(st_and_salt)
    {
        //reform key
        //prior normalization of salt
        loc_salt.setsize(true);
        loc_salt.shrinktofit(2);
        if(! kyprep(&oldphrase, &h, &loc_salt, loc_se_pt, loc_stretch, ss_klen ))
        {
            throwout(_("Error!\nCould not prepare key\naborting"),3);
            return;
        }
    }
    //rename cipherfile
    wxString addendum=_("_o5");
    if(algo== _("Fleas_3")) addendum= _("_f3");
    else if(algo== _("Fleas_o5")) addendum=_("_o5");
    else if(algo== _("Fleas_1_8")) addendum= _("_c3");
    else if(algo== _("Fleas_4"))  addendum= _("_f4");
    else if(algo== _("Fleas_5"))  addendum=_("_f5");
    else if(algo== _("Fleas_x2")) addendum= _("_x2");
    else if(algo== _("Fleas_x5")) addendum= _("_x5");
    else if(algo== _("Fleas_o2")) addendum= _("_o2");
    else if(algo== _("Fleas_l"))  addendum= _("_l");
    else if(algo== _("Fleas_ls")) addendum= _("_ls");
    else if(algo ==_("Fleas_l3")) addendum= _("_l3");
    else if(algo ==_("Fleas_lb")) addendum= _("_lb");
    else if(algo ==_("Fleas_lc")) addendum= _("_lc");
    else if(algo ==_("Fleas_ld")) addendum= _("_ld");
    else if(algo== _("aes"))      addendum= _("_ae");
    else if(algo ==_("F_cnt_1c")) addendum= _("_1c");
    else if(algo ==_("F_cnt_1d")) addendum= _("_1d");
    else if(algo ==_("F_cnt_1b")) addendum= _("_1b");
    else if(algo ==_("threefish")) addendum= _("_tf");
    else if(algo ==_("chimera")) addendum= _("_ff");
    else
    {
        throwout(_("Alert! Unknown Algorithm, \nCannot unlock!"));
        return;
    }
    wxRenameFile(kpath+ciphnam,kpath+ciphnam+addendum);



    if(!unlockinplace(outfile,&oldphrase,algo))
    {
        wxMessageBox(_("could not unlock importfile!\nDo nothing!"));
        return;
    }
    if((pkf=fopen((const char*)outfile.mb_str(wxConvLocal),"r")) == NULL)
    {
        throwout(_("Error! opening unlocked Importfile failed!?!"));
        return;
    }
    loadsuccess=true;
    rcnt=fscanf(pkf,"id: %400s \n",buff1);
    if(rcnt==1)
    {
        loky.id=wxString::FromUTF8(buff1);
    }
    else loadsuccess=false;

    rcnt=fscanf(pkf,"fullnam: %400s \n",buff1);
    if(rcnt==1)
    {
        loky.fullnam=wxString::FromUTF8(buff1);
    }
    else loadsuccess=false;

    rcnt=fscanf(pkf,"domnam: %400s \n",buff1);
    if(rcnt==1)
    {
        loky.domnam=wxString::FromUTF8(buff1);
        if(! e_ls.isinlist(loky.domnam))
        {
            throwout(_("unknown key domain\ncannot use key\nmust import domain first"));
            dom_match = false;
        }
    }
    else loadsuccess=false;

    rcnt=fscanf(pkf,"d: %2048s \n",buff3);
    if(rcnt==1)
    {
        h=wxString::FromUTF8(buff3);
        if(!loky.d.storhex(&h))
        {
           throwout(_("hexnumber conversion error\n aborting"));
           loadsuccess=false;
        }
    }
    else loadsuccess=false;
    fclose(pkf);
    if(st_and_salt) wxRemoveFile( outfile); //if ciph format
    else                                    //if nude prv file
    {
      if( !lockinplace(outfile,&oldphrase,algo))
      {
        throwout(_("Security Alert!\n Could not lock keyfile again.\nMust remove fragments manually!!"));
      }
    }
    if(!loadsuccess) return;
    //convert d
    if( !loky.d.lonu_unlock(&oldphrase,algo) )
    {
        throwout(_("lonu unlocking error\n aborting"));
        return;
    }
    if(dom_match)
    {
      //copy to elky
      elky.copy_priv_ky(&loky);
          //warn if already present in priv and not in pub
      if(  pub_keyid_free(elky.id,false) && !priv_keyid_free(elky.id,false)) //dangerous configuration, issue a warning
      {
        throwout(_("Warning:\nThis Private Key ID is already in store, Public Key ID is free.\nto ensure sanity, key ID was changed immediately."),20);
        i=0;
        do
            {
                elky.id += _("x");
                i++;
            } while( (pub_keyid_free(elky.id,false) && !pub_keyid_free(elky.id,false)) && i<4);
        if(i>=4)
        {
            throwout(_("Are you Nuts !\nAborting."),20);
            return;
        }
      }
      throwout(_("Done, now don't forget to save locally!"),4);
      //put into dialog fields
	  id_ctrl->SetValue(elky.id);
	  fullname_ctrl->SetValue(elky.fullnam);
	  domnam_ctrl->SetValue(elky.domnam);
	  //load domain into locell
      e_ls.getelp(&locell,elky.domnam);
	  wxString number;
	  elky.d.writehex(&number);
	  d_ctrl->SetValue(number);
	  //jetzt A ermitteln
      On_A_refresh( event);
    }
    else throwout(_("cannot use key!\nDomain unknown."),3);
nostop=false;
}
/*******************************************************************/
void ellip_ky_sav::OnTimer1Trigger(wxTimerEvent& event)
{
    half_min_counter++;
    if((half_min_counter > 30)&&(!nostop)) //mehr als 3 Minuten idle
    {
        unarm();
        Close();
    }
    return;
}
/******************************************************/

void ellip_ky_sav::OnShowprivkey(wxCommandEvent& event)
{
    int re;
    wxString prvhex;

    half_min_counter=0;
    if(!checkarm()){Close();}
nostop=true;
    prvhex=d_ctrl->GetLineText(0);
    PWShow dialog(&prvhex, this);
    re=dialog.ShowModal();
    if(re==1)
    {
        d_ctrl->SetValue(prvhex);
        On_A_refresh( event);
    }
    nostop=false;
    return;
}
/***************************************************************************/
void ellip_ky_sav::OnMakePubEntry(wxCommandEvent& event)
{
    wxString txt,txd;
    wxString h2;
    FILE *knamfil, *kfil;
    int lbl;
    longnumber tempd;

nostop=true;
    half_min_counter=0;
    if(!checkarm()){Close();}

    txt=d_ctrl->GetLineText(0);
    if(!((elky.d).storhex(&txt))) //da muss hex ausgelesen werden
    {
        throwout(_("error reading elliptic privKey d"));
        nostop=false;
        return;
    }
        //extract name & id
    elky.id=id_ctrl->GetLineText(0);
    elky.fullnam=fullname_ctrl->GetLineText(0);
    //check if names were set
    if((elky.id.Left(3)==_("ID?"))||(elky.fullnam == _("NAME?")))
    {
        throwout(_("Surely you don't want to save a key with ID \"ID?\"\nand Name \"NAME?\"\nPlease select reasonable ID and Name!"),20);
        nostop=false;
        return;
    }
    //change blanks to underscore
    (elky.id).Replace(_(" "),_("_"));
    elky.fullnam=fullname_ctrl->GetLineText(0);
    (elky.fullnam).Replace(_(" "),_("_"));
    elky.domnam= domnam_ctrl->GetLineText(0);
    //if already in public-> complain
    if(!pub_keyid_free(elky.id,false))
    {
        throwout(_(" Public Key already in use for this ID!\nCannot store internally."),5);
        half_min_counter = 0;
        nostop=false;
        return;
    }
    //if not in private ask for complete
    if(priv_keyid_free(elky.id,false))
    {
            AskDialog adlg(this,_("There is not yet a private key stored locally with this ID!\nShould the private Key be stored as well?"));
            lbl=adlg.ShowModal();
            if(lbl==1)
            {
                OnStore(event);
                nostop=false;
                return;
            }
    }
    //punch public
    //open keynamfile, append name and id, close keynamfile
    {
    //refresh public part
      On_A_refresh(event);
    //store public part

      if(S_FIL) unlockfile(sec_path + _("/e_ell_knamfile.knf"),&zugang); // unlock keynamefile
      if((knamfil = fopen((const char*)(sec_path + _("/e_ell_knamfile.knf")).mb_str(wxConvLocal), "a"))== NULL) return;
      fprintf(knamfil, "id: %s  Name: %s  \n",(const char*)(elky.id).mb_str(wxConvUTF8),
                  (const char*)(elky.fullnam).mb_str(wxConvUTF8));
      fclose(knamfil);
      if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock again

    // to do: decrypt keyfile
    //open keyfile, store all data and close
      if(S_FIL) unlockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // unlock keynamefile
      if((kfil = fopen((const char*)(sec_path + _("/e_ell_Keyfile.kyf")).mb_str(wxConvLocal), "a"))== NULL) return;
      fprintf(kfil, "id: %s  Name: %s DomName: %s\n",(const char*)(elky.id).mb_str(wxConvUTF8),
                  (const char*)(elky.fullnam).mb_str(wxConvUTF8),(const char*)(elky.domnam).mb_str(wxConvUTF8) );
      (elky.A.x).writehex(&txt);
      (elky.A.y).writehex(&txd);

      fprintf(kfil,"Ax: %s \n Ay: %s \n \n", (const char*)txt.mb_str(wxConvUTF8), (const char*)txd.mb_str(wxConvUTF8));
      fclose(kfil);
      if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // unlock keynamefile
      throwout(_("public key also file saved to \nprotected internal storage!"),2);
    }
    half_min_counter = 0;
    nostop=false;
    return;

}
/****************************************************************************/
