/*
 *   Copyright (C) 2011-2019, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#include "enciph_n_authent.h"
#include "helpersxx.h"
#include <wx/filename.h>
#include <wx/ffile.h>
#include <wx/arrstr.h>
#include <wx/dir.h>
#include <wx/busyinfo.h>



#include "ellky_load1.h"
#include "LoadEllKey.h"
#include "AskDialog.h"
#include <wx/filedlg.h>
#include <wx/dirdlg.h>
#include "AskInput.h"
#include "Cap_Questn.h"

//(*InternalHeaders(enciph_n_authent)
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/font.h>
//*)

//(*IdInit(enciph_n_authent)
const long enciph_n_authent::ID_BUTTON1 = wxNewId();
const long enciph_n_authent::ID_STATICTEXT1 = wxNewId();
const long enciph_n_authent::ID_STATICTEXT2 = wxNewId();
const long enciph_n_authent::ID_TEXTCTRL1 = wxNewId();
const long enciph_n_authent::ID_BUTTON2 = wxNewId();
const long enciph_n_authent::ID_STATICTEXT5 = wxNewId();
const long enciph_n_authent::ID_TEXTCTRL4 = wxNewId();
const long enciph_n_authent::ID_BUTTON7 = wxNewId();
const long enciph_n_authent::ID_STATICTEXT3 = wxNewId();
const long enciph_n_authent::ID_TEXTCTRL2 = wxNewId();
const long enciph_n_authent::ID_BUTTON3 = wxNewId();
const long enciph_n_authent::ID_STATICTEXT4 = wxNewId();
const long enciph_n_authent::ID_TEXTCTRL3 = wxNewId();
const long enciph_n_authent::ID_BUTTON4 = wxNewId();
const long enciph_n_authent::ID_CHECKBOX2 = wxNewId();
const long enciph_n_authent::ID_BUTTON5 = wxNewId();
const long enciph_n_authent::ID_NADACHECKBOX = wxNewId();
const long enciph_n_authent::ID_STATICTEXT10 = wxNewId();
const long enciph_n_authent::ID_STATICTEXT11 = wxNewId();
const long enciph_n_authent::ID_BUTTON6 = wxNewId();
const long enciph_n_authent::ID_CHOICE2 = wxNewId();
const long enciph_n_authent::ID_CHOICE1 = wxNewId();
const long enciph_n_authent::ID_TIMER1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(enciph_n_authent,wxDialog)
	//(*EventTable(enciph_n_authent)
	//*)
END_EVENT_TABLE()

enciph_n_authent::enciph_n_authent(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
    if(!checkarm()){Close();}
    half_min_counter=0;
    nostop=true;

	//(*Initialize(enciph_n_authent)
	wxFlexGridSizer* FlexGridSizer1;
	Create(parent, id, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("id"));
	SetBackgroundColour(wxColour(235,236,252));
	FlexGridSizer1 = new wxFlexGridSizer(0, 3, 0, 0);
	Button1 = new wxButton(this, ID_BUTTON1, _("Exit/Cancel"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	Button1->SetBackgroundColour(wxColour(254,199,199));
	wxFont Button1Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button1->SetFont(Button1Font);
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_LEFT|wxALIGN_TOP, 5);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Encipher and Authenticate"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	StaticText1->SetForegroundColour(wxColour(20,99,187));
	wxFont StaticText1Font(14,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText1->SetFont(StaticText1Font);
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	FlexGridSizer1->Add(29,17,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText2 = new wxStaticText(this, ID_STATICTEXT2, _("File to encipher\nand authenticate:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT2"));
	wxFont StaticText2Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText2->SetFont(StaticText2Font);
	FlexGridSizer1->Add(StaticText2, 1, wxALL|wxALIGN_RIGHT|wxALIGN_BOTTOM, 5);
	filnam_ctrl = new wxTextCtrl(this, ID_TEXTCTRL1, _("-"), wxDefaultPosition, wxSize(458,22), 0, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	wxFont filnam_ctrlFont(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	filnam_ctrl->SetFont(filnam_ctrlFont);
	FlexGridSizer1->Add(filnam_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	Button2 = new wxButton(this, ID_BUTTON2, _("select file"), wxDefaultPosition, wxSize(138,32), 0, wxDefaultValidator, _T("ID_BUTTON2"));
	wxFont Button2Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button2->SetFont(Button2Font);
	FlexGridSizer1->Add(Button2, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	StaticText5 = new wxStaticText(this, ID_STATICTEXT5, _("output filename:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT5"));
	wxFont StaticText5Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText5->SetFont(StaticText5Font);
	FlexGridSizer1->Add(StaticText5, 1, wxALL|wxALIGN_RIGHT|wxALIGN_BOTTOM, 5);
	outfnam_ctrl = new wxTextCtrl(this, ID_TEXTCTRL4, _("-"), wxDefaultPosition, wxSize(456,22), 0, wxDefaultValidator, _T("ID_TEXTCTRL4"));
	wxFont outfnam_ctrlFont(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	outfnam_ctrl->SetFont(outfnam_ctrlFont);
	FlexGridSizer1->Add(outfnam_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	Button7 = new wxButton(this, ID_BUTTON7, _("change output folder"), wxDefaultPosition, wxSize(135,31), 0, wxDefaultValidator, _T("ID_BUTTON7"));
	wxFont Button7Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button7->SetFont(Button7Font);
	FlexGridSizer1->Add(Button7, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText3 = new wxStaticText(this, ID_STATICTEXT3, _("Pubkey of recipient:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT3"));
	wxFont StaticText3Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText3->SetFont(StaticText3Font);
	FlexGridSizer1->Add(StaticText3, 1, wxALL|wxALIGN_RIGHT|wxALIGN_BOTTOM, 5);
	pubkey_ctrl = new wxTextCtrl(this, ID_TEXTCTRL2, _("-"), wxDefaultPosition, wxSize(453,22), 0, wxDefaultValidator, _T("ID_TEXTCTRL2"));
	pubkey_ctrl->SetBackgroundColour(wxColour(171,251,198));
	wxFont pubkey_ctrlFont(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	pubkey_ctrl->SetFont(pubkey_ctrlFont);
	FlexGridSizer1->Add(pubkey_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	Button3 = new wxButton(this, ID_BUTTON3, _("sel. key of recipient"), wxDefaultPosition, wxSize(137,34), 0, wxDefaultValidator, _T("ID_BUTTON3"));
	Button3->SetBackgroundColour(wxColour(207,247,217));
	wxFont Button3Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button3->SetFont(Button3Font);
	FlexGridSizer1->Add(Button3, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	StaticText4 = new wxStaticText(this, ID_STATICTEXT4, _("Privkey of signer:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT4"));
	wxFont StaticText4Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText4->SetFont(StaticText4Font);
	FlexGridSizer1->Add(StaticText4, 1, wxALL|wxALIGN_RIGHT|wxALIGN_BOTTOM, 5);
	skid_ctrl = new wxTextCtrl(this, ID_TEXTCTRL3, _("-"), wxDefaultPosition, wxSize(451,22), 0, wxDefaultValidator, _T("ID_TEXTCTRL3"));
	skid_ctrl->SetBackgroundColour(wxColour(250,191,191));
	wxFont skid_ctrlFont(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	skid_ctrl->SetFont(skid_ctrlFont);
	FlexGridSizer1->Add(skid_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	Button4 = new wxButton(this, ID_BUTTON4, _("sel. signing key"), wxDefaultPosition, wxSize(126,32), 0, wxDefaultValidator, _T("ID_BUTTON4"));
	Button4->SetBackgroundColour(wxColour(249,204,204));
	wxFont Button4Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button4->SetFont(Button4Font);
	FlexGridSizer1->Add(Button4, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	detbox = new wxCheckBox(this, ID_CHECKBOX2, _("deterministic signature"), wxDefaultPosition, wxSize(158,22), 0, wxDefaultValidator, _T("ID_CHECKBOX2"));
	detbox->SetValue(false);
	wxFont detboxFont(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	detbox->SetFont(detboxFont);
	FlexGridSizer1->Add(detbox, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	Button5 = new wxButton(this, ID_BUTTON5, _("Do Sign && Enciph"), wxDefaultPosition, wxSize(180,34), 0, wxDefaultValidator, _T("ID_BUTTON5"));
	Button5->SetBackgroundColour(wxColour(36,194,240));
	wxFont Button5Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button5->SetFont(Button5Font);
	FlexGridSizer1->Add(Button5, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	NADA_ChkBox = new wxCheckBox(this, ID_NADACHECKBOX, _("NADA-Capped\?"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_NADACHECKBOX"));
	NADA_ChkBox->SetValue(false);
	wxFont NADA_ChkBoxFont(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	NADA_ChkBox->SetFont(NADA_ChkBoxFont);
	FlexGridSizer1->Add(NADA_ChkBox, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	StaticText10 = new wxStaticText(this, ID_STATICTEXT10, _("signing hash"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT10"));
	wxFont StaticText10Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText10->SetFont(StaticText10Font);
	FlexGridSizer1->Add(StaticText10, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	StaticText11 = new wxStaticText(this, ID_STATICTEXT11, _("Select Base Cipher Algorithm "), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT11"));
	wxFont StaticText11Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText11->SetFont(StaticText11Font);
	FlexGridSizer1->Add(StaticText11, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	Button6 = new wxButton(this, ID_BUTTON6, _("What is a NADA Cap\?"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON6"));
	Button6->SetBackgroundColour(wxColour(215,229,244));
	wxFont Button6Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button6->SetFont(Button6Font);
	FlexGridSizer1->Add(Button6, 1, wxALL|wxALIGN_TOP|wxALIGN_CENTER_HORIZONTAL, 5);
	sign_algo_ctrl = new wxChoice(this, ID_CHOICE2, wxDefaultPosition, wxSize(153,29), 0, 0, 0, wxDefaultValidator, _T("ID_CHOICE2"));
	sign_algo_ctrl->Append(_("sha256 (32 byte)"));
	sign_algo_ctrl->Append(_("sha512 (64 byte)"));
	sign_algo_ctrl->Append(_("JH  (64 byte)"));
	sign_algo_ctrl->SetSelection( sign_algo_ctrl->Append(_("skein(128 byte)")) );
	sign_algo_ctrl->Append(_("Fleas_b  (512 byte, 2-pth)"));
	sign_algo_ctrl->Append(_("Fleas_c  (512 byte, 3-pth)"));
	sign_algo_ctrl->Append(_("Fleas_d  (512 byte, 4-pth)"));
	wxFont sign_algo_ctrlFont(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	sign_algo_ctrl->SetFont(sign_algo_ctrlFont);
	FlexGridSizer1->Add(sign_algo_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	algo_choice = new wxChoice(this, ID_CHOICE1, wxDefaultPosition, wxSize(201,29), 0, 0, 0, wxDefaultValidator, _T("ID_CHOICE1"));
	algo_choice->Append(_("Fleas_l   (1kbyte 2_pth, CBC)"));
	algo_choice->Append(_("Fleas_lb (1kbyte 2_pth, CBC)"));
	algo_choice->Append(_("Fleas_lc (1kbyte 3_pth, CBC)"));
	algo_choice->Append(_("Fleas_ld (1kbyte 4_pth, CBC)"));
	algo_choice->Append(_("AES         (16 byte, CBC)"));
	algo_choice->Append(_("Threefish(1 kbyte, CNT)"));
	algo_choice->SetSelection( algo_choice->Append(_("F_cnt_1b   (Blsiz 4k, 2_paths)")) );
	algo_choice->Append(_("F_cnt_1c   (Blsiz 4k, 3_paths)"));
	algo_choice->Append(_("F_cnt_1d   (Blsiz 4k, 4_paths)"));
	algo_choice->Append(_("flightx ((Blsiz 4k,marginal sec.)"));
	algo_choice->Append(_("chimera(4k, 4 paranoiacs)"));
	wxFont algo_choiceFont(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	algo_choice->SetFont(algo_choiceFont);
	FlexGridSizer1->Add(algo_choice, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	FlexGridSizer1->Add(30,15,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	SetSizer(FlexGridSizer1);
	Timer1.SetOwner(this, ID_TIMER1);
	Timer1.Start(6000, false);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&enciph_n_authent::OnExit);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&enciph_n_authent::OnFileSel);
	Connect(ID_BUTTON7,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&enciph_n_authent::OnChangeOutput);
	Connect(ID_BUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&enciph_n_authent::OnSelPublic);
	Connect(ID_BUTTON4,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&enciph_n_authent::OnSelPrivate);
	Connect(ID_BUTTON5,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&enciph_n_authent::OnDo_it);
	Connect(ID_BUTTON6,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&enciph_n_authent::OnNADA_ChkBoxClick);
	Connect(ID_CHOICE1,wxEVT_COMMAND_CHOICE_SELECTED,(wxObjectEventFunction)&enciph_n_authent::Onalgo_choiceSelect);
	Connect(ID_TIMER1,wxEVT_TIMER,(wxObjectEventFunction)&enciph_n_authent::OnTimer1Trigger);
	//*)

    filnam_ctrl->DragAcceptFiles(true);
    filnam_ctrl->Connect(wxEVT_DROP_FILES, wxDropFilesEventHandler(enciph_n_authent::OnDropFile), NULL, this);


	//check if priv still Trivial
	if(elky.id==_("42"))
	{
        if(!load_priv_ell_ky(&elky, &def_privkey))
           {
               throwout(_("Could not load default private key!"),5);
               def_privkey=_("empty");
           }
    }
    skid_ctrl->SetValue(elky.id + _(", ")+elky.fullnam);
	//check if pub still Trivial
	if(el_pk.id==_("Trivial"))
	{
        if(!load_pub_ell_ky(&el_pk, &def_pubkey))
           {
               throwout(_("Could not load default public key!"),5);
               def_pubkey=_("empty");
           }
    }

    loky.copy_pub_ky(&el_pk);
    pubkey_ctrl->SetValue(loky.id+ _(", ")+loky.fullnam);
    //set prefered hash
    if((def_hash>-1)&&(def_hash<6))
    {
        switch(def_hash)
        {
          case 0:
            sign_algo_ctrl->SetSelection(1); break; //sha512
          case 1:
            sign_algo_ctrl->SetSelection(2); break;  //JH
          case 2:
            sign_algo_ctrl->SetSelection(3); break;  //skein
          case 3:
            sign_algo_ctrl->SetSelection(4); break;  //Fleas_b
          case 4:
            sign_algo_ctrl->SetSelection(5); break;   //Fleas_c
          case 5:
            sign_algo_ctrl->SetSelection(6); break; //Fleas_d
           //no default necessary
        }
    }
  //set preferred cipher
	if((def_cip>-1)&&(def_cip<9))
    {
        switch(def_cip)
        {
          case 0:
            algo_choice->SetSelection(4); break;
          case 1:
            algo_choice->SetSelection(5); break;
          case 2:
            algo_choice->SetSelection(9); break;
          case 3:
            algo_choice->SetSelection(6); break;
          case 4:
            algo_choice->SetSelection(7); break;
          case 5:
            algo_choice->SetSelection(8); break;
          case 6:
            algo_choice->SetSelection(0); break;
          case 7:
            algo_choice->SetSelection(2); break;
          case 8:
            algo_choice->SetSelection(10); break;
           //no default necessary
        }
    }


    nostop=false;
}

enciph_n_authent::~enciph_n_authent()
{
	//(*Destroy(enciph_n_authent)
	//*)
}


void enciph_n_authent::OnExit(wxCommandEvent& event)
{
    EndModal(0);
}
/*****************************************************************/
void enciph_n_authent::OnDo_it(wxCommandEvent& event)
{
    wxString sig2, txt,fnam,s2,signam,hash=_("Fleas_1_8");
    longnumber r,s0,counter, salt,nckey,rndext;
    int ifl,hnum,elfl,readflag;
    wxString mypath,myname,separator,s,mys0,s1n,s2n,ext,domnam,h,h1,cnam,algo=_("Fleas_1_8");
    unsigned char *rbuff;
    int i,anum,res;
    unsigned long maxsiz,bufflen,j;
    longnumber ke,key;
    e_p B,KY;
    ellipse ellps_priv, ellps_pub;
    double decoylen;
    wxString detword,capkey;
    bool islegacy=false, hascap=false,intrinsic=true;
    int saltlen=256, counterlen = 512;
    ellipse el1024;
    int mode=13; //10 for fleas ld mt, 13 for monothread
    char c,*otpbuff;
    ulong32 len,usecnt=0,useblock=0;


    if(!checkarm()){Close();}
    nostop=true;

    detmin=detbox->IsChecked();

    //check domains
    if(loky.domnam==gdom.name) ellps_pub.copyell(&gdom);
    else
    {
        elfl=e_ls.getelp(&ellps_pub,loky.domnam);
        if(elfl<0)
        {
            throwout(_("unknown cipher ellipse: \"") + loky.domnam +_("\" cannot encipher!"),10);
            return;
        }
    }
    //for private key
    if(elky.domnam==gdom.name) ellps_priv.copyell(&gdom);
    else
    {
        elfl=e_ls.getelp(&ellps_priv,elky.domnam);
        if(elfl<0)
        {
            throwout(_("unknown sign-key ellipse: \"") + loky.domnam +_("\" cannot sign!"),10);
            return;
        }
    }
    //first sign document
    if(detmin) //deterministical
    {
        AskInput ainp(NULL,_("Give short determinate word"),&detword);
        if ( ainp.ShowModal() == 0 ) //make empty
        detword.Empty(); //empty the string
        //shorten if excessive to avoid repeated complaints vom signing routine
         if((detword).Len()>100)
         {
           throwout(_("Alert! suggested determinate excessively long\n truncating!"));
           detword.Truncate(100);
         }
    }


    fnam =filnam_ctrl->GetLineText(0);
    //check for existence
    if(!wxFile::Exists(fnam))
    {
        throwout(_("file to encipher does not exist!\nDo Nothing."),3);
        return;
    }
    //gethashvalue from choicebox
    hnum= sign_algo_ctrl->GetCurrentSelection();
    hash=_("sha4"); //error failsafe
    if(hnum==0) hash=_("sha2");
    if(hnum==1) hash=_("sha4");
    if(hnum==2) hash=_("JH");
    if(hnum==3) hash=_("skein");
    if(hnum==4) hash=_("Fleas_b");
    if(hnum==5) hash=_("Fleas_c");
    if(hnum==6) hash=_("Fleas_d");

    ifl= sign_elliptic_qq(fnam, &ellps_priv, &elky, &r, &s0,&hash,true,detmin,&detword); //signatur nach r und s
    if(ifl!=0)
    {
        throwout(_("Alert!\n signing failed! did nothing."),2);
        return;
    }
    //rausschreiben nach tempfile


    rndext.makerandom(2);
    rndext.writehex(&s2);  //write into stringvar s2
    signam=fnam +s2 ;  //make reasonably unique name for temporary file
    if(wxFile::Exists(signam))
    {
        AskDialog dlg(this,_("File with Signature file name \nis already present\n overwrite(OK) or Cancel?"));
        if ( dlg.ShowModal() == 0 ) return;
    }
    wxFFile sfile(signam,_("wb"));
    txt=_("Domnam: ") + elky.domnam;
    sfile.Write(txt);
    r.writehex(&txt);
    txt= _("\n r: ") + txt;
    sfile.Write(txt);
    s0.writehex(&txt);
    txt= _("\n s: ") + txt +_(" ");
    sfile.Write(txt);
    //for future clarity
    txt=_("\nHash: ") + hash + _("  end_sig:");
    sfile.Write(txt);
// to do: add flexible number of non X: chars
    bufflen=256*(unsigned int)zuf.get_rbyte();
    bufflen += (unsigned int)zuf.get_rbyte();
        //check for length
    wxFile firfil(fnam);
    if(!firfil.IsOpened())
    {
        throwout(_("wxWidgets couldn't open plainfile!\naborting."),3);
        return;
    }
    decoylen= firfil.Length();
    if(decoylen<1) decoylen=0;  //safety for -1!
    firfil.Close();
    bufflen= (unsigned long) (sqrt((decoylen * (double)bufflen) / (double)16003 ));
    bufflen += (unsigned int)zuf.get_rbyte();
    for (j=0;j<bufflen;j++)
    {
        sfile.Write(_(" "));
    }
// end to do
    sfile.Close();
    throwout(_(" Signature created !"),2);
    //concatenate signature and document
    fileconcat(signam,fnam,fnam + _(".sf"), _("split_here:"));
    //clean up old signature file
    wxRemoveFile(signam);
    //encrypt concatenated file



    //get algo
    anum= algo_choice->GetCurrentSelection();
      if(anum==0) algo= _("Fleas_l");
      else if(anum==1) algo= _("Fleas_lb");
      else if(anum==2) algo= _("Fleas_lc");
      else if(anum==3) algo= _("Fleas_ld");
      else if(anum==4) algo= _("aes");
      else if(anum==5) algo= _("threefish");
      else if(anum==6) algo= _("F_cnt_1b");
      else if(anum==7) algo= _("F_cnt_1c");
      else if(anum==8) algo= _("F_cnt_1d");
      else if(anum==9) algo= _("flightx");
      else if(anum==10) algo= _("chimera");
         else{ throwout(_("No algorithm specified! \nAborting.")); return;}

    //build s0, 30 rnd header fnam: "filename" ohne Pfad, X:
    rbuff=(unsigned char*) malloc(30); //padding
    //puffer füllen
    for(i=0;i<30;i++)
    {
        *(rbuff+i)= zuf.get_rbyte();
    }
    fnam = fnam + _(".sf");  //neuer filename zu verschlüsseln
    // separate path
    separator=wxFileName::GetPathTerminators();
    wxFileName::SplitPath(fnam, &mypath, &myname,&ext);
    mys0=fnam+_("s0");
    //change blanks to underscore
    myname.Replace(_(" "),_("_"));
    s=_(" fnam: ") + myname;
    if(!ext.IsEmpty()) s += _(".")+ ext; //nur wenn ext vorhanden, den punkt ran
    s += _(" X:");
    wxFFile fs0(mys0, _("wb"));
    fs0.Write(rbuff,30);
    fs0.Write(s);
    fs0.Close();
    //concat s0, s_initl to s1
    s1n=mypath+separator+_("s1");
    fileconcat(mys0,fnam,s1n);
    //delete remainder
    wxRemoveFile(mys0);
    //delete intermediate *.sf-file
    wxRemoveFile(fnam);
    //build ke, generate key = (d0*ke).x
    maxsiz= (gdom.q).size -1;
    // choose lonu ke as random ephemeralky < q
    ke.makerandom(maxsiz);
    KY.copy_ep(&(ellps_pub.d0));
    KY.mult_p_qj(&ke,&ellps_pub);
    key.copynum(&(KY.x));
    key.shrinktofit();
    B.copy_ep(&(loky.A));
    if(! B.is_in_ellipse(&ellps_pub))
    {
        wxMessageBox(_("Public key is incompatible with current domain\n will not encipher"));
        return;
    }
    B.mult_p_qj(&ke,&ellps_pub);
    //lockinplace file s1
    lockinplace(s1n,&key,algo,1);
   //prepend ell cipherinfo: kid: domnam: Bx: By: X:
    s2n=mypath+separator+_("s2");
    wxFFile fs1(s2n, _("wb"));
    //determine if hidekey is set
    if(false)//if(Checkbox1->IsChecked())
    {
        h1=_("kid: xxx    domnam: xxx ");
        h1 +=  _("\n Bx: ");
    }
    else
    {
        h1=_("kid: ") + loky.id + _(" ") + _("domnam: ") + ellps_pub.name + _("\n Bx: ");
    }

    B.x.writehex(&h);
    h1 += h + _("\n By: ");
    B.y.writehex(&h);
    h1 += h + _(" algo: ") +algo +  _(" X:");
    //fs1.Write(h1);
    //replace with other writeout

    /******************prepare info relevant for NADA Cap *******************/
    //get status of checkbox
    if(NADA_ChkBox->IsChecked())
    {
        hascap=true;
    }
    if(hascap)
    {
        //ask for nada cap key
           capkey=_("intrinsic");
           Cap_Questn extrinsicDlg (this,_("cipher will be NADA-Capped, give NADA-Cap key!"),&capkey, &islegacy);
           res=extrinsicDlg.ShowModal();
           if(res==0)//aborted
           {
               throwout(_("Aborted, do nothing!"),3);
               return;
           }
           else
           {
                if(capkey!=_("intrinsic"))  intrinsic=false;
           }
    }
    /***************/
    if((!intrinsic)&&(hascap))
    {
       //write salt and counter to outfile
       salt.makerandom(saltlen);
       readflag=fs1.Write(salt.ad,saltlen);
    }
    if(hascap)
    {
        counter.makerandom(counterlen);
        readflag=fs1.Write(counter.ad,counterlen);
    }
    if(hascap&&(!intrinsic))
    {
        el1024.ellipse_set_stretch1024();
        //prepare cap data structure for extrinsic cap
        if(!cap_prep_from_String(&capkey, &salt, &counter, (ulong32)counterlen, &nckey,  &el1024, mode,counterlen, islegacy))
        {
           throwout(_("Error in cap preparation!\naborting!"),5);
           fs1.Close();
          return;
        }
    }
    if(hascap&&intrinsic)
    {
        //determine cap key and true counter from pubkey
       if(!cap_prep_from_pubky(&loky, &counter, (ulong32) counterlen, &nckey, counterlen))
       {
           throwout(_("could not determine cap key \nfrom public key\nAborting."),10);
           fs1.Close();
           return;
       }
    }
    if(hascap)
    {
      counter.inc();
      /***********************************************************************/
      otpbuff=(char*)malloc(counterlen);
      memcpy(otpbuff,counter.ad,counterlen);
      if(! k_develop_f4(counterlen, otpbuff, 0, NULL, counterlen, (char*) nckey.ad, 2, mode ))  //0,NULL means no cpablocker, algo 10 is fleas Ld 4 Path
      {
       throwout(_("Alert, keydevelop failed for cap!"),5);
       free(otpbuff);
       fs1.Close();
       return;
      }
      // writeout xored compbuffer first
      usecnt=0; useblock=0;
      len= h1.Length();
      while(usecnt<len)
      {
          if(useblock==(unsigned int)counterlen) //refresh buffer if necessary
          {
           counter.inc();
           memcpy(otpbuff,counter.ad,counterlen);
           if(! k_develop_f4(counterlen, otpbuff, 0, NULL, counterlen, (char *)nckey.ad, 2, mode ))  //0,NULL means no cpablocker, algo 10 is fleas Ld 4 Path
            {
                throwout(_("Alert, keydevelop failed for cap!"),5);
                free(otpbuff);
                fs1.Close();
                return;
            }
            useblock=0;
           }
           c= (char) h1.GetChar(usecnt);  //get usecnt_th byte from wxstring
           c ^= *(otpbuff+useblock); //xor with OTP
           useblock++; usecnt++;
           readflag=fs1.Write(&c,1);  //writeout cap byte
        }
        free(otpbuff);
       }
       if(!hascap) fs1.Write(h1);
    fs1.Close();
    cnam=outfnam_ctrl->GetLineText(0);
    if(algo==_("Fleas_1_8")) fileconcat(s2n,s1n+_("_c3"), cnam);
    else if(algo==_("Fleas_3")) fileconcat(s2n,s1n+_("_f3"), cnam);
    else if(algo==_("Fleas_4")) fileconcat(s2n,s1n+_("_f4"), cnam);
    else if(algo==_("Fleas_5")) fileconcat(s2n,s1n+_("_f5"), cnam);
    else if(algo==_("Fleas_x2")) fileconcat(s2n,s1n+_("_x2"), cnam);
    else if(algo==_("Fleas_x5")) fileconcat(s2n,s1n+_("_x5"), cnam);
    else if(algo==_("Fleas_o2")) fileconcat(s2n,s1n+_("_o2"), cnam);
    else if(algo==_("Fleas_o5")) fileconcat(s2n,s1n+_("_o5"), cnam);
    else if(algo==_("Fleas_l")) fileconcat(s2n,s1n+_("_l"), cnam);
    else if(algo==_("Fleas_ls")) fileconcat(s2n,s1n+_("_ls"), cnam);
    else if(algo==_("Fleas_l3")) fileconcat(s2n,s1n+_("_l3"), cnam);
    else if(algo==_("Fleas_lb")) fileconcat(s2n,s1n+_("_lb"), cnam);
    else if(algo==_("Fleas_lc")) fileconcat(s2n,s1n+_("_lc"), cnam);
    else if(algo==_("Fleas_ld")) fileconcat(s2n,s1n+_("_ld"), cnam);
    else if(algo==_("F_cnt_1c")) fileconcat(s2n,s1n+_("_1c"), cnam);
    else if(algo==_("F_cnt_1d")) fileconcat(s2n,s1n+_("_1d"), cnam);
    else if(algo==_("F_cnt_1b")) fileconcat(s2n,s1n+_("_1b"), cnam);
    else if(algo==_("aes")) fileconcat(s2n,s1n+_("_ae"), cnam);
    else if(algo==_("threefish")) fileconcat(s2n,s1n+_("_tf"), cnam);
    else if(algo==_("flightx")) fileconcat(s2n,s1n+_("_fx"), cnam);
    else if(algo==_("chimera")) fileconcat(s2n,s1n+_("_ff"), cnam);
      else throwout(_("Error 3: Unknown algorithm specifier\nmust clean up manually!"));
    //remove remainders
    wxRemoveFile(s2n);
    if(algo==_("Fleas_1_8")) wxRemoveFile(s1n+_("_c3"));
    else if(algo==_("Fleas_3"))  wxRemoveFile(s1n+_("_f3"));
    else if(algo==_("Fleas_4"))  wxRemoveFile(s1n+_("_f4"));
    else if(algo==_("Fleas_5"))  wxRemoveFile(s1n+_("_f5"));
    else if(algo==_("Fleas_x2"))  wxRemoveFile(s1n+_("_x2"));
    else if(algo==_("Fleas_x5"))  wxRemoveFile(s1n+_("_x5"));
    else if(algo==_("Fleas_o2"))  wxRemoveFile(s1n+_("_o2"));
    else if(algo==_("Fleas_o5"))  wxRemoveFile(s1n+_("_o5"));
    else if(algo==_("Fleas_l"))  wxRemoveFile(s1n+_("_l"));
    else if(algo==_("Fleas_ls"))  wxRemoveFile(s1n+_("_ls"));
    else if(algo==_("Fleas_l3"))  wxRemoveFile(s1n+_("_l3"));
    else if(algo==_("Fleas_lb"))  wxRemoveFile(s1n+_("_lb"));
    else if(algo==_("Fleas_lc"))  wxRemoveFile(s1n+_("_lc"));
    else if(algo==_("Fleas_ld"))  wxRemoveFile(s1n+_("_ld"));
    else if(algo==_("aes"))  wxRemoveFile(s1n+_("_ae"));
    else if(algo==_("threefish"))  wxRemoveFile(s1n+_("_tf"));
    else if(algo==_("F_cnt_1c"))  wxRemoveFile(s1n+_("_1c"));
    else if(algo==_("F_cnt_1d"))  wxRemoveFile(s1n+_("_1d"));
    else if(algo==_("F_cnt_1b"))  wxRemoveFile(s1n+_("_1b"));
    else if(algo==_("flightx"))  wxRemoveFile(s1n+_("_fx"));
    else if(algo==_("chimera"))  wxRemoveFile(s1n+_("_ff"));

    throwout(_("enciphered"),2);


    //feedback
    throwout(_("concatenated signature and file successfully enciphered!"),10);
    def_privkey=elky.id;
    def_pubkey=loky.id;
    nostop=false;
    return;
}
/*******************************************************/
void enciph_n_authent::OnDropFile(wxDropFilesEvent& event)
    {
        wxString mypath,myname,separator,s;
        longnumber rndnam;
        unsigned char ch1;
        int  filno;
        drop_succ=false;

        if (event.GetNumberOfFiles() > 0) {

            wxString* dropped = event.GetFiles();
            wxASSERT(dropped);

            wxBusyCursor busyCursor;
            wxWindowDisabler disabler;
            wxBusyInfo busyInfo(_("Adding file, wait please..."));

            wxString name;
            filno = event.GetNumberOfFiles();
            if(filno!=1)
            {
				throwout(_("Can only enter single filename here.\nDrop rejected!"),3);
				return;
			}
			name = dropped[0];
			if (!wxFileExists(name))
            {
				throwout(_("File does not exist\nDrop rejected!"),5);
				return;
			}

            wxTextCtrl* textCtrl = dynamic_cast<wxTextCtrl*>(event.GetEventObject());
            wxASSERT(textCtrl);
            textCtrl->Clear();
            textCtrl->SetValue(name);
            drop_succ=true;
            fnam=name;
            cur_cry_path= ((wxFileName)fnam).GetPath(); //get new path and store into cur_doc_path
            separator=wxFileName::GetPathTerminators();
            wxFileName::SplitPath(fnam, &mypath, &myname,NULL);
            rndnam.makerandom(10);
    //determine subtractor from last byte
            ch1= *(rndnam.ad + 9); //get highest byte of randnum
            ch1 >>= 5;      // get three highest bits
            rndnam.writehex(&s);  //write into stringvar s
            if(ch1<9) s.Truncate(19-ch1);  //truncate s to shorter val
            s= mypath + separator + s;  //buil full filename
            outfnam_ctrl->SetValue(s);

            return;
        }
    }
/*********************************************************/
/*************************************************************************/
void enciph_n_authent::OnFileSel(wxCommandEvent& event)
{
    wxString mypath,myname,separator,s,cry_d;
    longnumber rndnam;
    unsigned char ch1;


    if(!checkarm()){Close();}
    nostop=true;
    if(cur_cry_path.IsEmpty())
    {
        cry_d = cry_path; //first call
    }
    else
    {
        cry_d = cur_cry_path;
    }
    fnam = wxFileSelector(_("Select a file to sign&encipher"),cry_d);
    if ( !fnam.empty() )
    {
        filnam_ctrl->SetValue(fnam);
        cur_cry_path= ((wxFileName)fnam).GetPath(); //get new path and store into cur_doc_path
    }
    // set cipherfile name suggestion
    separator=wxFileName::GetPathTerminators();
    wxFileName::SplitPath(fnam, &mypath, &myname,NULL);
    rndnam.makerandom(10);
    //determine subtractor from last byte
    ch1= *(rndnam.ad + 9);
    ch1 >>= 5;
    rndnam.writehex(&s);
    if(ch1<9) s.Truncate(19-ch1);
    s= mypath + separator + s;
    outfnam_ctrl->SetValue(s);
    nostop=false;
}
/***************************************************************************/
void enciph_n_authent::OnSelPublic(wxCommandEvent& event)
{
    ellipse locell;
    int elfl;
    wxString h;

    nostop=true;
    LoadEllKey dialog(this,&loky);
    dialog.ShowModal();

    if(!checkarm()){Close();}
    if(loky.domnam == gdom.name) locell.copyell(&gdom);
    else
    {
        elfl=e_ls.getelp(&locell,loky.domnam);
        if(elfl<0)
        {
            throwout(_("unknown cipher ellipse: \"") + loky.domnam +_("\" cannot sign!"),10);
            return;
        }
    }
    pubkey_ctrl->SetValue(loky.id + _(",  ") + loky.fullnam);
    el_pk.copy_pub_ky(&loky);
    nostop=false;
    return;
}
/***************************************************************/
void enciph_n_authent::OnSelPrivate(wxCommandEvent& event)
{
    ellipse locell;
    int elfl;

    if(!checkarm()){Close();}
    nostop=true;
    ellky_load1 dialog(this);
    dialog.ShowModal();
    // ende Dialog
    //alles korrekt eintragen
    if(elky.domnam == gdom.name) locell.copyell(&gdom);
    else
    {
        elfl=e_ls.getelp(&locell,elky.domnam);
        if(elfl<0)
        {
            throwout(_("unknown signature ellipse: \"") + elky.domnam +_("\" cannot sign!"),10);
            return;
        }
    }
	skid_ctrl->SetValue(elky.id+_(",  ") + elky.fullnam);
	wxString number;
	//jetzt A ermitteln
    elky.A.copy_ep(&(locell.d0));
    elky.A.mult_p_qj(&(elky.d),&(locell));
    nostop=false;
    return;
}
/*************************************************************/
void enciph_n_authent::OnTimer1Trigger(wxTimerEvent& event)
{
    half_min_counter++;
    if((half_min_counter > 40)&&(!nostop))  //mehr als 4 Minuten idle
    {
        unarm();
        EndModal(0);
    }
    return;
}
/**************************************************************/

void enciph_n_authent::Onalgo_choiceSelect(wxCommandEvent& event)
{
    //could set a favourite hash for the selected cipher here - not done!
}
/******************************************************************/
void enciph_n_authent::OnNADA_ChkBoxClick(wxCommandEvent& event)
{
    wxString msg;

    msg=_(" \nNADA stands for No Access Data Available\n");
    msg+=_("A NADA Cap conceals all formatting info \nand renders the cipher \nindistinguishable from noise in toto.\n\n");
    msg+=_("The adversary cannot extract ANY information.\n");
    msg+=_("In fact he doesn't even know \nif it is a cipher at all. NADA!!\n");
    msg+=_("If you leave \"intrinsic\" as NADA key, the \nNADA-cap key is calculated from public key info.\n");
    msg+=_("On \"intrinsic\" the recipient must guess, \nwhat key the file was enciphered for.\n");
    msg+=_("If using other NADA keywords, you need \nto transmit the NADA key via alternate means.\n");

    throwout(msg,100);
    return;

}
/******************************************************************/

void enciph_n_authent::OnChangeOutput(wxCommandEvent& event)
{
    wxString cfnam, cpath_tmp, cpath, cbarenam, separator;

    //put suggestion into cfnam
    cfnam = outfnam_ctrl->GetLineText(0);


    separator=wxFileName::GetPathTerminators();
    wxFileName::SplitPath(cfnam, &cpath, &cbarenam,NULL);

    cpath_tmp=wxDirSelector(_("Select other output directory"),cpath);
        if(cpath_tmp == _(""))       //.IsEmpty() )
        {
            throwout(_("aborted"),1);
        }
        else
        {
            cfnam=cpath_tmp + separator + cbarenam;
            outfnam_ctrl->SetValue(cfnam);
        }
}
/****************************************************************/
