/*
 *   Copyright (C) 2011-2017, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#ifndef GPG_MANAG_PRIV_H
#define GPG_MANAG_PRIV_H

//(*Headers(gpg_manag_priv)
#include <wx/dialog.h>
#include <wx/sizer.h>
#include <wx/button.h>
#include <wx/stattext.h>
#include <wx/listbox.h>
//*)



class gpg_manag_priv: public wxDialog
{
	public:

		gpg_manag_priv(wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		virtual ~gpg_manag_priv();

		//(*Declarations(gpg_manag_priv)
		wxButton* Button4;
		wxButton* Button1;
		wxButton* Button2;
		wxButton* Button3;
		wxStaticText* StaticText1;
		wxButton* Button5;
		wxListBox* keylist_ctrl;
		wxButton* Button6;
		//*)

	protected:

		//(*Identifiers(gpg_manag_priv)
		static const long ID_BUTTON1;
		static const long ID_STATICTEXT1;
		static const long ID_BUTTON5;
		static const long ID_LISTBOX1;
		static const long ID_BUTTON4;
		static const long ID_BUTTON3;
		static const long ID_BUTTON6;
		static const long ID_BUTTON2;
		//*)

	private:

		//(*Handlers(gpg_manag_priv)
		void OnMakeNew(wxCommandEvent& event);
		void OnEdit(wxCommandEvent& event);
		void OnDelete(wxCommandEvent& event);
		void OnExit(wxCommandEvent& event);
		void OnExportSecret(wxCommandEvent& event);
		void OnImportPrivate(wxCommandEvent& event);
		//*)

		DECLARE_EVENT_TABLE()


};

#endif
