/*
 *   Copyright (C) 2011-2017, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "DeletePubEllky.h"
#include "elliptic1.h"

//(*InternalHeaders(DeletePubEllky)
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/font.h>
//*)

#include <wx/filename.h>
#include <wx/filedlg.h>



//(*IdInit(DeletePubEllky)
const long DeletePubEllky::ID_BUTTON2 = wxNewId();
const long DeletePubEllky::ID_STATICTEXT1 = wxNewId();
const long DeletePubEllky::ID_STATICTEXT3 = wxNewId();
const long DeletePubEllky::ID_EXP_BUTTON = wxNewId();
const long DeletePubEllky::ID_BUTTON3 = wxNewId();
const long DeletePubEllky::ID_BUTTON5 = wxNewId();
const long DeletePubEllky::ID_BUTTON4 = wxNewId();
const long DeletePubEllky::ID_BUTTON6 = wxNewId();
const long DeletePubEllky::ID_BUTTON7 = wxNewId();
const long DeletePubEllky::ID_BUTTON1 = wxNewId();
const long DeletePubEllky::ID_LISTBOX1 = wxNewId();
const long DeletePubEllky::ID_TIMER1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(DeletePubEllky,wxDialog)
	//(*EventTable(DeletePubEllky)
	//*)
END_EVENT_TABLE()

DeletePubEllky::DeletePubEllky(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
    FILE *knfp;
    char buff1[2000], buff2[2000];
    int lbl,count;
    bool fl=true;


    if(!checkarm()){Close();}
    half_min_counter=0;
    nostop=false;

	//(*Initialize(DeletePubEllky)
	wxFlexGridSizer* FlexGridSizer1;

	Create(parent, id, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("id"));
	SetClientSize(wxDefaultSize);
	Move(wxDefaultPosition);
	SetBackgroundColour(wxColour(205,243,208));
	FlexGridSizer1 = new wxFlexGridSizer(0, 2, 0, 0);
	Button2 = new wxButton(this, ID_BUTTON2, _("Schliessen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	Button2->SetDefault();
	Button2->SetBackgroundColour(wxColour(241,175,175));
	wxFont Button2Font(11,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button2->SetFont(Button2Font);
	FlexGridSizer1->Add(Button2, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("oeffentlichen ECC Schluessel\nzum loeschen auswaehlen"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	StaticText1->SetForegroundColour(wxColour(8,117,14));
	wxFont StaticText1Font(13,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText1->SetFont(StaticText1Font);
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText3 = new wxStaticText(this, ID_STATICTEXT3, _("Schliesst nach 2 Minuten Wartezeit"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT3"));
	wxFont StaticText3Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText3->SetFont(StaticText3Font);
	FlexGridSizer1->Add(StaticText3, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Exp_key_ctrl = new wxButton(this, ID_EXP_BUTTON, _("Schluessel exportieren"), wxDefaultPosition, wxSize(140,24), 0, wxDefaultValidator, _T("ID_EXP_BUTTON"));
	wxFont Exp_key_ctrlFont(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Exp_key_ctrl->SetFont(Exp_key_ctrlFont);
	Exp_key_ctrl->SetHelpText(_("Export selected key as pell file"));
	FlexGridSizer1->Add(Exp_key_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button3 = new wxButton(this, ID_BUTTON3, _("Oefftl. Schluessel aus Datei importieren"), wxDefaultPosition, wxSize(286,27), 0, wxDefaultValidator, _T("ID_BUTTON3"));
	wxFont Button3Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button3->SetFont(Button3Font);
	FlexGridSizer1->Add(Button3, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button5 = new wxButton(this, ID_BUTTON5, _("Eins nach unten"), wxDefaultPosition, wxSize(114,24), 0, wxDefaultValidator, _T("ID_BUTTON5"));
	wxFont Button5Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button5->SetFont(Button5Font);
	FlexGridSizer1->Add(Button5, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button4 = new wxButton(this, ID_BUTTON4, _("Eins nach oben"), wxDefaultPosition, wxSize(116,23), 0, wxDefaultValidator, _T("ID_BUTTON4"));
	wxFont Button4Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button4->SetFont(Button4Font);
	FlexGridSizer1->Add(Button4, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button6 = new wxButton(this, ID_BUTTON6, _("Ans Ende setzen"), wxDefaultPosition, wxSize(115,22), 0, wxDefaultValidator, _T("ID_BUTTON6"));
	wxFont Button6Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button6->SetFont(Button6Font);
	FlexGridSizer1->Add(Button6, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button7 = new wxButton(this, ID_BUTTON7, _("An den Anfang setzen"), wxDefaultPosition, wxSize(137,23), 0, wxDefaultValidator, _T("ID_BUTTON7"));
	wxFont Button7Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button7->SetFont(Button7Font);
	FlexGridSizer1->Add(Button7, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button1 = new wxButton(this, ID_BUTTON1, _("Loeschen"), wxDefaultPosition, wxSize(85,30), 0, wxDefaultValidator, _T("ID_BUTTON1"));
	wxFont Button1Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button1->SetFont(Button1Font);
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	ListBox1 = new wxListBox(this, ID_LISTBOX1, wxDefaultPosition, wxSize(347,314), 0, 0, wxVSCROLL, wxDefaultValidator, _T("ID_LISTBOX1"));
	ListBox1->SetForegroundColour(wxColour(15,124,9));
	wxFont ListBox1Font(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	ListBox1->SetFont(ListBox1Font);
	FlexGridSizer1->Add(ListBox1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	SetSizer(FlexGridSizer1);
	Timer1.SetOwner(this, ID_TIMER1);
	Timer1.Start(6000, false);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&DeletePubEllky::OnExit);
	Connect(ID_EXP_BUTTON,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&DeletePubEllky::OnExp_Click);
	Connect(ID_BUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&DeletePubEllky::Import_el_pubky);
	Connect(ID_BUTTON5,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&DeletePubEllky::OnOnedown);
	Connect(ID_BUTTON4,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&DeletePubEllky::OnButtonOneup);
	Connect(ID_BUTTON6,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&DeletePubEllky::OnToBottom);
	Connect(ID_BUTTON7,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&DeletePubEllky::OnToTop);
	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&DeletePubEllky::OnDeleteKey);
	Connect(ID_TIMER1,wxEVT_TIMER,(wxObjectEventFunction)&DeletePubEllky::OnTimer1Trigger);
	//*)

		    // zuerst Namensliste Laden
    wxArrayString wxstrad; //wxStringarray initialisieren
nostop=true; //hier nicht aussteigen
     if(S_FIL) fl=unlockfile(sec_path + _("/e_ell_knamfile.knf"),&zugang);
    if(fl)
    {
      knfp=fopen((const char*)(sec_path + _("/e_ell_knamfile.knf")).mb_str(wxConvLocal), "r");
      count=0;
      do{
        lbl=fscanf(knfp, " id: %500s Name: %500s\n",buff1,buff2);
        //in wxstrad einpflegen
        if(lbl==2) {
            wxstrad.Add( (wxString::FromUTF8(buff1)) + _("  ") + (wxString::FromUTF8(buff2)) );
            ids.Add(wxString::FromUTF8(buff1)); //ids ist eine class-variable
            count++;
          }
      }while(lbl == 2);
 	// Jetzt die Listbox initialisieren
      ListBox1->InsertItems(wxstrad,0);
    //als Menu in neuem Dialog anbieten und auswählen

      fclose(knfp);
    }
    if(S_FIL&&fl) lockfile(sec_path + _("/e_ell_knamfile.knf"),&zugang);
nostop=false; //hier nicht aussteigen
}
/************************************************************************/
DeletePubEllky::~DeletePubEllky()
{
	//(*Destroy(DeletePubEllky)
	//*)
}

/************************************************************************/
void DeletePubEllky::Import_el_pubky(wxCommandEvent& event)
{
    wxString importfile,h;
    el_pub loky;
    wxString txa,tya;
    FILE *knamfil, *kfil;
    bool fl, oldname=false;
    char buff1[402],buff2[402];
    int lbl;
    ellipse el;


    half_min_counter=0;
nostop=true;
    if(!checkarm()){Close();}
    importfile = wxFileSelector(_("Waehle Schluesseldatei fuer Import"),kytray,_(""),_("pell|"),_("regular pell|*.pell|anyfile|*"));
    if(importfile.IsEmpty())
    {
        wxMessageBox(_("Importdatei existiert nicht!\nAbbruch!"));
         nostop=false; return;
    }
    if(!loky.get_from_file(importfile))
    {
        wxMessageBox(_("Importfile nicht valide\nAbbruch!"));
         nostop=false; return;
    }
 //check validity
    if(!e_ls.isinlist(loky.domnam))
    {
        wxMessageBox(_("Angegebene Domain ist hier unbekannt\n Abbruch!"));
         nostop=false; return;
    }
    //check on curve?
    e_ls.getelp(&el,loky.domnam);
    if(! (loky.A).is_in_ellipse(&el))
    {
        //check if domnam accessible
        wxMessageBox(_("Schluessel ist inkompatibel mit angegebener Domain\n Abbruch!"));
         nostop=false; return;
    }
    if( (loky.A).neutral)
    {
        //check if domnam accessible
        wxMessageBox(_("Schluessel ist das neutrale Element\n Abbruch!"));
         nostop=false; return;
    }
    //validate key
    if(!validate_pubkey(&loky))
    {
        throwout(_("oeffentlicher Schluessel ist nicht valide!"),2);
         nostop=false; return;
    }

    //open keynamfile, append name and id, close keynamfile
    if(!pub_keyid_free(loky.id,false))
    {
        throwout(loky.id + _("\nDiese ID wird bereits fuer \noeffntl. Schluessel verwendet\n Bitte wechsle die ID!"));
         nostop=false; return;
    }
    if(!priv_keyid_free(loky.id,false))
    {
        throwout(loky.id + _("\nDiese ID wird bereits fuer \neinen priv. Schluessel verwendet\nWenn dies der zugehoerige oeffentl. Teil ist-> leite in \"erstellen/laden/sichern private Key\" dialog ab\nOder benutze andere ID!\n Abbruch!"),20);
         nostop=false; return;
    }


    if(S_FIL) unlockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // unlock keynamefile
    if((knamfil = fopen((const char*)(sec_path + _("/e_ell_knamfile.knf")).mb_str(wxConvLocal), "a"))== NULL) return;
    fprintf(knamfil, "id: %s  Name: %s  \n",(const char*)(loky.id).mb_str(wxConvUTF8),
                  (const char*)(loky.fullnam).mb_str(wxConvUTF8));
    fclose(knamfil);
    if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock again

    //open keyfile, store all data and close
    if(S_FIL) unlockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // unlock keynamefile
    if((kfil = fopen((const char*)(sec_path + _("/e_ell_Keyfile.kyf")).mb_str(wxConvLocal), "a"))== NULL) return;
    fprintf(kfil, "id: %s  Name: %s DomName: %s\n",(const char*)(loky.id).mb_str(wxConvUTF8),
                  (const char*)(loky.fullnam).mb_str(wxConvUTF8),(const char*)(loky.domnam).mb_str(wxConvUTF8) );
    (loky.A.x).writehex(&txa);
    (loky.A.y).writehex(&tya);

    fprintf(kfil,"Ax: %s \n Ay: %s \n \n", (const char*)txa.mb_str(wxConvUTF8), (const char*)tya.mb_str(wxConvUTF8));
    fclose(kfil);
    if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // unlock keynamefile
    //set flag to recall dialog
nostop=false;
    EndModal(1); //caller has to recall
    return;
}
/********************************************************/
void DeletePubEllky::OnExit(wxCommandEvent& event)
{
    EndModal(0);//caller doesn't recall
}
/*******************  helperfunction  ************************************/
bool liberatekylist(int keyz,el_pub **zz)
{
    int i;

    if(zz==NULL) return false;
    for(i=keyz-1; i>=0; i--)
    {
       delete( *(zz+i));
    }
    free(zz);
    return true;
}
/***********************************************************************/
void DeletePubEllky::OnDeleteKey(wxCommandEvent& event)
{
    wxString del_id,hlp,txa,tya;
    el_pub **ppt=NULL;
    int keyno=0,indx,i,lbl;
    el_pub tmpky;
    char buff[1602];
    FILE *kfp,*knfp;
    unsigned long fpos;

    half_min_counter=0;
nostop=true;
    if(!checkarm()){Close();}
    //get id of file to delete
    indx=ListBox1->GetSelection();
    if(indx<0) {throwout(_("Nichts gewaehlt!\nAbbruch!"),2);  nostop=false; return;}
    del_id= ids.Item(indx);  //kann nachher weg, ist
    //unlock keyfile and keynamfile
    if(S_FIL) unlockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang);
    if(S_FIL) unlockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang);
    keyno=0;
    if(!setkylist(&ppt,&keyno))
       {
           throwout(_("Fehler, konnte Schluesselliste nicht lesen"),4);
             if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
             if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock keynamefile
           nostop=false;
           return;
       }

    kfp=fopen((const char*)(sec_path + _("/e_ell_Keyfile.kyf")).mb_str(wxConvLocal),"w");
    knfp=fopen((const char*)(sec_path + _("/e_ell_knamfile.knf")).mb_str(wxConvLocal),"w");

    del_id=(*(ppt+indx))->id;  //wird hier noch nicht benutzt, aber spaeter vielleicht nach sortierung etc.
    for(i=0;i<keyno;i++)
    {
       if(i==indx) continue; //wenns der zu loeschende ist, ueberspringen
       //sonst einfach alle rausschreiben
       lbl=fprintf(knfp,"id: %s  Name: %s  \n",(const char*)( (*(ppt+i))->id).mb_str(wxConvUTF8),
                  (const char*)((*(ppt+i))->fullnam).mb_str(wxConvUTF8));
       lbl=fprintf(kfp,"id: %s  Name: %s DomName: %s\n",(const char*)((*(ppt+i))->id).mb_str(wxConvUTF8),
                  (const char*)((*(ppt+i))->fullnam).mb_str(wxConvUTF8),(const char*)((*(ppt+i))->domnam).mb_str(wxConvUTF8) );
      ((*(ppt+i))->A.x).writehex(&txa);
      ((*(ppt+i))->A.y).writehex(&tya);
      lbl=fprintf(kfp,"Ax: %s \n Ay: %s \n \n", (const char*)txa.mb_str(wxConvUTF8), (const char*)tya.mb_str(wxConvUTF8));
    }
    fclose(knfp); fclose(kfp);
    if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
    if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock keynamefile
    //set first key to default if deleted one was default
    if(del_id==el_pk.id) //replace deafault key
    {
        if(!el_pk.copy_pub_ky( *ppt))  //copy first key in list to default
            throwout(_("Warnung, defekter default Schluessel :-/"),5);
    }
    liberatekylist(keyno,ppt);
nostop=false;
    EndModal(1);
}
/******************************************************************************/
void DeletePubEllky::OnTimer1Trigger(wxTimerEvent& event)
{
    half_min_counter++;
    if((half_min_counter > 20)&&(!nostop))  //mehr als 2 Minuten idle
    {
        unarm();
        EndModal(0);
    }
    return;}
/*******************************************************************************/

void DeletePubEllky::OnExp_Click(wxCommandEvent& event)
{
    FILE *exfil;
    wxString exp_id,hlp,txa,tya,hlp1,keyfilename,exfile,sep,errmsg;
    el_pub **ppt=NULL;
    int keyno=0,indx,i,lbl;
    el_pub tmpky;
    char buff[3202];
    FILE *kfp,*knfp;
    unsigned long fpos;
    bool abrt=false;

    half_min_counter=0;
nostop=true;
    if(!checkarm()){Close();}
    //get id of file to delete
    indx=ListBox1->GetSelection();  //key to be exported
    if(indx<0) {throwout(_("Nichts gewaehlt!\nAbbruch!"),2); nostop=false; return;}
    exp_id= ids.Item(indx);  //set id of file to export
    //unlock keyfile and keynamfile
    if(S_FIL) unlockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang);
    if(S_FIL) unlockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang);
    if(!setkylist(&ppt,&keyno))
       {
           throwout(_("Fehler, konnte Schluesselliste nicht lesen"),4);
             if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
             if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock keynamefile
           nostop=false;
           return;
       }

    //open files to write list
    kfp=fopen((const char*)(sec_path + _("/e_ell_Keyfile.kyf")).mb_str(wxConvLocal),"w");
    knfp=fopen((const char*)(sec_path + _("/e_ell_knamfile.knf")).mb_str(wxConvLocal),"w");

    //exp_id=(*(ppt+indx))->id;  //wird hier noch nicht benutzt, aber spaeter vielleicht nach sortierung etc.
    //exp_id had been set at the top!
    for(i=0;i<keyno;i++)
    {
       if((i==indx)&&!abrt) //wenns der zu exportierende ist, diesen block ausführen
       {
           //filenamen bestimmen
           //file öffnen
           //rausschreiben
           //schließen
           hlp1= (*(ppt+i))->id;
           keyfilename=hlp1+_(".pell");
           //get directory
           sep=wxFileName::GetPathTerminators();
           exfile=wxFileSelector(_("Dateiname fuer Export, bitte belassen Sie die \".pell\" Namenserweiterung."),kytray,keyfilename,_(".pell"),_("*.pell"),wxFD_SAVE|wxFD_OVERWRITE_PROMPT);
           if ( exfile.empty() )
           {
              throwout(_("cancelled\naborting."),3);
              abrt=true;;
           }
           if(abrt) break;
           if(exfile.Len()>800)
           {
                  throwout(_("Mehr als 800 Byte Dateiname! Bist Du jeck?\nAbbruch."),5);
                  abrt=true;
           }
           if(abrt) break;
           strcpy(buff, (const char*) (exfile).mb_str(wxConvLocal));
           exfil=fopen(buff, "w");
           if(exfil==NULL)
           {
               errmsg=_("Fehler!\nKann Datei im gewaehlten Verzeichnis oeffnen\nBitte pruefen, ob das Verzeichnis existiert!\nerwartet: ");
               errmsg += exfile;
               errmsg += _("\nAbbruch!");
               throwout(errmsg);
               abrt=true;
           }
           if(abrt) break;
           strcpy(buff, (const char*) (hlp1).mb_str(wxConvUTF8));
           fprintf(exfil,"ID_of_key: %s \n",buff);
           strcpy(buff, (const char*) ( (*(ppt+i))->fullnam  ).mb_str(wxConvUTF8));
           fprintf(exfil,"Name_of_Keyholder: %s \n",buff);
           strcpy(buff, (const char*) ( (*(ppt+i))->domnam  ).mb_str(wxConvUTF8));
           fprintf(exfil,"EllipCurve_Domain_Name: %s \n",buff);
           ((*(ppt+i))->A).x.writehex(&hlp1);
           strcpy(buff, (const char*) (hlp1).mb_str(wxConvUTF8));
           fprintf(exfil,"Ax: %s \n",buff);
           ((*(ppt+i))->A).y.writehex(&hlp1);
           strcpy(buff, (const char*) (hlp1).mb_str(wxConvUTF8));
           fprintf(exfil,"Ay: %s \n",buff);
           fclose(exfil);
           throwout(_("Public key exported to \n\n") + exfile, 5);
       }
       //alle rausschreiben
       lbl=fprintf(knfp,"id: %s  Name: %s  \n",(const char*)( (*(ppt+i))->id).mb_str(wxConvUTF8),
                  (const char*)((*(ppt+i))->fullnam).mb_str(wxConvUTF8));
       lbl=fprintf(kfp,"id: %s  Name: %s DomName: %s\n",(const char*)((*(ppt+i))->id).mb_str(wxConvUTF8),
                  (const char*)((*(ppt+i))->fullnam).mb_str(wxConvUTF8),(const char*)((*(ppt+i))->domnam).mb_str(wxConvUTF8) );
      ((*(ppt+i))->A.x).writehex(&txa);
      ((*(ppt+i))->A.y).writehex(&tya);
      lbl=fprintf(kfp,"Ax: %s \n Ay: %s \n \n", (const char*)txa.mb_str(wxConvUTF8), (const char*)tya.mb_str(wxConvUTF8));
    }
    fclose(knfp); fclose(kfp);
    if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
    if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock keynamefile
    liberatekylist(keyno,ppt);
nostop=false;
    return;
}
/***************************************************************************/
bool DeletePubEllky::setkylist(el_pub ***ppt,int *pkeyno)
{
    FILE *kfp;
    int lbl;
    char buff[3202];
    unsigned long fpos;
    wxString hlp;



    if( *ppt!=NULL)
    {
        throwout(_("Fehler, setkylist aufgerufen mit nicht leerer Schluesselliste"),3);
        return false;
    }
    if(nostop==false)
    {
        throwout(_("error, nostop must be true in setkylist!"),3);
        return false;
    }
//    if(S_FIL) unlockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang);
//    if(S_FIL) unlockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang);
    *pkeyno=0;
    kfp=fopen((const char*)(sec_path + _("/e_ell_Keyfile.kyf")).mb_str(wxConvLocal),"r");
// load all keys into memory
    *ppt= (el_pub**)malloc(sizeof(el_pub**));  //set root pointer pointing to one key pointer
    /******* begin loop for setting keylist  ***********/
    do{
        lbl=fscanf(kfp," id: %400s \n",buff);
        if( lbl == EOF) break;  //good end found, go to close file below
        if(lbl==0)
        {
             fpos=ftell(kfp);
             fpos++;
             fseek ( kfp , fpos , SEEK_SET );
        }
        else //read ID properly
        {
          //make wxstring from buff
          hlp= wxString::FromUTF8(buff);
          //mache platz in der Liste
          (*pkeyno)++;
          *ppt= (el_pub **) realloc(*ppt,(*pkeyno)*sizeof(el_pub **)); //make room for one more key pointer pointer
          *(*ppt+*pkeyno-1)= new(el_pub); //allocate new key pointer
          (*(*ppt+*pkeyno-1))->id=hlp;  //set ID field
       //erste id ist drin, nun lade den namen
       do{
        if( (lbl=fscanf(kfp,"Name: %400s ",buff)) == EOF) //load name
           { throwout(_("Name Lesefehler!"));
             fclose(kfp);
            // if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
             //if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock keynamefile
             liberatekylist(*pkeyno,*ppt);
             *pkeyno=0;
             return false;
           }
         } while(lbl != 1 );
       //make wxstring from buff
       hlp= wxString::FromUTF8(buff);
       (*(*ppt+*pkeyno-1))->fullnam=hlp; //set name field
       do{
        if( (lbl=fscanf(kfp," DomName: %400s ",buff)) == EOF)  //load domain name
         { throwout(_("Domain Lesefehler!"));
             fclose(kfp);
             //if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
             //if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock keynamefile
             liberatekylist(*pkeyno,*ppt);
             *pkeyno=0;
             return false;
         }
        } while(lbl != 1 );
    //make wxstring from buff
    hlp= wxString::FromUTF8(buff);
    (*(*ppt+*pkeyno-1))->domnam= hlp; //set domain name

    do{
        if( (lbl=fscanf(kfp,"Ax: %800s ",buff)) !=1 )
        { throwout(_("Pubkey Ax Lesefehler!"));
            fclose(kfp);
             //if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
             //if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock keynamefile
             liberatekylist(*pkeyno,*ppt);
             *pkeyno=0;
             return false;
        }
    } while( lbl != 1);
    // Ax in den key schreiben
    hlp=wxString::FromUTF8(buff);
    if( !(((*(*ppt+*pkeyno-1))->A.x).storhex(&hlp)))
      {  //on error do this
          throwout(_("Lesefehler: Ax")); fclose(kfp);
             //if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
             //if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock keynamefile
             liberatekylist(*pkeyno,*ppt);
             *pkeyno=0;
             return false;
      }
    (*(*ppt+*pkeyno-1))->A.x.setsize();
    (*(*ppt+*pkeyno-1))->A.x.shrinktofit();

    do{
        if( (lbl=fscanf(kfp,"Ay: %800s ",buff)) !=1 )
        { throwout(_("Lesefehler: Pubkey Ay!"));
            fclose(kfp);
             //if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
             //if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock keynamefile
             liberatekylist(*pkeyno,*ppt);
             *pkeyno=0;
             return false;
        }
    } while( lbl != 1);
    hlp=wxString::FromUTF8(buff);
    if( !(((*(*ppt+*pkeyno-1))->A.y).storhex(&hlp))){throwout(_("Lesefehler Ay"));fclose(kfp);
             //if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
             //if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock keynamefile
             liberatekylist(*pkeyno,*ppt);
             *pkeyno=0;
             return false;
            }
    (*(*ppt+*pkeyno-1))->A.y.setsize();
    (*(*ppt+*pkeyno-1))->A.y.shrinktofit();
    }
  } while( true);
  fclose(kfp);
   /*********List is completely set now! ***********/
    return true;
}
/*****************************************************************/
bool DeletePubEllky::storkylist(el_pub **ppt,int keyno)
{
    FILE *kfp,*knfp;
    int i,lbl;
    wxString txa,tya;

    //open files to write list
    kfp=fopen((const char*)(sec_path + _("/e_ell_Keyfile.kyf")).mb_str(wxConvLocal),"w");
    if(kfp==NULL)
    {
        throwout(_("Fehler, konnte Datei der offentl. Schluessel nicht oeffnen!\nKeine Ablage!"),8);
        return false;
    }
    knfp=fopen((const char*)(sec_path + _("/e_ell_knamfile.knf")).mb_str(wxConvLocal),"w");
    if(knfp==NULL)
    {
        throwout(_("Fehler, konnte Datei der offentl. Schluesselnamen nicht oeffnen!\nKeine Ablage!"),8);
        fclose(kfp);
        return false;
    }
    for(i=0;i<keyno;i++)
    {
       //alle rausschreiben
       lbl=fprintf(knfp,"id: %s  Name: %s  \n",(const char*)( (*(ppt+i))->id).mb_str(wxConvUTF8),
                  (const char*)((*(ppt+i))->fullnam).mb_str(wxConvUTF8));
       lbl=fprintf(kfp,"id: %s  Name: %s DomName: %s\n",(const char*)((*(ppt+i))->id).mb_str(wxConvUTF8),
                  (const char*)((*(ppt+i))->fullnam).mb_str(wxConvUTF8),(const char*)((*(ppt+i))->domnam).mb_str(wxConvUTF8) );
      ((*(ppt+i))->A.x).writehex(&txa);
      ((*(ppt+i))->A.y).writehex(&tya);
      lbl=fprintf(kfp,"Ax: %s \n Ay: %s \n \n", (const char*)txa.mb_str(wxConvUTF8), (const char*)tya.mb_str(wxConvUTF8));
    }
    fclose(knfp); fclose(kfp);
    return true;
}
/***************************************************************************/
void DeletePubEllky::OnButtonOneup(wxCommandEvent& event)
{
    int ind, it, keyno,i,indx;
    el_pub **ppt=NULL;
    el_pub *tempk;
    wxString target_id;
    bool found=false;


    half_min_counter=0;
nostop=true;
    if(!checkarm()){Close();}
    //get id of file to delete
    indx=ListBox1->GetSelection();  //key to be exported
    if(indx<0) {throwout(_("Nichts gewaehlt!\nAbbruch!"),2); nostop=false; return;}
    target_id= ids.Item(indx);  //set id of key to work on
    //unlock keyfile and keynamfile
    if(S_FIL) unlockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang);
    if(S_FIL) unlockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang);
    if(!setkylist(&ppt,&keyno))
       {
           throwout(_("Fehler, konnte Schluesselliste nicht lesen"),4);
             if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
             if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock keynamefile
           nostop=false;
           return;
       }
    // determine index
    if(keyno<2)
    {
        if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
        if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock keynamefile
        liberatekylist(keyno,ppt);
           nostop=false;
        return;
    }
    i=0;
    do
    {
        if(  (*(ppt+i))->id == target_id )
        {
            it=i;
            found=true;
        }
        i++;
    }while((found==false)&&(i<keyno));
    if(!found)
    {
        throwout(_("Fehler, Name nicht gefunden???"));
        if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
        if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock keynamefile
        liberatekylist(keyno,ppt);
           nostop=false;
        return;
    }
    if(it==0)
    {
        throwout(_("Bereits oben\nTuNix"));
        if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
        if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock keynamefile
        liberatekylist(keyno,ppt);
           nostop=false;
        return;
    }
    //now all should be good, switch with lower one
    tempk=*(ppt+it-1);
    *(ppt+it-1)=*(ppt+it);
    *(ppt+it)=tempk;
    //now writeout and lock
    storkylist(ppt, keyno);
    if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
    if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock keynamefile
    liberatekylist(keyno,ppt);
           nostop=false;

    //trigger new view
    EndModal(1);
    return;

}
/*************************************************************************/
void DeletePubEllky::OnOnedown(wxCommandEvent& event)
{
    int ind, it, keyno,i,indx;
    el_pub **ppt=NULL;
    el_pub *tempk;
    wxString target_id;
    bool found=false;


    half_min_counter=0;
nostop=true;
    if(!checkarm()){Close();}
    //get id of file to delete
    indx=ListBox1->GetSelection();  //key to be exported
    if(indx<0) {throwout(_("Nichts gewaehlt!\nAbbruch!"),2); nostop=false; return;}
    target_id= ids.Item(indx);  //set id of key to work on
    //unlock keyfile and keynamfile
    if(S_FIL) unlockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang);
    if(S_FIL) unlockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang);
    if(!setkylist(&ppt,&keyno))
       {
           throwout(_("Fehler, konnte Schluesselliste nicht lesen"),4);
             if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
             if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock keynamefile
           nostop=false;
           return;
       }
    // determine index
    if(keyno<2)
    {
        if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
        if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock keynamefile
        liberatekylist(keyno,ppt);
           nostop=false;
        return;
    }
    i=0;
    do
    {
        if(  (*(ppt+i))->id == target_id )
        {
            it=i;
            found=true;
        }
        i++;
    }while((found==false)&&(i<keyno));
    if(!found)
    {
        throwout(_("Fehler, Name nicht gefunden???"));
        if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
        if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock keynamefile
        liberatekylist(keyno,ppt);
           nostop=false;
        return;
    }
    if(it==keyno-1)
    {
        throwout(_("Ist bereits ganz unten"));
        if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
        if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock keynamefile
        liberatekylist(keyno,ppt);
           nostop=false;
        return;
    }
    //now all should be good, switch with lower one
    tempk=*(ppt+it);
    *(ppt+it)=*(ppt+it+1);
    *(ppt+it+1)=tempk;
    //now writeout and lock
    storkylist(ppt, keyno);
    if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
    if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock keynamefile
    liberatekylist(keyno,ppt);
           nostop=false;

    //trigger new view
    EndModal(1);
    return;

}
/*************************************************************************/
void DeletePubEllky::OnToTop(wxCommandEvent& event)
{
    int ind, it, keyno,i,indx;
    el_pub **ppt=NULL;
    el_pub *tempk;
    wxString target_id;
    bool found=false;


    half_min_counter=0;
nostop=true;
    if(!checkarm()){Close();}
    //get id of file to delete
    indx=ListBox1->GetSelection();  //key to be exported
    if(indx<0) {throwout(_("Nichts gewaehlt, Abbruch!"),2); nostop=false; return;}
    target_id= ids.Item(indx);  //set id of key to work on
    //unlock keyfile and keynamfile
    if(S_FIL) unlockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang);
    if(S_FIL) unlockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang);
    if(!setkylist(&ppt,&keyno))
       {
           throwout(_("Konnte Schluesselliste nicht lesen"),4);
             if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
             if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock keynamefile
           nostop=false;
           return;
       }
    // determine index
    if(keyno<2)
    {
        if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
        if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock keynamefile
        liberatekylist(keyno,ppt);
           nostop=false;
        return;
    }
    i=0;
    do
    {
        if(  (*(ppt+i))->id == target_id )
        {
            it=i;
            found=true;
        }
        i++;
    }while((found==false)&&(i<keyno));
    if(!found)
    {
        throwout(_("Lesefehler, Name nicht gefunden???"));
        if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
        if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock keynamefile
        liberatekylist(keyno,ppt);
           nostop=false;
        return;
    }
    if(it==0)
    {
        throwout(_("Bereits ganz oben"));
        if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
        if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock keynamefile
        liberatekylist(keyno,ppt);
           nostop=false;
        return;
    }
    //now all should be good, all down one then insert on top
    tempk= *(ppt+it);
    for(i=it;i>0;i--)
    {
        *(ppt+i)=*(ppt+i-1);
    }
    *(ppt)=tempk;
    //now writeout and lock
    storkylist(ppt, keyno);
    if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
    if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock keynamefile
    liberatekylist(keyno,ppt);
           nostop=false;

    //trigger new view
    EndModal(1);
    return;

}
/*************************************************************************/
void DeletePubEllky::OnToBottom(wxCommandEvent& event)
{
    int ind, it, keyno,i,indx;
    el_pub **ppt=NULL;
    el_pub *tempk;
    wxString target_id;
    bool found=false;


    half_min_counter=0;
nostop=true;
    if(!checkarm()){Close();}
    //get id of file to delete
    indx=ListBox1->GetSelection();  //key to be exported
    if(indx<0) {throwout(_("Nichts gewaehlt, Abbruch!"),2); nostop=false; return;}
    target_id= ids.Item(indx);  //set id of key to work on
    //unlock keyfile and keynamfile
    if(S_FIL) unlockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang);
    if(S_FIL) unlockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang);
    if(!setkylist(&ppt,&keyno))
       {
           throwout(_("Lesefehler Schluesselliste"),4);
             if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
             if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock keynamefile
           nostop=false;
           return;
       }
    // determine index
    if(keyno<2)
    {
        if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
        if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock keynamefile
        liberatekylist(keyno,ppt);
           nostop=false;
        return;
    }
    i=0;
    do
    {
        if(  (*(ppt+i))->id == target_id )
        {
            it=i;
            found=true;
        }
        i++;
    }while((found==false)&&(i<keyno));
    if(!found)
    {
        throwout(_("Lesefehler Name???"));
        if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
        if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock keynamefile
        liberatekylist(keyno,ppt);
           nostop=false;
        return;
    }
    if(it==keyno-1)
    {
        throwout(_("Bereits ganz unten!"));
        if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
        if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock keynamefile
        liberatekylist(keyno,ppt);
           nostop=false;
        return;
    }
    //now all should be good, move keys up then paste low
    tempk= *(ppt+it);
    for(i=it;i<keyno-1;i++)
    {
        *(ppt+i)=*(ppt+i+1);
    }
    *(ppt+keyno-1)=tempk;
    //now writeout and lock
    storkylist(ppt, keyno);
    if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // lock keynamefile
    if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock keynamefile
    liberatekylist(keyno,ppt);
           nostop=false;

    //trigger new view
    EndModal(1);
    return;

}
/*************************************************************************/

