/*
 *   Copyright (C) 2011-2017, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#ifndef RANDOM_CL_H_INCLUDED
#define RANDOM_CL_H_INCLUDED


//#include "globals.h"
#include "dolonu.h"
#define POOL_SIZE 2011  //this is the year this was written :-)
#define SEC_LEV 2   //security level 2: randomize with double rounds

extern longnumber globlonu; //
extern longnumber zugang; //globale longnumber als universalschluessel
extern bool S_FIL; //secure files (default true, use false for debugging

class rpool
{
    public:
      rpool();
      ~rpool();
      bool delayed_init_rpool();
      bool set_pool_from_file(wxString fnam, unsigned long pool_len); //initialize pool
      unsigned char get_rbyte(); //get one random byte
      unsigned long get_ulong();
      unsigned int get_uint();
      bool p_makerandom(longnumber *lnad,unsigned long byteno);
      bool develop(int steps);
      bool key_develop(int steps, longnumber *kyad, unsigned long newsize=0);
      bool sexwith(unsigned long* pmate, unsigned long childsize=0);
      bool sexwith(wxString mate, unsigned long childsize=0);
      bool sexwith(longnumber *pmate, unsigned long childsize=0);
      bool push_bytes(int byteno, unsigned char * destination);
      bool stor_rand_class(wxString fnam=_("x_secrets/randpool.rnpl"));
      bool restore_rand_class(wxString fnam=_("x_secrets/randpool.rnpl"));
      long double chisqtest();

      bool isvirgin;

    private:
      longnumber cntnt; //random data reside here
      longnumber cntnt2; // stack for outgoing randbytes
      unsigned long age; // how often developed
      unsigned long lifespan; //how often developable without  sex (stepcounter)
      bool timerefresh(); //mingle with current time data
      int readcnt;
      bool setlifespan();
      bool refresh_consumable(int steps=2);



};

#endif

