/*
 *   Copyright (C) 2011-2016, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#include "PWShow.h"

//(*InternalHeaders(PWShow)
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/font.h>
//*)

#include "helpersxx.h"

//(*IdInit(PWShow)
const long PWShow::ID_BUTTON1 = wxNewId();
const long PWShow::ID_STATICTEXT1 = wxNewId();
const long PWShow::ID_BUTTON2 = wxNewId();
const long PWShow::ID_TEXTCTRL1 = wxNewId();
const long PWShow::ID_TIMER1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(PWShow,wxDialog)
	//(*EventTable(PWShow)
	//*)
END_EVENT_TABLE()

PWShow::PWShow(wxString* d, wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
	//(*Initialize(PWShow)
	wxFlexGridSizer* FlexGridSizer1;

	Create(parent, id, _("Show Private Key"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("id"));
	FlexGridSizer1 = new wxFlexGridSizer(0, 2, 0, 0);
	Button1 = new wxButton(this, ID_BUTTON1, _("Abbrechen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	Button1->SetBackgroundColour(wxColour(251,161,161));
	wxFont Button1Font(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button1->SetFont(Button1Font);
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Privaten Schluessel anzeigen/editieren. Schliesst nach 30 Sekunden."), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	wxFont StaticText1Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText1->SetFont(StaticText1Font);
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	Button2 = new wxButton(this, ID_BUTTON2, _("Schliessen/Update"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	Button2->SetBackgroundColour(wxColour(186,243,200));
	wxFont Button2Font(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button2->SetFont(Button2Font);
	FlexGridSizer1->Add(Button2, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	TextCtrl1 = new wxTextCtrl(this, ID_TEXTCTRL1, _("deadbeef15badf00d"), wxDefaultPosition, wxSize(754,67), wxTE_MULTILINE, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	TextCtrl1->SetForegroundColour(wxColour(120,11,11));
	TextCtrl1->SetBackgroundColour(wxColour(246,211,211));
	wxFont TextCtrl1Font(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	TextCtrl1->SetFont(TextCtrl1Font);
	FlexGridSizer1->Add(TextCtrl1, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	SetSizer(FlexGridSizer1);
	Timer1.SetOwner(this, ID_TIMER1);
	Timer1.Start(30000, false);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&PWShow::OnExitCancel);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&PWShow::OnExitAccept);
	Connect(ID_TEXTCTRL1,wxEVT_COMMAND_TEXT_UPDATED,(wxObjectEventFunction)&PWShow::OnResetTimer);
	Connect(ID_TEXTCTRL1,wxEVT_COMMAND_TEXT_ENTER,(wxObjectEventFunction)&PWShow::OnExitAccept);
	Connect(ID_TIMER1,wxEVT_TIMER,(wxObjectEventFunction)&PWShow::OnTimer1Trigger);
	//*)
	pd=d; //einbuergern in class
	TextCtrl1->SetValue(*d);
}

PWShow::~PWShow()
{
	//(*Destroy(PWShow)
	//*)
}


void PWShow::OnTimer1Trigger(wxTimerEvent& event)
{
    throwout(_("Timeout\nnichts geaendert!"),3);
    EndModal(0);
}

void PWShow::OnExitCancel(wxCommandEvent& event)
{
    EndModal(0);
}

void PWShow::OnExitAccept(wxCommandEvent& event)
{
    unsigned int i,lino;

    lino=TextCtrl1->GetNumberOfLines();
    *pd =TextCtrl1->GetLineText(0);
    for(i=1;i<lino;i++) //put in the rest
    {
        *pd += TextCtrl1->GetLineText(i);
    }
    throwout(_("Aenderungen\nakzeptiert!"),3);
    EndModal(1);
}

void PWShow::OnResetTimer(wxCommandEvent& event)
{
    Timer1.Start(30000, true);
}
