/***************************************************************
 * Name:      clean_pointersMain.h
 * Purpose:   Defines Application Frame
 * Author:    mca (an@fh-wedel.de)
 * Created:   2010-09-14
 * Copyright: mca ()
 * License:
 **************************************************************/
/*
 *   Copyright (C) 2011-2016, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#ifndef CLEAN_POINTERSMAIN_H
#define CLEAN_POINTERSMAIN_H

#include <stdio.h>


//(*Headers(clean_pointersFrame)
#include <wx/menu.h>
#include <wx/statbmp.h>
#include <wx/frame.h>
#include <wx/statusbr.h>
//*)


class clean_pointersFrame: public wxFrame
{
    public:

        clean_pointersFrame(wxWindow* parent,wxWindowID id = -1);
        virtual ~clean_pointersFrame();

    private:

        //(*Handlers(clean_pointersFrame)
        void OnQuit(wxCommandEvent& event);
        void OnAbout(wxCommandEvent& event);
        void OnInfo(wxCommandEvent& event);
        void OnOpenFile(wxCommandEvent& event);
        void OnEncipher(wxCommandEvent& event);
        void OnDecipher(wxCommandEvent& event);
        void OnRSA_Keys(wxCommandEvent& event);
        void OnPrimtest(wxCommandEvent& event);
        void OnLoadRsa(wxCommandEvent& event);
        void OnExtKeyLoad(wxCommandEvent& event);
        void OnDelete_key(wxCommandEvent& event);
        void OnRsaFile(wxCommandEvent& event);
        void OnRsaDecipher(wxCommandEvent& event);
        void OnBitAnalyze(wxCommandEvent& event);
        void OnByteAnl(wxCommandEvent& event);
        void OnBitCorr(wxCommandEvent& event);
        void OnFileAnalyz(wxCommandEvent& event);
        void OnSignFile(wxCommandEvent& event);
        void OnSignaDoc(wxCommandEvent& event);
        void OnVerifySignature(wxCommandEvent& event);
        void OnCheckKeyset(wxCommandEvent& event);
        void OnSign_II(wxCommandEvent& event);
        void OnVerify_II(wxCommandEvent& event);
        void OnRndSeed(wxCommandEvent& event);
        void On_MC1(wxCommandEvent& event);
        void OnLockFile(wxCommandEvent& event);
        void OnUnlockFile(wxCommandEvent& event);
        void OnSQRT_test(wxCommandEvent& event);
        void OnLonu_enciphertest(wxCommandEvent& event);
        void OnTestLonursa(wxCommandEvent& event);
        void OnTestLock(wxCommandEvent& event);
        void OnTestUnlock(wxCommandEvent& event);
        void OnTestRsaKey(wxCommandEvent& event);
        void OnLonu_to_file(wxCommandEvent& event);
        void OnStoreExternalKey(wxCommandEvent& event);
        void On_secure(wxCommandEvent& event);
        void On_Plain(wxCommandEvent& event);
        void OnTestArith(wxCommandEvent& event);
        void OnBench(wxCommandEvent& event);
        void On_crackit(wxCommandEvent& event);
        void On_analyz_txtconv(wxCommandEvent& event);
        void OnECCS_test1(wxCommandEvent& event);
        void OnHexReadTest(wxCommandEvent& event);
        void OnTestEllipSignature(wxCommandEvent& event);
        void OnLoadDomain(wxCommandEvent& event);
        void OnViewDomPars(wxCommandEvent& event);
        void OnSavePrivateEllipKey(wxCommandEvent& event);
        void OnSignElliptic(wxCommandEvent& event);
        void OnVerifyElliptic(wxCommandEvent& event);
        void OnEllipPublic(wxCommandEvent& event);
        void OnDelPubKey(wxCommandEvent& event);
        void OnDelPrivKey(wxCommandEvent& event);
        void OnChangPW(wxCommandEvent& event);
        void OnRepair(wxCommandEvent& event);
        void OnEllFileEncipher(wxCommandEvent& event);
        void OnEllFileDecipher(wxCommandEvent& event);
        void OnSymmCrypto(wxCommandEvent& event);
        void OnTestCenter(wxCommandEvent& event);
        void OnSettings(wxCommandEvent& event);
        void On_sig_enciph(wxCommandEvent& event);
        void OnMakeTimestamp(wxCommandEvent& event);
        void OnVerifyTimestamp(wxCommandEvent& event);
        void MakeHash(wxCommandEvent& event);
        void OnMakePrimeNumber(wxCommandEvent& event);
        void OnDomSafety(wxCommandEvent& event);
        void gpg_pub_manage(wxCommandEvent& event);
        void gpg_priv_manage(wxCommandEvent& event);
        void gpg_sign_doc(wxCommandEvent& event);
        void gpg_verify_sig(wxCommandEvent& event);
        void OnGnupgSelect(wxCommandEvent& event);
        void OnGPG_encrypt(wxCommandEvent& event);
        void OnGPG_decrypt(wxCommandEvent& event);
        void OnAdvancedSymmetric(wxCommandEvent& event);
        void OnDomainDlg(wxCommandEvent& event);
        void OnCapDialog(wxCommandEvent& event);
        //*)

        //(*Identifiers(clean_pointersFrame)
        static const long ID_STATICBITMAP2;
        static const long idMenuQuit;
        static const long ID_MENUITEM17;
        static const long SETTNGS_ID;
        static const long seedrangen;
        static const long EL_SIGN;
        static const long EL_VERIFY;
        static const long ElEnc;
        static const long ElDec;
        static const long ID_MENUITEM2;
        static const long ID_MAKETIMESTAP;
        static const long ID_VERFY_TIMESTAMP;
        static const long E_OPER;
        static const long savpriv;
        static const long dprivKey;
        static const long dpk;
        static const long LD_EX_PUB;
        static const long ELL_KYS;
        static const long ID_MENUITEM8;
        static const long ID_MENUITEM6;
        static const long vdpars;
        static const long DOM_ID;
        static const long ID_MENUITEM5;
        static const long GPG_SIGN;
        static const long GPG_VERIFY;
        static const long GPG_ENCRYPT;
        static const long GPG_DECRYPT;
        static const long GPG_PUB;
        static const long GPG_PRIV;
        static const long ID_MENUITEM7;
        static const long ID_MENUITEM3;
        static const long ID_MENUITEM4;
        static const long idMenuAbout;
        static const long ID_STATUSBAR1;
        //*)

        //(*Declarations(clean_pointersFrame)
        wxMenu* MenuItem42;
        wxStaticBitmap* StaticBitmap2;
        wxMenuItem* MenuItem57;
        wxMenuItem* MenuItem8;
        wxMenuItem* MenuItem59;
        wxMenu* MenuItem44;
        wxMenuItem* MenuItem54;
        wxMenuItem* MenuItem5;
        wxMenu* Menu3;
        wxMenuItem* MenuItem55;
        wxMenuItem* MenuItem46;
        wxMenuItem* MenuItem4;
        wxMenuItem* MenuItem14;
        wxMenuItem* MenuItem15;
        wxMenuItem* MenuItem22;
        wxMenuItem* MenuItem17;
        wxMenuItem* MenuItem13;
        wxMenuItem* MenuItem10;
        wxMenuItem* MenuItem12;
        wxMenuItem* MenuItem24;
        wxMenuItem* MenuItem20;
        wxStatusBar* StatusBar1;
        wxMenuItem* MenuItem23;
        wxMenuItem* MenuItem51;
        wxMenuItem* MenuItem21;
        wxMenuItem* MenuItem16;
        wxMenu* Menu9;
        wxMenuItem* MenuItem9;
        wxMenuItem* MenuItem18;
        wxMenuItem* MenuItem47;
        wxMenuItem* MenuItem48;
        wxMenu* Menu4;
        wxMenuItem* MenuItem19;
        wxMenu* MenuItem43;
        //*)

        DECLARE_EVENT_TABLE()
};

#endif // CLEAN_POINTERSMAIN_H
