/*
 *   Copyright (C) 2011-2016, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
 

#ifndef SYMMCRYPT_H
#define SYMMCRYPT_H

//(*Headers(SymmCrypt)
#include <wx/sizer.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/choice.h>
#include <wx/button.h>
#include <wx/dialog.h>
//*)

class SymmCrypt: public wxDialog
{
	public:

		SymmCrypt(wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		virtual ~SymmCrypt();

		//(*Declarations(SymmCrypt)
		wxButton* Button4;
		wxChoice* algoc_ctrl;
		wxStaticText* StaticText2;
		wxButton* Button1;
		wxStaticText* StaticText6;
		wxStaticText* StaticText8;
		wxTextCtrl* kloops;
		wxStaticText* StaticText1;
		wxStaticText* StaticText3;
		wxButton* Button2;
		wxTextCtrl* h_len_f;
		wxButton* Button3;
		wxStaticText* StaticText5;
		wxStaticText* StaticText7;
		wxTextCtrl* fnam_ctrl;
		wxTextCtrl* frounds;
		wxStaticText* StaticText4;
		wxTextCtrl* key_ctrl;
		//*)

	protected:

		//(*Identifiers(SymmCrypt)
		static const long ID_STATICTEXT7;
		static const long ID_STATICTEXT8;
		static const long ID_BUTTON2;
		static const long ID_STATICTEXT2;
		static const long ID_TEXTCTRL1;
		static const long ID_BUTTON3;
		static const long ID_STATICTEXT1;
		static const long ID_TEXTCTRL5;
		static const long ID_STATICTEXT3;
		static const long ID_STATICTEXT4;
		static const long ID_STATICTEXT5;
		static const long ID_TEXTCTRL2;
		static const long ID_TEXTCTRL3;
		static const long ID_TEXTCTRL4;
		static const long ID_STATICTEXT6;
		static const long ID_CHOICE_algo;
		static const long ID_BUTTON4;
		static const long ID_BUTTON1;
		//*)

	private:

		//(*Handlers(SymmCrypt)
		void OnAbort(wxCommandEvent& event);
		void OnEncipher(wxCommandEvent& event);
		void OnSelFile(wxCommandEvent& event);
		void OnDecipher(wxCommandEvent& event);
		void OnAlgo_select(wxCommandEvent& event);
		//*)

		DECLARE_EVENT_TABLE()
};

#endif
