/*
 *   Copyright (C) 2011-2012, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
 

#ifndef SIGNDIALOG_H
#define SIGNDIALOG_H

//(*Headers(SignDialog)
#include <wx/sizer.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/statbmp.h>
#include <wx/button.h>
#include <wx/dialog.h>
//*)
#include <wx/msgdlg.h>
#include <wx/filedlg.h>

#include "helpersx.h"
#include "LoadKey.h"


class SignDialog: public wxDialog
{
	public:

		SignDialog(wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		virtual ~SignDialog();

		//(*Declarations(SignDialog)
		wxButton* Button4;
		wxStaticText* StaticText2;
		wxButton* Button1;
		wxStaticBitmap* StaticBitmap1;
		wxTextCtrl* Sig_Id_ctrl;
		wxStaticText* StaticText1;
		wxStaticText* StaticText3;
		wxButton* Button2;
		wxTextCtrl* plain_nam_ctrl;
		wxButton* Button3;
		wxTextCtrl* place_ctrl;
		wxStaticText* StaticText4;
		wxTextCtrl* Path_ctrl;
		//*)

	protected:

		//(*Identifiers(SignDialog)
		static const long ID_STATICTEXT1;
		static const long ID_BUTTON3;
		static const long ID_TEXTCTRL3;
		static const long ID_STATICTEXT2;
		static const long ID_TEXTCTRL2;
		static const long ID_STATICTEXT3;
		static const long ID_SIG_ID;
		static const long ID_STATICTEXT4;
		static const long ID_TEXTCTRL1;
		static const long ID_BUTTON4;
		static const long ID_STATICBITMAP1;
		static const long ID_BUTTON2;
		static const long ID_BUTTON1;
		//*)

	private:

		//(*Handlers(SignDialog)
		void OnTextCtrl1Text(wxCommandEvent& event);
		void OnSeednSign(wxCommandEvent& event);
		void OnCancel(wxCommandEvent& event);
		void OnSelectFile(wxCommandEvent& event);
		void OnSelect_Keyset(wxCommandEvent& event);
		void OnPath_ctrlText(wxCommandEvent& event);
		//*)

		longnumber signval;
		wxString fnam, placedatename;
		bool file_sel;
		bool key_sel;

		DECLARE_EVENT_TABLE()
};

#endif
