#include "globals.h"
#include "SignDialog.h"

//(*InternalHeaders(SignDialog)
#include <wx/bitmap.h>
#include <wx/font.h>
#include <wx/intl.h>
#include <wx/image.h>
#include <wx/string.h>
//*)

//(*IdInit(SignDialog)
const long SignDialog::ID_STATICTEXT1 = wxNewId();
const long SignDialog::ID_BUTTON3 = wxNewId();
const long SignDialog::ID_TEXTCTRL3 = wxNewId();
const long SignDialog::ID_STATICTEXT2 = wxNewId();
const long SignDialog::ID_TEXTCTRL2 = wxNewId();
const long SignDialog::ID_STATICTEXT3 = wxNewId();
const long SignDialog::ID_SIG_ID = wxNewId();
const long SignDialog::ID_STATICTEXT4 = wxNewId();
const long SignDialog::ID_TEXTCTRL1 = wxNewId();
const long SignDialog::ID_BUTTON4 = wxNewId();
const long SignDialog::ID_STATICBITMAP1 = wxNewId();
const long SignDialog::ID_BUTTON2 = wxNewId();
const long SignDialog::ID_BUTTON1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(SignDialog,wxDialog)
	//(*EventTable(SignDialog)
	//*)
END_EVENT_TABLE()

SignDialog::SignDialog(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
	//(*Initialize(SignDialog)
	wxFlexGridSizer* FlexGridSizer1;

	Create(parent, id, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("id"));
	SetClientSize(wxDefaultSize);
	Move(wxDefaultPosition);
	FlexGridSizer1 = new wxFlexGridSizer(0, 2, 0, 0);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Advanced RSA-Signature II"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	StaticText1->SetForegroundColour(wxColour(187,19,19));
	wxFont StaticText1Font(18,wxSWISS,wxFONTSTYLE_NORMAL,wxBOLD,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText1->SetFont(StaticText1Font);
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	Button3 = new wxButton(this, ID_BUTTON3, _("Select File to sign"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON3"));
	wxFont Button3Font(13,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button3->SetFont(Button3Font);
	FlexGridSizer1->Add(Button3, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Path_ctrl = new wxTextCtrl(this, ID_TEXTCTRL3, _("Path/filename"), wxDefaultPosition, wxSize(603,23), 0, wxDefaultValidator, _T("ID_TEXTCTRL3"));
	Path_ctrl->SetForegroundColour(wxColour(0,0,0));
	Path_ctrl->SetBackgroundColour(wxColour(252,230,230));
	wxFont Path_ctrlFont(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Path_ctrl->SetFont(Path_ctrlFont);
	FlexGridSizer1->Add(Path_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText2 = new wxStaticText(this, ID_STATICTEXT2, _("Place, Date  Name"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT2"));
	wxFont StaticText2Font(13,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText2->SetFont(StaticText2Font);
	FlexGridSizer1->Add(StaticText2, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	place_ctrl = new wxTextCtrl(this, ID_TEXTCTRL2, _("Place, Date Name"), wxDefaultPosition, wxSize(470,23), 0, wxDefaultValidator, _T("ID_TEXTCTRL2"));
	wxFont place_ctrlFont(13,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	place_ctrl->SetFont(place_ctrlFont);
	FlexGridSizer1->Add(place_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	StaticText3 = new wxStaticText(this, ID_STATICTEXT3, _("Signature ID:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT3"));
	wxFont StaticText3Font(13,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText3->SetFont(StaticText3Font);
	FlexGridSizer1->Add(StaticText3, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	Sig_Id_ctrl = new wxTextCtrl(this, ID_SIG_ID, _("-"), wxDefaultPosition, wxSize(247,32), 0, wxDefaultValidator, _T("ID_SIG_ID"));
	Sig_Id_ctrl->Disable();
	Sig_Id_ctrl->SetForegroundColour(wxColour(163,9,9));
	Sig_Id_ctrl->SetBackgroundColour(wxColour(149,227,245));
	wxFont Sig_Id_ctrlFont(13,wxSWISS,wxFONTSTYLE_NORMAL,wxBOLD,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Sig_Id_ctrl->SetFont(Sig_Id_ctrlFont);
	FlexGridSizer1->Add(Sig_Id_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	StaticText4 = new wxStaticText(this, ID_STATICTEXT4, _("Signer Plain Name:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT4"));
	wxFont StaticText4Font(13,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText4->SetFont(StaticText4Font);
	FlexGridSizer1->Add(StaticText4, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	plain_nam_ctrl = new wxTextCtrl(this, ID_TEXTCTRL1, _("-"), wxDefaultPosition, wxSize(513,32), 0, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	plain_nam_ctrl->Disable();
	wxFont plain_nam_ctrlFont(13,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	plain_nam_ctrl->SetFont(plain_nam_ctrlFont);
	FlexGridSizer1->Add(plain_nam_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	Button4 = new wxButton(this, ID_BUTTON4, _("Select Sign.Key"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON4"));
	wxFont Button4Font(13,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button4->SetFont(Button4Font);
	FlexGridSizer1->Add(Button4, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticBitmap1 = new wxStaticBitmap(this, ID_STATICBITMAP1, wxBitmap(wxImage(_T("/home/micha137/Projects/fleas_21/unterschrift.png"))), wxDefaultPosition, wxDefaultSize, wxSIMPLE_BORDER, _T("ID_STATICBITMAP1"));
	FlexGridSizer1->Add(StaticBitmap1, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	Button2 = new wxButton(this, ID_BUTTON2, _("Cancel/Done"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	wxFont Button2Font(13,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button2->SetFont(Button2Font);
	FlexGridSizer1->Add(Button2, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button1 = new wxButton(this, ID_BUTTON1, _("Sign"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	Button1->SetBackgroundColour(wxColour(241,167,167));
	wxFont Button1Font(12,wxSWISS,wxFONTSTYLE_ITALIC,wxBOLD,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button1->SetFont(Button1Font);
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	SetSizer(FlexGridSizer1);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_BUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&SignDialog::OnSelectFile);
	Connect(ID_TEXTCTRL3,wxEVT_COMMAND_TEXT_UPDATED,(wxObjectEventFunction)&SignDialog::OnPath_ctrlText);
	Connect(ID_BUTTON4,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&SignDialog::OnSelect_Keyset);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&SignDialog::OnCancel);
	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&SignDialog::OnSeednSign);
	//*)

	file_sel=false;
	key_sel=false;
}

SignDialog::~SignDialog()
{
	//(*Destroy(SignDialog)
	//*)
}


void SignDialog::OnTextCtrl1Text(wxCommandEvent& event)
{
}

void SignDialog::OnSeednSign(wxCommandEvent& event)
{
  wxString sig2, message;

//sind filename und Schlüssel gesetzt
if(!key_sel)
{
    throwout(_("need to select private Keyset first!"));
    return;
}
if(!file_sel)
{
    throwout(_("need to select file to sign first!"));
    return;
}
  //hashwert bestimmen und in sig2 reinschreiben

     if(!get_hash_from_filename(&sig2, &fnam))
        throwout(_(" error in get_hash_from_filename"));

  //Ort Name Datum anhängen
  placedatename =place_ctrl->GetLineText(0);
  placedatename.Replace(_(" "),_("_"));
  sig2 += _(" ") + placedatename;
  //blanks durch underscore ersetzen
  signval.stortext(&sig2);

  //rsa chiffrieren
  enciph_d_rsa(&signval,&privkey);
  //rausschreiben
  fnam += _(".rsg");
  signval.lonu_to_file(fnam);
  //abschluss quittieren und privkey wipen  -> to do WIPE!
  message =_(" signature of file: ");
  message +=fnam;
  message += _("\n successfully created");
  throwout(message);
}
/*******************************************************************/
void SignDialog::OnCancel(wxCommandEvent& event)
{
    Close();
}
/*******************************************************************/
void SignDialog::OnSelectFile(wxCommandEvent& event)
{

    fnam = wxFileSelector(_("Choose a file to open"));
    if ( !fnam.empty() )
    {
        file_sel = true;
        Path_ctrl->SetValue(fnam);
    }
}
/*******************************************************************/
void SignDialog::OnSelect_Keyset(wxCommandEvent& event)
{
    LoadKey dialog(this,1);
    dialog.ShowModal();
    //key_id reinschreiben
    if((privkey.type ==3)||(privkey.type==2))
    {
        Sig_Id_ctrl->SetValue(privkey.kid);
        plain_nam_ctrl->SetValue(privkey.rname);
        key_sel = true;
    }
    else
    {
        throwout(_("Key  is inappropriate for signing"));
        return;
    }
    if(privkey.type==2) throwout(_("Attention, legacy Key Format, \n calculation less efficient \n may take some minutes to sign \n for 2048 bit Key!"));


}
/*******************************************************************/
void SignDialog::OnPath_ctrlText(wxCommandEvent& event)
{
}
/**********************************************************/
