/*
 *   Copyright (C) 2011-2016, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#include "AskInput.h"

//(*InternalHeaders(AskInput)
#include <wx/font.h>
#include <wx/intl.h>
#include <wx/string.h>
//*)

#include "helpersxx.h"

//(*IdInit(AskInput)
const long AskInput::ID_BUTTON1 = wxNewId();
const long AskInput::ID_TEXTCTRL1 = wxNewId();
const long AskInput::ID_STATICTEXT2 = wxNewId();
const long AskInput::ID_TEXTCTRL2 = wxNewId();
const long AskInput::ID_BUTTON2 = wxNewId();
const long AskInput::ID_TIMER1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(AskInput,wxDialog)
	//(*EventTable(AskInput)
	//*)
END_EVENT_TABLE()

AskInput::AskInput(wxWindow* parent,wxString messg, wxString *panswer, wxWindowID id,const wxPoint& pos,const wxSize& size)
{
	//(*Initialize(AskInput)
	wxFlexGridSizer* FlexGridSizer1;

	Create(parent, id, _("Bitte um Antwort in 90 Sekunden"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("id"));
	SetClientSize(wxDefaultSize);
	Move(wxDefaultPosition);
	FlexGridSizer1 = new wxFlexGridSizer(0, 2, 0, 0);
	Button1 = new wxButton(this, ID_BUTTON1, _("Abbrechen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	Button1->SetBackgroundColour(wxColour(246,208,208));
	wxFont Button1Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button1->SetFont(Button1Font);
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	messg_ctrl = new wxTextCtrl(this, ID_TEXTCTRL1, _("-"), wxDefaultPosition, wxSize(494,22), 0, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	messg_ctrl->Disable();
	wxFont messg_ctrlFont(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	messg_ctrl->SetFont(messg_ctrlFont);
	FlexGridSizer1->Add(messg_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	StaticText2 = new wxStaticText(this, ID_STATICTEXT2, _("Eingabe:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT2"));
	wxFont StaticText2Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText2->SetFont(StaticText2Font);
	FlexGridSizer1->Add(StaticText2, 1, wxALL|wxALIGN_RIGHT|wxALIGN_BOTTOM, 5);
	line_ctrl = new wxTextCtrl(this, ID_TEXTCTRL2, wxEmptyString, wxDefaultPosition, wxSize(493,22), wxTE_PROCESS_ENTER, wxDefaultValidator, _T("ID_TEXTCTRL2"));
	line_ctrl->SetFocus();
	wxFont line_ctrlFont(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	line_ctrl->SetFont(line_ctrlFont);
	FlexGridSizer1->Add(line_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	FlexGridSizer1->Add(19,20,1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	Button2 = new wxButton(this, ID_BUTTON2, _("OK"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	Button2->SetBackgroundColour(wxColour(186,242,204));
	wxFont Button2Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button2->SetFont(Button2Font);
	FlexGridSizer1->Add(Button2, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	SetSizer(FlexGridSizer1);
	Timer1.SetOwner(this, ID_TIMER1);
	Timer1.Start(30000, false);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&AskInput::OnCancel);
	Connect(ID_TEXTCTRL2,wxEVT_COMMAND_TEXT_ENTER,(wxObjectEventFunction)&AskInput::OnOk);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&AskInput::OnOk);
	Connect(ID_TIMER1,wxEVT_TIMER,(wxObjectEventFunction)&AskInput::OnTimer1Trigger);
	//*)

	half_min_counter=0;
	messg_ctrl->SetValue(messg);
	//*panswer=_("test");
	pansw=&(*panswer);
	line_ctrl->SetValue(*panswer);
}

AskInput::~AskInput()
{
	//(*Destroy(AskInput)
	//*)
}

/********************************************************/
void AskInput::OnCancel(wxCommandEvent& event)
{
    pansw->Empty();
    EndModal(0);
    return;
}
/****************************************************/
void AskInput::OnOk(wxCommandEvent& event)
{
    wxString lt;

    lt= line_ctrl->GetLineText(0);
    *pansw=lt;
    EndModal(1);
    return;
}
/*************************************************************/
void AskInput::OnTimer1Trigger(wxTimerEvent& event)
{
    if(half_min_counter>1) //more than 90 seconds
    {
        pansw->Empty();
        EndModal(0);
        throwout(_("timeout\nFenster wird geschlossen!"),2);
        return;
    }
    else
    {
        Timer1.Start(30000, true);
        half_min_counter++;
        return;
    }
}
/************************************************************************/
