/*
 *   Copyright (C) 2011-2012, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#include "SymmCrypt.h"
#include "globals.h"

//(*InternalHeaders(SymmCrypt)
#include <wx/font.h>
#include <wx/intl.h>
#include <wx/string.h>
//*)
#include <wx/filedlg.h>
#include "helpersxx.h"


//(*IdInit(SymmCrypt)
const long SymmCrypt::ID_STATICTEXT7 = wxNewId();
const long SymmCrypt::ID_STATICTEXT8 = wxNewId();
const long SymmCrypt::ID_BUTTON2 = wxNewId();
const long SymmCrypt::ID_STATICTEXT2 = wxNewId();
const long SymmCrypt::ID_TEXTCTRL1 = wxNewId();
const long SymmCrypt::ID_BUTTON3 = wxNewId();
const long SymmCrypt::ID_STATICTEXT1 = wxNewId();
const long SymmCrypt::ID_TEXTCTRL5 = wxNewId();
const long SymmCrypt::ID_STATICTEXT3 = wxNewId();
const long SymmCrypt::ID_STATICTEXT4 = wxNewId();
const long SymmCrypt::ID_STATICTEXT5 = wxNewId();
const long SymmCrypt::ID_TEXTCTRL2 = wxNewId();
const long SymmCrypt::ID_TEXTCTRL3 = wxNewId();
const long SymmCrypt::ID_TEXTCTRL4 = wxNewId();
const long SymmCrypt::ID_STATICTEXT6 = wxNewId();
const long SymmCrypt::ID_CHOICE_algo = wxNewId();
const long SymmCrypt::ID_BUTTON4 = wxNewId();
const long SymmCrypt::ID_BUTTON1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(SymmCrypt,wxDialog)
	//(*EventTable(SymmCrypt)
	//*)
END_EVENT_TABLE()

SymmCrypt::SymmCrypt(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
	//(*Initialize(SymmCrypt)
	wxFlexGridSizer* FlexGridSizer1;

	Create(parent, id, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("id"));
	SetClientSize(wxDefaultSize);
	Move(wxDefaultPosition);
	FlexGridSizer1 = new wxFlexGridSizer(0, 3, 0, 0);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	StaticText7 = new wxStaticText(this, ID_STATICTEXT7, _("Symmetrisch Ver/Entschluesselung"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT7"));
	wxFont StaticText7Font(13,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText7->SetFont(StaticText7Font);
	FlexGridSizer1->Add(StaticText7, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	StaticText8 = new wxStaticText(this, ID_STATICTEXT8, _("Caution! This dialog implements the ciphers with nude passwords, no salting and stretching\nCiphers may be vulnerable to dictionary attacks.\nCannot decipher the armoured ciphers of academic signature any more!"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT8"));
	wxFont StaticText8Font(8,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText8->SetFont(StaticText8Font);
	FlexGridSizer1->Add(StaticText8, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	Button2 = new wxButton(this, ID_BUTTON2, _("Abbrechen"), wxDefaultPosition, wxSize(64,24), 0, wxDefaultValidator, _T("ID_BUTTON2"));
	Button2->SetBackgroundColour(wxColour(247,164,164));
	FlexGridSizer1->Add(Button2, 1, wxALL|wxALIGN_LEFT|wxALIGN_TOP, 5);
	StaticText2 = new wxStaticText(this, ID_STATICTEXT2, _("Schluessel:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT2"));
	FlexGridSizer1->Add(StaticText2, 1, wxALL|wxALIGN_LEFT|wxALIGN_TOP, 5);
	key_ctrl = new wxTextCtrl(this, ID_TEXTCTRL1, _("Geheim"), wxDefaultPosition, wxSize(464,23), 0, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	key_ctrl->SetMaxLength(200);
	FlexGridSizer1->Add(key_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_TOP, 5);
	Button3 = new wxButton(this, ID_BUTTON3, _("Datei waehlen"), wxDefaultPosition, wxSize(77,22), 0, wxDefaultValidator, _T("ID_BUTTON3"));
	FlexGridSizer1->Add(Button3, 1, wxALL|wxALIGN_LEFT|wxALIGN_TOP, 5);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Dateiname"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	fnam_ctrl = new wxTextCtrl(this, ID_TEXTCTRL5, wxEmptyString, wxDefaultPosition, wxSize(461,22), 0, wxDefaultValidator, _T("ID_TEXTCTRL5"));
	FlexGridSizer1->Add(fnam_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_TOP, 5);
	StaticText3 = new wxStaticText(this, ID_STATICTEXT3, _("Feistel Runden"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT3"));
	FlexGridSizer1->Add(StaticText3, 1, wxALL|wxALIGN_TOP|wxALIGN_CENTER_HORIZONTAL, 5);
	StaticText4 = new wxStaticText(this, ID_STATICTEXT4, _("Roundfunct. Schleifen"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT4"));
	FlexGridSizer1->Add(StaticText4, 1, wxALL|wxALIGN_TOP|wxALIGN_CENTER_HORIZONTAL, 5);
	StaticText5 = new wxStaticText(this, ID_STATICTEXT5, _("Halflength(Feistel) (>30)"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT5"));
	FlexGridSizer1->Add(StaticText5, 1, wxALL|wxALIGN_TOP|wxALIGN_CENTER_HORIZONTAL, 5);
	frounds = new wxTextCtrl(this, ID_TEXTCTRL2, _("4"), wxDefaultPosition, wxSize(44,23), wxTE_RIGHT, wxDefaultValidator, _T("ID_TEXTCTRL2"));
	frounds->SetMaxLength(2);
	FlexGridSizer1->Add(frounds, 1, wxALL|wxALIGN_TOP|wxALIGN_CENTER_HORIZONTAL, 5);
	kloops = new wxTextCtrl(this, ID_TEXTCTRL3, _("2"), wxDefaultPosition, wxSize(43,23), wxTE_RIGHT, wxDefaultValidator, _T("ID_TEXTCTRL3"));
	kloops->SetMaxLength(5);
	FlexGridSizer1->Add(kloops, 1, wxALL|wxALIGN_TOP|wxALIGN_CENTER_HORIZONTAL, 5);
	h_len_f = new wxTextCtrl(this, ID_TEXTCTRL4, _("512"), wxDefaultPosition, wxSize(55,23), wxTE_RIGHT, wxDefaultValidator, _T("ID_TEXTCTRL4"));
	h_len_f->SetMaxLength(5);
	FlexGridSizer1->Add(h_len_f, 1, wxALL|wxALIGN_TOP|wxALIGN_CENTER_HORIZONTAL, 5);
	StaticText6 = new wxStaticText(this, ID_STATICTEXT6, _("Algorithmus waehlen:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT6"));
	FlexGridSizer1->Add(StaticText6, 1, wxALL|wxALIGN_RIGHT|wxALIGN_TOP, 5);
	algoc_ctrl = new wxChoice(this, ID_CHOICE_algo, wxDefaultPosition, wxSize(141,25), 0, 0, 0, wxDefaultValidator, _T("ID_CHOICE_algo"));
	algoc_ctrl->Append(_("Fleas_1_8"));
	algoc_ctrl->Append(_("Fleas_3"));
	algoc_ctrl->Append(_("Fleas_4"));
	algoc_ctrl->Append(_("Fleas_5"));
	algoc_ctrl->Append(_("Fleas_x2"));
	algoc_ctrl->Append(_("Fleas_x5"));
	algoc_ctrl->Append(_("Fleas_o2"));
	algoc_ctrl->Append(_("Fleas_o5"));
	algoc_ctrl->SetSelection( algoc_ctrl->Append(_("Fleas_lean")) );
	algoc_ctrl->Append(_("Fleas_ls"));
	algoc_ctrl->Append(_("Fleas_l3"));
	algoc_ctrl->Append(_("Fleas_lc"));
	algoc_ctrl->Append(_("AES_256"));
	algoc_ctrl->Append(_("F_cnt_1c"));
	algoc_ctrl->Append(_("F_cnt_1d"));
	algoc_ctrl->Append(_("F_cnt_1b"));
	FlexGridSizer1->Add(algoc_ctrl, 1, wxALL|wxALIGN_TOP|wxALIGN_CENTER_HORIZONTAL, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button4 = new wxButton(this, ID_BUTTON4, _("Chiffrieren"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON4"));
	Button4->SetBackgroundColour(wxColour(178,244,178));
	FlexGridSizer1->Add(Button4, 1, wxALL|wxALIGN_LEFT|wxALIGN_TOP, 5);
	Button1 = new wxButton(this, ID_BUTTON1, _("Dechiffrieren"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	Button1->SetBackgroundColour(wxColour(32,214,228));
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	SetSizer(FlexGridSizer1);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&SymmCrypt::OnAbort);
	Connect(ID_BUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&SymmCrypt::OnSelFile);
	Connect(ID_CHOICE_algo,wxEVT_COMMAND_CHOICE_SELECTED,(wxObjectEventFunction)&SymmCrypt::OnAlgo_select);
	Connect(ID_BUTTON4,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&SymmCrypt::OnEncipher);
	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&SymmCrypt::OnDecipher);
	//*)
}

SymmCrypt::~SymmCrypt()
{
	//(*Destroy(SymmCrypt)
	//*)
}


void SymmCrypt::OnAbort(wxCommandEvent& event)
{
    //Close();
    EndModal(0);
}

void SymmCrypt::OnEncipher(wxCommandEvent& event)
{
    wxString fnam,skey,algo,h;
    int fr, kr, h_len,anum,keylen,namlen;
    char bky[802];
    char *bfnam;
    bool ciphres;


    //get file name
    fnam = fnam_ctrl->GetLineText(0);
    //truncate to 800
    namlen=fnam.Len();
    if(namlen>1000) {throwout(_("filename too long, aborting")); return;}
    else bfnam = (char *) malloc(2*fnam.Len()+2);
    strcpy( bfnam, (const char*)fnam.mb_str(wxConvLocal) );
    //get key
    skey = key_ctrl->GetLineText(0);
    //truncate to 400
    if(skey.Len()>400) skey.Truncate(400);
    keylen= skey.Len();
    strcpy( bky, (const char*)skey.mb_str(wxConvUTF8) );
    //get pars
    h=kloops->GetLineText(0);
    kr=wxAtoi(h);
    h=frounds->GetLineText(0);
    fr=wxAtoi(h);
    h=h_len_f->GetLineText(0);
    h_len=wxAtoi(h);
    //get algo
    anum= algoc_ctrl->GetCurrentSelection();
    if(anum==0) algo=_("Fleas_1_8");
      else if(anum==1) algo= _("Fleas_3");
      else if(anum==2) algo= _("Fleas_4");
      else if(anum==3) algo= _("Fleas_5");
      else if(anum==4) algo= _("Fleas_x2");
      else if(anum==5) algo= _("Fleas_x5");
      else if(anum==6) algo= _("Fleas_o2");
      else if(anum==7) algo= _("Fleas_o5");
      else if(anum==8) algo= _("Fleas_l");
      else if(anum==9) algo= _("Fleas_ls");
      else if(anum==10) algo= _("Fleas_l3");
      else if(anum==11) algo= _("Fleas_lc");
      else if(anum==12) algo= _("aes");
      else if(anum==13) algo= _("F_cnt_1c");
      else if(anum==14) algo= _("F_cnt_1d");
      else if(anum==15) algo= _("F_cnt_1b");
        else{ throwout(_("No algorithm specified! \nAborting.")); free(bfnam);return;}
    //encipher file

    ciphres=encipher_file(bfnam, &bky[0], keylen, (char) fr, kr, h_len, 1, algo,1);
    free(bfnam);
    //give message
    if(ciphres) throwout(_("enciphered"));
     else throwout(_("enciphering FAILED!"));
    return;
}

void SymmCrypt::OnSelFile(wxCommandEvent& event)
{
    wxString fnam;

    fnam = wxFileSelector(_("Choose a file to en/decipher"),cry_path);
    if ( !fnam.empty() )
    {
        fnam_ctrl->SetValue(fnam);
    }
}

void SymmCrypt::OnDecipher(wxCommandEvent& event)
{
    wxString fnam,skey,algo,h;
    int fr, kr, h_len,anum,keylen;
    char *bfnam,bky[802];
    bool ciphres;


    //get file name
    fnam = fnam_ctrl->GetLineText(0);
    //truncate to 800
    if(fnam.Len()>1000) {throwout(_("filename too long, aborting")); return;}
    else bfnam = (char *) malloc(2*fnam.Len()+2);
    strcpy( bfnam, (const char*)fnam.mb_str(wxConvLocal) );
    //get key
    skey = key_ctrl->GetLineText(0);
    //truncate to 400
    if(skey.Len()>400) skey.Truncate(400);
    keylen= skey.Len();
    strcpy( bky, (const char*)skey.mb_str(wxConvUTF8) );
    //get pars
    h=kloops->GetLineText(0);
    kr=wxAtoi(h);
    h=frounds->GetLineText(0);
    fr=wxAtoi(h);
    h=h_len_f->GetLineText(0);
    h_len=wxAtoi(h);
    //get algo
    anum= algoc_ctrl->GetCurrentSelection();
    if(anum==0) algo=_("Fleas_1_8");
      else if(anum==1) algo= _("Fleas_3");
      else if(anum==2) algo= _("Fleas_4");
      else if(anum==3) algo= _("Fleas_5");
      else if(anum==4) algo= _("Fleas_x2");
      else if(anum==5) algo= _("Fleas_x5");
      else if(anum==6) algo= _("Fleas_o2");
      else if(anum==7) algo= _("Fleas_o5");
      else if(anum==8) algo= _("Fleas_l");
      else if(anum==9) algo= _("Fleas_ls");
      else if(anum==10) algo= _("Fleas_l3");
      else if(anum==11) algo= _("Fleas_lc");
      else if(anum==12) algo= _("aes");
      else if(anum==13) algo= _("F_cnt_1c");
      else if(anum==14) algo= _("F_cnt_1d");
      else if(anum==15) algo= _("F_cnt_1b");

         else{ throwout(_("No algorithm specified! \nAborting.")); free(bfnam);return;}
    //encipher file

    ciphres=decipher_file(bfnam, &bky[0], keylen, (char) fr, kr, h_len, 1, algo,1);
    free(bfnam);
    //give message
    if(ciphres) throwout(_("deciphered"));
     else throwout(_("deciphering FAILED!"));
    return;
}

void SymmCrypt::OnAlgo_select(wxCommandEvent& event)
{
    int frn, krn, blsn,anum;
    wxString h;
    //check which was selected
    anum= algoc_ctrl->GetCurrentSelection();
    if(anum<2) {frn=4; krn=2; blsn=65;}
    else if((anum>=2)&&(anum<=5)) {frn=5; krn=3; blsn=512;}
    else if((anum>=6)&&(anum<=9)) {frn=4; krn=2; blsn=512;}
    else if((anum==10)||(anum==11)) {frn=4; krn=3; blsn=512;}
    else if(anum==12){frn=0; krn=1; blsn=16;}
    else if((anum==13)||(anum==14)||(anum==15)) {frn=0; krn=1; blsn=480;}
     else{throwout(_("unknown algorithm")); frn=4; krn=2; blsn=65;} // in error use defaults, should not occur
    //set accordingly
    h.Printf(_("%d"),frn);
    frounds->SetValue(h);
    h.Printf(_("%d"),krn);
    kloops->SetValue(h);
    h.Printf(_("%d"),blsn);
    h_len_f->SetValue(h);
    return;
}
