/*
 *   Copyright (C) 2011-2016, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#include "Seedial.h"
#include "globals.h"
#include "random_clx.h"
//#include "helpersxx.h" //enthaelt auch dolonu.h

//(*InternalHeaders(Seedial)
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/font.h>
//*)



//(*IdInit(Seedial)
const long Seedial::ID_BUTTON2 = wxNewId();
const long Seedial::ID_STATICTEXT1 = wxNewId();
const long Seedial::ID_STATICTEXT2 = wxNewId();
const long Seedial::ID_BUTTON1 = wxNewId();
const long Seedial::ID_TEXTCTRL1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(Seedial,wxDialog)
	//(*EventTable(Seedial)
	//*)
END_EVENT_TABLE()

Seedial::Seedial(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
	//(*Initialize(Seedial)
	wxFlexGridSizer* FlexGridSizer1;

	Create(parent, id, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("id"));
	SetClientSize(wxDefaultSize);
	Move(wxDefaultPosition);
	FlexGridSizer1 = new wxFlexGridSizer(0, 2, 0, 0);
	Button2 = new wxButton(this, ID_BUTTON2, _("Schliessen"), wxDefaultPosition, wxSize(168,30), 0, wxDefaultValidator, _T("ID_BUTTON2"));
	Button2->SetBackgroundColour(wxColour(246,154,154));
	wxFont Button2Font(11,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button2->SetFont(Button2Font);
	FlexGridSizer1->Add(Button2, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Erstellen/Regenerieren des Zufallszahlengenerators durch Zeichenmix"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	wxFont StaticText1Font(12,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText1->SetFont(StaticText1Font);
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText2 = new wxStaticText(this, ID_STATICTEXT2, _("Sie brauchen sich nichts zu merken, einfach lostippen ;-)"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT2"));
	wxFont StaticText2Font(10,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText2->SetFont(StaticText2Font);
	FlexGridSizer1->Add(StaticText2, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button1 = new wxButton(this, ID_BUTTON1, _("Erstellen/Regenerieren"), wxDefaultPosition, wxSize(150,34), 0, wxDefaultValidator, _T("ID_BUTTON1"));
	Button1->SetBackgroundColour(wxColour(245,204,243));
	wxFont Button1Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button1->SetFont(Button1Font);
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	rndseed_ctrl = new wxTextCtrl(this, ID_TEXTCTRL1, _("Tippen Sie einen wilden Zeichenwurm in dieses Feld!"), wxDefaultPosition, wxSize(604,23), wxTE_PROCESS_ENTER, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	wxFont rndseed_ctrlFont(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	rndseed_ctrl->SetFont(rndseed_ctrlFont);
	FlexGridSizer1->Add(rndseed_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	SetSizer(FlexGridSizer1);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&Seedial::OnCancel);
	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&Seedial::OnSeed01);
	Connect(ID_TEXTCTRL1,wxEVT_COMMAND_TEXT_ENTER,(wxObjectEventFunction)&Seedial::OnSeed01);
	//*)
	if(zuf.isvirgin) zuf.delayed_init_rpool(); //zufallsgenerator initialisieren
}

Seedial::~Seedial()
{
	//(*Destroy(Seedial)
	//*)
}


void Seedial::OnSeed01(wxCommandEvent& event)
{
        wxString seed;

    seed=rndseed_ctrl->GetLineText(0);
    globlonu.stortext(&seed);
    globlonu.randomize(2,1 );
    //now rework randclass
    zuf.sexwith(&globlonu);
    throwout(_("Der Zufallszahlengenerator wurde\nmit den gegebenen Zeichen\nerfolgreich neu gemischt."),5);
    Close();
}

void Seedial::OnCancel(wxCommandEvent& event)
{
    Close();
}

