/*
 *   Copyright (C) 2011-2016, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#if defined(__WXMSW__)
  //to be filled
#else
 #include <sys/mman.h>  //allow for memory locking of keyinfo
#endif


#include "hatching.h"

//(*InternalHeaders(hatching)
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/font.h>
//*)

#include "globals.h"
#include "AskDialog.h"
#include "AskInput.h"

//(*IdInit(hatching)
const long hatching::ID_STATICTEXT3 = wxNewId();
const long hatching::ID_STATICTEXT4 = wxNewId();
const long hatching::ID_STATICTEXT1 = wxNewId();
const long hatching::ID_TEXTCTRL1 = wxNewId();
const long hatching::ID_STATICTEXT2 = wxNewId();
const long hatching::ID_TEXTCTRL2 = wxNewId();
const long hatching::ID_STATICTEXT5 = wxNewId();
const long hatching::ID_SALT_INI = wxNewId();
const long hatching::ID_BUTTON1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(hatching,wxDialog)
	//(*EventTable(hatching)
	//*)
END_EVENT_TABLE()

hatching::hatching(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
    wxString salt_str;
    FILE *fp;

	//(*Initialize(hatching)
	wxFlexGridSizer* FlexGridSizer1;

	Create(parent, id, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("id"));
	SetClientSize(wxDefaultSize);
	Move(wxDefaultPosition);
	SetBackgroundColour(wxColour(222,177,177));
	FlexGridSizer1 = new wxFlexGridSizer(0, 2, 0, 0);
	StaticText3 = new wxStaticText(this, ID_STATICTEXT3, _("Passphrase auswaehlen"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT3"));
	wxFont StaticText3Font(13,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_BOLD,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText3->SetFont(StaticText3Font);
	FlexGridSizer1->Add(StaticText3, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText4 = new wxStaticText(this, ID_STATICTEXT4, _("Weniger als 14 Buchstaben ist verantwortungslos!"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT4"));
	StaticText4->SetForegroundColour(wxColour(141,15,15));
	wxFont StaticText4Font(11,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText4->SetFont(StaticText4Font);
	FlexGridSizer1->Add(StaticText4, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Bitte sorgfaeltige starke\nPassphrase waehlen:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	wxFont StaticText1Font(10,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText1->SetFont(StaticText1Font);
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	paphr1_ctrl = new wxTextCtrl(this, ID_TEXTCTRL1, wxEmptyString, wxDefaultPosition, wxSize(467,22), 0, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	paphr1_ctrl->SetFocus();
	wxFont paphr1_ctrlFont(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	paphr1_ctrl->SetFont(paphr1_ctrlFont);
	FlexGridSizer1->Add(paphr1_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText2 = new wxStaticText(this, ID_STATICTEXT2, _("Wiederholen:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT2"));
	wxFont StaticText2Font(9,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText2->SetFont(StaticText2Font);
	FlexGridSizer1->Add(StaticText2, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	paphr2_ctrl = new wxTextCtrl(this, ID_TEXTCTRL2, wxEmptyString, wxDefaultPosition, wxSize(467,22), 0, wxDefaultValidator, _T("ID_TEXTCTRL2"));
	wxFont paphr2_ctrlFont(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	paphr2_ctrl->SetFont(paphr2_ctrlFont);
	FlexGridSizer1->Add(paphr2_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText5 = new wxStaticText(this, ID_STATICTEXT5, _("Salt in hex Darstellung:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT5"));
	wxFont StaticText5Font(10,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText5->SetFont(StaticText5Font);
	FlexGridSizer1->Add(StaticText5, 1, wxALL|wxALIGN_RIGHT|wxALIGN_TOP, 5);
	salit_ctrl = new wxTextCtrl(this, ID_SALT_INI, wxEmptyString, wxDefaultPosition, wxSize(466,22), 0, wxDefaultValidator, _T("ID_SALT_INI"));
	wxFont salit_ctrlFont(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	salit_ctrl->SetFont(salit_ctrlFont);
	FlexGridSizer1->Add(salit_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_TOP, 5);
	Button1 = new wxButton(this, ID_BUTTON1, _("Initialisieren und Einpraegen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	Button1->SetBackgroundColour(wxColour(174,245,182));
	wxFont Button1Font(10,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button1->SetFont(Button1Font);
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	SetSizer(FlexGridSizer1);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_TEXTCTRL2,wxEVT_COMMAND_TEXT_ENTER,(wxObjectEventFunction)&hatching::OnHatch);
	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&hatching::OnHatch);
	//*)
	//insert salt
    salt.makerandom(32);
    //zuf.p_makerandom(&salt,32);
    salt.writehex(&salt_str);
    //write to secrets "salt.txt"
    fp=fopen((const char*)(sec_path + _("/salt.txt")).mb_str(wxConvLocal), "w");
    fprintf(fp," salt:%s \n",(const char*)(salt_str.mb_str(wxConvUTF8)));
    fprintf(fp," stretchfactor: %i \n",stretch);

    fclose(fp);

    fp=fopen((const char*)(sec_path + _("/old_salts.txt")).mb_str(wxConvLocal), "a");
    fprintf(fp,"\n salt:%s \n",(const char*)(salt_str.mb_str(wxConvUTF8)));
    fclose(fp);
    //write salt into field
    salit_ctrl->SetValue(salt_str);
}
/**************************************************/
hatching::~hatching()
{
	//(*Destroy(hatching)
	//*)
}
/***************************************************/
void hatching::OnHatch(wxCommandEvent& event)
{
    wxString pw1,pw2,nams,trunk, privno_txt,number, num2;
    longnumber newky;
    bool res;
    int fll=-1;


    //check if identical entries -> if not message and return
    pw1=paphr1_ctrl->GetLineText(0);
    pw2=paphr2_ctrl->GetLineText(0);
    if(pw1 != pw2)
    {
        throwout(_("Beide Passphrase Einetraege widersprechen sich!"));
        return;
    }
    res=newky.stortext(&pw1);
    //blank hot locations
    pw2=_("deadbeef is bad food");
    paphr1_ctrl->SetValue(pw2);
    paphr2_ctrl->SetValue(pw2);
    if(!res)
    {
        throwout(_("Leere Passphrase\nkeine Recodierung der Dateien\n keine Aenderung und Abbruch."));
        EndModal(0);
        return;
    }
    newky.setsize(true);//no longer needed

    //salt_nreform key
    if(!kyprep(&newky, &pw1, &salt, &stretch_ell, stretch,ss_klen ))  //make ky
    {
        throwout(_("Fataler Fehler in kyprep!!"));
        return;
    }
    //blank last hot wxString
    pw1=pw2;
    //and lock newky
    #if defined(__WXMSW__)
        fll=VirtualLock(newky.ad,newky.length); //already locked in trylogin
// TODO (micha137#1#): Update stamp_ver to use accessbl. directory ...
//extend stretch factor
    #else
      fll=mlock(newky.ad,newky.length);
    #endif

    //recode all files from "default to new key
    if(! recode_all(&newky,&zugang))
    {
        AskDialog dlg(this,_("Geheimdateien scheinen beschaedigt oder fehlen\n ueberschreiben mit Leerdateien(OK) oder Cancel?"));
        if ( dlg.ShowModal() == 0 ) {
            throwout(_("Fehler bei der Recodierung der Geheimdateien\n keine Aenderung und Abbruch"));
            EndModal(0);
            return;  //noch nicht aktiv fuer debugging
        }
        else
        { //create empty templates
//---------------------------------------------------------
    if(!S_FIL)
    {
        //restore empty files if necessary
        if( !wxFileExists(sec_path + _("/ell_knamfile.knf")) || !wxFileExists(sec_path + _("/ell_Keyfile.kyf"))   )
        {
            wxFile fil(sec_path + _("/ell_knamfile.knf"),wxFile::write);
            fil.Write(_("  "));
            fil.Close();
            wxFile fil1(sec_path + _("/ell_Keyfile.kyf"),wxFile::write);
            fil1.Write(_("  "));
            fil1.Close();
            throwout(_("priv. Schluesselliste zurueckgesetzt und geleert"));
        }
        if( !wxFileExists(sec_path + _("/e_ell_knamfile.knf")) || !wxFileExists(sec_path + _("/e_ell_Keyfile.kyf"))   )
        {
            wxFile fil2(sec_path + _("/e_ell_knamfile.knf"),wxFile::write);
            fil2.Write(_("  "));
            fil2.Close();
            wxFile fil3(sec_path + _("/e_ell_Keyfile.kyf"),wxFile::write);
            fil3.Write(_("  "));
            fil3.Close();
            throwout(_("priv. Schluesselliste zurueckgesetzt und geleert"));
        }
    }
    else
    {
      if(S_FIL)
      {
        //restore empty files if necessary
        if( !wxFileExists(sec_path + _("/ell_knamfile.knf_c3")) || !wxFileExists(sec_path + _("/ell_Keyfile.kyf_c3"))   )
        {
            wxFile fil4(sec_path + _("/ell_knamfile.knf"),wxFile::write);
            fil4.Write(_("  "));
            fil4.Close();
            if(!lockinplace(sec_path + _("/ell_knamfile.knf"),&zugang)) throwout(_("error locking ell_knamfile"));

            wxFile fil5(sec_path + _("/ell_Keyfile.kyf"),wxFile::write);
            fil5.Write(_("  "));
            fil5.Close();
            if(!lockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang)) throwout(_("error locking ell_Keyfile"));
            throwout(_("priv. Schluesselliste zurueckgesetzt und geleert"));
        }
        if( !wxFileExists(sec_path + _("/e_ell_knamfile.knf_c3")) || !wxFileExists(sec_path + _("/e_ell_Keyfile.kyf_c3"))   )
        {
            wxFile fil6(sec_path + _("/e_ell_knamfile.knf"),wxFile::write);
            fil6.Write(_("  "));
            fil6.Close();
            if(!lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang)) throwout(_("error locking e_ell_knamfile"));

            wxFile fil7(sec_path + _("/e_ell_Keyfile.kyf"),wxFile::write);
            fil7.Write(_("  "));
            fil7.Close();
            if(!lockinplace(sec_path + _("/e_ell_Keyfile.kyf"),&zugang)) throwout(_("error locking e_ell_Keyfile"));
            throwout(_("priv. Schluesselliste zurueckgesetzt und geleert"));
        }
      }
    }
    EndModal(0);
    is_armed=true;
    lastarmed=time(NULL);

    return;
//----------------------------------------------------------
        }
    }
    zugang.copynum(&newky);
    //save to "paphr_hash.flea"
    newky.randomize(5,NULL,32,0,0); //runden, mateadresse, outlength, cagesize, warnflag
    newky.setsize(true);
    newky.shrinktofit();
    newky.lonu_to_file(sec_path + _("/paphr_hash.flea"));

    //askdialog hier hin
    res=true;

    longnumber nk;
    el_priv npky;
    ellipse locell;
    el_pub pelky;
    FILE *knamfil, *kfil;

    AskDialog ky_dlg(this,_("Soll ein neues privat/oeffentl. Schluesselpaar erzeugt werden ?"));
    if ( ky_dlg.ShowModal() != 0 )
    {
        AskInput nam_dlg(this,_("Bitte geben Sie den mit dem Schluessel verknuepften Namen."),&nams);
        if (nam_dlg.ShowModal() == 0)
        {
            res=false;
        }
        if(res)
        {
         if(nams.IsEmpty()) nams=_("John Doe");
         extr_initials(&nams, &trunk); //extract initials
         nams.Replace(_(" "), _("_"));
         trunk.Replace(_(" "), _("_"));
         //load 768 domain
         locell.ellipse_set_768();
         zuf.p_makerandom(&nk,(int)((locell.q).size+3));
         nk.randomize(2);
         nk.lonumodulo_qqq_e(&(locell.q));
         nk.shrinktofit();
         npky.d.copynum(&nk);
         nk.writehex(&privno_txt);
   //A aus aktueller domain berechnen
         npky.A.copy_ep(&(locell.d0));
         npky.A.mult_p_qj(&(npky.d),&locell);
         pelky.A.copy_ep(&(npky.A));
         npky.domnam= locell.name;
         npky.fullnam=nams;
        //jetzt trunk erweitern
	     pelky.A.x.writehex(&number);
	     trunk +=_("-") + number.Left(4);
	     pelky.A.y.writehex(&number);
         trunk += _("-") +number.Left(4);
         npky.id=trunk;
         pelky.id=trunk;
         pelky.domnam=locell.name;
         pelky.fullnam=nams;

        //jetzt nur noch rausspeichern
         int res_here;
         wxString h2;
         longnumber tempd;

         res_here=keyid_free(pelky.id,false);
         if((res_here & 1) == 1)
         {
           throwout(_("ID wird bereits fuer einen priv. Schluessel verwendet\nSie sollten eine andere ID waehlen!"),20);
           goto finish_it;
         }
         if((res_here & 2) == 2)
         {
           throwout(_("ID wird bereits fuer einen oeffentl. Schluessel verwendet\nSie sollten eine andere ID waehlen!"),20);
           goto finish_it;
         }
    //open keynamfile, append name and id, close keynamfile
         if(S_FIL) unlockinplace(sec_path + _("/ell_knamfile.knf"),&zugang); // unlock keynamefile
         h2= sec_path + _("/ell_knamfile.knf");
         if((knamfil = fopen((const char*)h2.mb_str(wxConvLocal),"a"))== NULL) return;
         fprintf(knamfil, "\n id: %s  Name: %s  ",(const char*)npky.id.mb_str(wxConvUTF8),
                  (const char*)npky.fullnam.mb_str(wxConvUTF8));
         fclose(knamfil);
         if(S_FIL) lockinplace(sec_path + _("/ell_knamfile.knf"),&zugang); // lock again

    //open keyfile, store all data and close
         if(S_FIL) unlockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // unlock keynamefile
         h2= sec_path + _("/ell_Keyfile.kyf");
         if((kfil = fopen((const char*)h2.mb_str(wxConvLocal), "a"))== NULL) return;
         fprintf(kfil, "\n id: %s  Name: %s DomainName: %s",(const char*)npky.id.mb_str(wxConvUTF8),
                  (const char*)npky.fullnam.mb_str(wxConvUTF8),(const char*)npky.domnam.mb_str(wxConvUTF8));
    // doublecrypt: hier vorher extra verschlüsseln
        tempd.copynum(&(npky.d));
        tempd.shrinktofit();
        tempd.lonu_lock(&zugang);
        tempd.writehex(&number);
        fprintf(kfil,"\n d: %s ", (const char*)number.mb_str(wxConvUTF8));
        fprintf(kfil," \n");
        fclose(kfil);
        if(S_FIL) lockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // unlock keynamefile
        throwout(_("Privater Schluessel sicher\n im internen Lager abgelegt"),3);
       //now do for public key
       if(S_FIL) unlockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // unlock keynamefile
       if((knamfil = fopen((const char*)(sec_path + _("/e_ell_knamfile.knf")).mb_str(wxConvLocal), "a"))== NULL) return;
       fprintf(knamfil, "id: %s  Name: %s  \n",(const char*)(pelky.id).mb_str(wxConvUTF8),
                  (const char*)(pelky.fullnam).mb_str(wxConvUTF8));
       fclose(knamfil);
       if(S_FIL) lockinplace(sec_path + _("/e_ell_knamfile.knf"),&zugang); // lock again

    // to do: decrypt keyfile
    //open keyfile, store all data and close
       if(S_FIL) unlockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // unlock keynamefile
       if((kfil = fopen((const char*)(sec_path + _("/e_ell_Keyfile.kyf")).mb_str(wxConvLocal), "a"))== NULL) return;
       fprintf(kfil, "id: %s  Name: %s DomName: %s\n",(const char*)(pelky.id).mb_str(wxConvUTF8),
                  (const char*)(pelky.fullnam).mb_str(wxConvUTF8),(const char*)(pelky.domnam).mb_str(wxConvUTF8) );
       (pelky.A.x).writehex(&number);
       (pelky.A.y).writehex(&num2);

       fprintf(kfil,"Ax: %s \n Ay: %s \n \n", (const char*)number.mb_str(wxConvUTF8), (const char*)num2.mb_str(wxConvUTF8));
       fclose(kfil);
       if(S_FIL) lockinplace_eax(sec_path + _("/e_ell_Keyfile.kyf"),&zugang); // unlock keynamefile
       throwout(_("Oeffentlicher Schluessel ebenfalls\nsicher im internen Lager abgelegt"),2);
       }

     }
//load 768 domain
finish_it:

    is_armed=true;
    lastarmed=time(NULL);

    EndModal(1);
}

