/***************************************************************
 * Name:      clean_pointersMain.cpp
 * Purpose:   Code for Application Frame
 * Author:    mca (an@fh-wedel.de)
 * Created:   2010-09-14
 * Copyright: mca ()
 * License:
 *   Copyright (C) 2011-2016, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#if defined(__WXMSW__)
  //to be filled
#else
 #include <sys/mman.h>  //allow for memory locking of keyinfo
#endif


#include "AskDialog.h"
#include "Cap_Questn.h"
#include "AskInput.h"
#include "deciph_dialog.h"
#include "helpersxx.h"
#include <wx/filedlg.h>
#include <wx/filename.h>

#include <wx/arrstr.h>
#include <wx/dir.h>
#include <wx/busyinfo.h>


//(*InternalHeaders(deciph_dialog)
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/font.h>
//*)

#include "ellky_load1.h"
#include "globals.h"


//(*IdInit(deciph_dialog)
const long deciph_dialog::ID_BUTTON3 = wxNewId();
const long deciph_dialog::ID_STATICTEXT1 = wxNewId();
const long deciph_dialog::ID_STATICTEXT2 = wxNewId();
const long deciph_dialog::ID_TEXTCTRL1 = wxNewId();
const long deciph_dialog::ID_BUTTON1 = wxNewId();
const long deciph_dialog::ID_STATICTEXT3 = wxNewId();
const long deciph_dialog::ID_BUTTON2 = wxNewId();
const long deciph_dialog::ID_STATICTEXT5 = wxNewId();
const long deciph_dialog::ID_STATICTEXT6 = wxNewId();
const long deciph_dialog::ID_STATICTEXT4 = wxNewId();
const long deciph_dialog::ID_TEXTCTRL2 = wxNewId();
const long deciph_dialog::ID_TEXTCTRL3 = wxNewId();
const long deciph_dialog::ID_TEXTCTRL4 = wxNewId();
const long deciph_dialog::ID_CHECKBOX1 = wxNewId();
const long deciph_dialog::ID_BUTTON4 = wxNewId();
//*)

BEGIN_EVENT_TABLE(deciph_dialog,wxDialog)
	//(*EventTable(deciph_dialog)
	//*)
END_EVENT_TABLE()

deciph_dialog::deciph_dialog(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
    if(!checkarm()){Close();}


	//(*Initialize(deciph_dialog)
	wxFlexGridSizer* FlexGridSizer1;

	Create(parent, id, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("id"));
	SetClientSize(wxDefaultSize);
	Move(wxDefaultPosition);
	FlexGridSizer1 = new wxFlexGridSizer(0, 3, 0, 0);
	Button3 = new wxButton(this, ID_BUTTON3, _("Schliessen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON3"));
	Button3->SetBackgroundColour(wxColour(245,171,171));
	wxFont Button3Font(11,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button3->SetFont(Button3Font);
	FlexGridSizer1->Add(Button3, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Datei dechiffrieren (ECC)"), wxDefaultPosition, wxSize(271,25), wxALIGN_CENTRE, _T("ID_STATICTEXT1"));
	wxFont StaticText1Font(14,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText1->SetFont(StaticText1Font);
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(74,20,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText2 = new wxStaticText(this, ID_STATICTEXT2, _("Datei zum\ndechiffrieren"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT2"));
	wxFont StaticText2Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText2->SetFont(StaticText2Font);
	FlexGridSizer1->Add(StaticText2, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	fnam_ctrl = new wxTextCtrl(this, ID_TEXTCTRL1, wxEmptyString, wxDefaultPosition, wxSize(653,23), 0, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	wxFont fnam_ctrlFont(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	fnam_ctrl->SetFont(fnam_ctrlFont);
	FlexGridSizer1->Add(fnam_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button1 = new wxButton(this, ID_BUTTON1, _("Datei waehlen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	wxFont Button1Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button1->SetFont(Button1Font);
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(20,27,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText3 = new wxStaticText(this, ID_STATICTEXT3, _("Privater Schluessel "), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT3"));
	wxFont StaticText3Font(11,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText3->SetFont(StaticText3Font);
	FlexGridSizer1->Add(StaticText3, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	Button2 = new wxButton(this, ID_BUTTON2, _("Privaten\nSchluessel\nauswaehlen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	wxFont Button2Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button2->SetFont(Button2Font);
	FlexGridSizer1->Add(Button2, 1, wxALL|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL, 5);
	StaticText5 = new wxStaticText(this, ID_STATICTEXT5, _("Schluessel ID"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT5"));
	wxFont StaticText5Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText5->SetFont(StaticText5Font);
	FlexGridSizer1->Add(StaticText5, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText6 = new wxStaticText(this, ID_STATICTEXT6, _("Voller Name"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT6"));
	wxFont StaticText6Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText6->SetFont(StaticText6Font);
	FlexGridSizer1->Add(StaticText6, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText4 = new wxStaticText(this, ID_STATICTEXT4, _("Domain Name"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT4"));
	wxFont StaticText4Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText4->SetFont(StaticText4Font);
	FlexGridSizer1->Add(StaticText4, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	pkyid_ctrl = new wxTextCtrl(this, ID_TEXTCTRL2, wxEmptyString, wxDefaultPosition, wxSize(131,26), wxTE_READONLY, wxDefaultValidator, _T("ID_TEXTCTRL2"));
	wxFont pkyid_ctrlFont(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	pkyid_ctrl->SetFont(pkyid_ctrlFont);
	FlexGridSizer1->Add(pkyid_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	fullnam_ctrl = new wxTextCtrl(this, ID_TEXTCTRL3, wxEmptyString, wxDefaultPosition, wxSize(445,26), wxTE_READONLY, wxDefaultValidator, _T("ID_TEXTCTRL3"));
	wxFont fullnam_ctrlFont(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	fullnam_ctrl->SetFont(fullnam_ctrlFont);
	FlexGridSizer1->Add(fullnam_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	domnam_ctrl = new wxTextCtrl(this, ID_TEXTCTRL4, _("Domain Name"), wxDefaultPosition, wxSize(136,23), wxTE_READONLY, wxDefaultValidator, _T("ID_TEXTCTRL4"));
	wxFont domnam_ctrlFont(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	domnam_ctrl->SetFont(domnam_ctrlFont);
	FlexGridSizer1->Add(domnam_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	CheckBox1 = new wxCheckBox(this, ID_CHECKBOX1, _("Nur Dechiffrieren, \nkeine Weiterverarbeitung"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_CHECKBOX1"));
	CheckBox1->SetValue(false);
	wxFont CheckBox1Font(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	CheckBox1->SetFont(CheckBox1Font);
	FlexGridSizer1->Add(CheckBox1, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	Button4 = new wxButton(this, ID_BUTTON4, _("Dechiffrieren"), wxDefaultPosition, wxSize(212,44), 0, wxDefaultValidator, _T("ID_BUTTON4"));
	Button4->SetBackgroundColour(wxColour(156,179,242));
	wxFont Button4Font(11,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button4->SetFont(Button4Font);
	FlexGridSizer1->Add(Button4, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	SetSizer(FlexGridSizer1);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_BUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&deciph_dialog::OnClose);
	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&deciph_dialog::OnFileSelect);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&deciph_dialog::OnSelectPrivKeyFromStore);
	Connect(ID_BUTTON4,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&deciph_dialog::OnDoDecipherNew);
	//*)

	fnam_ctrl->DragAcceptFiles(true);
    fnam_ctrl->Connect(wxEVT_DROP_FILES, wxDropFilesEventHandler(deciph_dialog::OnDropFile), NULL, this);




	//set defaults
	algo==_("Fleas_1_8");
	uncapped= true;
	pars_here=false;
	verbose=false;
}
/*************************************************************/
deciph_dialog::~deciph_dialog()
{
	//(*Destroy(deciph_dialog)
	//*)
}

/*************************************************************/
void deciph_dialog::OnClose(wxCommandEvent& event)
{
    Close();
}
/*************************************************************/
bool deciph_dialog::set_pars_from_file(wxString headfile)
{
    FILE *fp;
    char  fnb[4002],idb[802], dnb[402],bxb[4002],byb[4002], alg[202];
    int fl,elfl;
    wxString h;

    if(!checkarm()){Close();}
    if(headfile.Len()>1000)
    {
        throwout(_("Achtung! Filename viel zu lang\nwird abgeschnietten!\nBitte pruefe, ob ein Angriffsversuch vorliegt!"));
        headfile=headfile.Left(1000);
    }
    if(!wxFileExists(headfile)) return false;
    strcpy( fnb, (const char*)headfile.mb_str(wxConvLocal) );
    fp=fopen(fnb,"r");
    //read kid
    fl=fscanf(fp,"kid: %200s domnam: %100s Bx: %1000s By: %1000s algo: %50s",idb,dnb,bxb,byb,alg);
    if(fl < 4)
        {
            if (verbose) throwout(_("Konnte keinen kompletten Chiffrenheader lesen"));
            fclose(fp);
            return false;
        }

    if(fl < 5) {throwout(_("Konnte den Algorithmusbezeichner nicht lesen\nversuche Fleas_1_8 als default")); algo=_("Fleas_1_8");}
    else algo=wxString::FromUTF8(alg);
    kid=wxString::FromUTF8(idb);
    if(kid == _("xxx"))
    {
        throwout(_("Verdeckte Empfaenger ID!\n Du musst Deinen vermuteten priv. Schluessel angeben."));
    }
    domnam=wxString::FromUTF8(dnb);
    //check domain accessibility
    if(domnam != gdom.name)
    {
        elfl=e_ls.getelp(&locell,domnam);
        if(elfl<0)
        {
             throwout(_("unkek. oder verdeckte Domainn\nDechiffrierung koennte scheitern!"),3);
        }
    }
    else locell.copyell(&gdom);
    h=wxString::FromUTF8(bxb);
    B.x.storhex(&h);
    h=wxString::FromUTF8(byb);
    B.y.storhex(&h);
    B.neutral=false;
    if(!B.is_in_ellipse(&locell))
    {
        throwout(_("B nicht in der ell. Kurve\nDu musst eine andere Domain laden!"));
        fclose(fp);
        return false;
    }
    fclose(fp);
    return true;
}

/*************************************************************/
bool deciph_dialog::LoadPrivKey(wxString keyid)
{
    FILE *kfp;
    char buff[1000];
    wxString hlp;
    int lbl,lbd,elfl,fll;
    unsigned long fpos;
//    bool f;

    if(!checkarm()){Close();}
    if(S_FIL) unlockinplace( sec_path + _("/ell_Keyfile.kyf"),&zugang); // unlock keynamefile
    kfp=fopen((const char*)(sec_path + _("/ell_Keyfile.kyf")).mb_str(wxConvLocal) ,"r");
    do{
        lbl=fscanf(kfp," id: %200s",buff);
        if( lbl ==1)
        {
          hlp= wxString::FromUTF8(buff);
          if(hlp != keyid)
          {
             lbd=fscanf(kfp," Name: %*s ");
             lbd=fscanf(kfp," DomainName: %*s ");
             lbd=fscanf(kfp," d: %*s ");
          }
        }
        if( lbl == EOF)
        { throwout(_("Key read Error!"));
         fclose(kfp);
         if(S_FIL) lockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // lock keynamefile
           return false;
        }
        if(lbl==0)
        {
             fpos=ftell(kfp);
             fpos++;
             fseek ( kfp , fpos , SEEK_SET );
        } else{
          //make wxstring from buff
          //hlp= wxString::FromUTF8(buff);  //already done
        }
    } while( hlp != keyid);
    loky.id =keyid;
    do{
        if(( (lbl=fscanf(kfp," Name: %400s",buff)) == EOF)||lbl==0)
        { throwout(_("Name read Error!"));
         fclose(kfp);
         if(S_FIL) lockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // lock keynamefile
           return false;
        }
    } while(lbl != 1 );
    //make wxstring from buff
    hlp= wxString::FromUTF8(buff);
    //underscore durch blank ersetzen
    hlp.Replace(_("_"),_(" "));
    //buff Name nach privkey.rname schreiben
    loky.fullnam= hlp;
    //Domain Name:
    do{
        if(( (lbl=fscanf(kfp," DomainName: %400s",buff)) == EOF)||(lbl==0))
        { throwout(_("DomainName read Error!"));
         fclose(kfp);
         if(S_FIL) lockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // lock keynamefile
           return false;
        }
    } while(lbl != 1 );
    //make wxstring from buff
    hlp= wxString::FromUTF8(buff);
    //buff Name nach privkey.rname schreiben
    loky.domnam= hlp;
//lesen der privaten Zahl d:
        if( (lbl=fscanf(kfp," d: %1000s",buff)) !=1 )
        { throwout(_("Privkey d read Error!"));
            fclose(kfp);
            if(S_FIL) lockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // lock keynamefile
            return false;
        }
    // d in den globalen key schreiben
    hlp=wxString::FromUTF8(buff);
    if( !((loky.d).storhex(&hlp))){throwout(_("error reading d")); fclose(kfp);
         if(S_FIL) lockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // lock keynamefile
         return false;}
    //double_cipher d regenerieren
    loky.d.lonu_unlock(&zugang);
    //double_cipher done
    loky.d.setsize(); loky.d.shrinktofit();
    #if defined(__WXMSW__)
        fll=VirtualLock(loky.d.ad,loky.d.length); //already locked in trylogin
    #else
        fll=mlock(loky.d.ad,loky.d.length);
    #endif

    fclose(kfp);
    if(S_FIL) lockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // lock keynamefile
    //check domain accessibility
    if(loky.domnam != gdom.name)
    {
        elfl=e_ls.getelp(&locell,domnam);
        if(elfl<0)
        {
            throwout(_("uUnbekannte Schluesseldomain\ndechiffr. unmoeglich!"),3);
        }
    }
    else locell.copyell(&gdom);
    elky.set_el_priv(&(loky.d),&(locell),loky.id,loky.fullnam);
    throwout(_("Konnte geeigneten priv. Schluessel auswaehlen :-)."),3);
    def_privkey=loky.id;
    pars_here=true;
    return true;
}
/*******************************************************/
void deciph_dialog::OnDropFile(wxDropFilesEvent& event)
    {
    wxString mypath,myname,separator,s,cry_d;
    longnumber rndnam;
    FILE *knfp;
    int count,lbl;
    bool found=false;
    char buff1[200];
        int  filno;
        drop_succ=false;

        if (event.GetNumberOfFiles() > 0) {

            wxString* dropped = event.GetFiles();
            wxASSERT(dropped);

            wxBusyCursor busyCursor;
            wxWindowDisabler disabler;
            wxBusyInfo busyInfo(_("Adding file, wait please..."));

            wxString name;
            filno = event.GetNumberOfFiles();
            if(filno!=1)
            {
				throwout(_("Nur ein Dateiname bitte.\nEinfuegen verweigert!"),3);
				return;
			}
			if( wxDirExists( 	dropped[0]	))
            {
                throwout(_("Das ist ein Verzeichnisname!!\nNur Dateiname moeglich.\nDrop ignoriert!"),3);
                return;
            }
			name = dropped[0];
			if (!wxFileExists(name))
            {
				throwout(_("Datei existiert nicht\nEinfuegen verweigert!"),5);
				return;
			}

            wxTextCtrl* textCtrl = dynamic_cast<wxTextCtrl*>(event.GetEventObject());
            wxASSERT(textCtrl);
            textCtrl->Clear();
            textCtrl->SetValue(name);
            //drop_succ=true;
            fnam= name;
    // check if elliptic cipherfile
    if(!set_pars_from_file(fnam))
    {
        throwout(_("No plaintext header, NADA Capped?,\n Hint: Must select key manually."));
        //OnSelectPrivKeyFromStore(event);
        return;
    }
    separator=wxFileName::GetPathTerminators();
    wxFileName::SplitPath(fnam, &mypath, &myname,NULL);
    //check if private key present
    if(S_FIL) unlockinplace(sec_path + _("/ell_knamfile.knf"),&zugang);
    knfp=fopen((const char*)(sec_path + _("/ell_knamfile.knf")).mb_str(wxConvLocal), "r");
    count=0;
    do{
        lbl=fscanf(knfp, " id: %200s Name: %*s \n",buff1);
        count++;
        if(lbl!=1) break;
        s=wxString::FromUTF8(buff1);
        if(s==kid) {found=true; break;}
    }while(lbl == 1);
    fclose(knfp);
    if(S_FIL) lockinplace(sec_path + _("/ell_knamfile.knf"),&zugang);
    if(!found)
    {
        throwout(_("private_key_id: ")+ kid +_(" not in store! no autoload\n must guess and load decipher key later on!"));
        return;
    }
    //key should be present -> load private key
    if(!LoadPrivKey(kid)) throwout(_("could not load private key :-("));
    //set privkey fields
    pkyid_ctrl->SetValue(elky.id);
    fullnam_ctrl->SetValue(elky.fullnam);
    domnam_ctrl->SetValue(elky.domnam);
    pars_here=false;
    drop_succ=true;
    return;

        }
    }
/*********************************************************//*************************************************************/
void deciph_dialog::OnFileSelect(wxCommandEvent& event)
{
    wxString mypath,myname,separator,s,cry_d;
    longnumber rndnam;
    FILE *knfp;
    int count,lbl;
    bool found=false;
    char buff1[200];

    if(!checkarm()){Close();}
    if(cur_cry_path.IsEmpty())
    {
        cry_d = cry_path; //first call
    }
    else
    {
        cry_d = cur_cry_path;
    }
    fnam = wxFileSelector(_("Waehle einen Chiffretext"),cry_d);
    if ( !fnam.empty() )
    {
        fnam_ctrl->SetValue(fnam);
        cur_cry_path= ((wxFileName)fnam).GetPath(); //get new path and store into cur_doc_path
    }
    else
        {
            throwout(_("Leerer Dateiname, Abbruch!"),2);
            return;
        }
    // check if elliptic cipherfile
    if(!set_pars_from_file(fnam))
    {
        throwout(_("Kein Zugangsblock ?!, NADA Capped?,\n Hinweis: Waehle den priv. Schluessel manuell."));
        OnSelectPrivKeyFromStore(event);
        return;
    }
    separator=wxFileName::GetPathTerminators();
    wxFileName::SplitPath(fnam, &mypath, &myname,NULL);
    //check if private key present
    if(S_FIL) unlockinplace(sec_path + _("/ell_knamfile.knf"),&zugang);
    knfp=fopen((const char*)(sec_path + _("/ell_knamfile.knf")).mb_str(wxConvLocal), "r");
    count=0;
    do{
        lbl=fscanf(knfp, " id: %200s Name: %*s \n",buff1);
        count++;
        if(lbl!=1) break;
        s=wxString::FromUTF8(buff1);
        if(s==kid) {found=true; break;}
    }while(lbl == 1);
    fclose(knfp);
    if(S_FIL) lockinplace(sec_path + _("/ell_knamfile.knf"),&zugang);
    if(!found)
    {
        throwout(_("private_key_id: ")+ kid +_(" nicht auffindbar! kein autoload\nDu musst raten und den Schluessel spaeter laden!"));
        return;
    }
    //key should be present -> load private key
    if(!LoadPrivKey(kid)) throwout(_("Konnte priv. Schluessel nicht laden :-("));
    //set privkey fields
    pkyid_ctrl->SetValue(elky.id);
    fullnam_ctrl->SetValue(elky.fullnam);
    domnam_ctrl->SetValue(elky.domnam);
    pars_here=false;
    return;
}
/*************************************************************/
void deciph_dialog::OnSelectPrivKeyFromStore(wxCommandEvent& event)
{
    //int elfl;
    if(!checkarm()){Close();}

    ellky_load1 dialog(this);
    dialog.ShowModal();
    // ende Dialog
    //alles korrekt eintragen
	pkyid_ctrl->SetValue(elky.id);
    def_privkey=elky.id; //set as default
	fullnam_ctrl->SetValue(elky.fullnam);
	domnam_ctrl->SetValue(elky.domnam);

/*	//jetzt A ermitteln
    elky.A.copy_ep(&(gdom.d0));
    elky.A.mult_p_qj(&(elky.d),&(gdom));  */
    pars_here=false;
    return;
}
/*************************************************************/
void deciph_dialog::OnDoDecipher(wxCommandEvent& event)
{
    wxString mypath,myname,separator,snamh,snambody,metafile,plainfile,s3,uniqnam;
    longnumber key,ke_inv;
    char buff[1602],c;
    FILE *mfp;
    int lbl,fl1,i,stlen,elfl;
    bool heureka=false;
    bool deciph_only=false;
    bool rightsplice;
    int splicecnt=0;

    if(!checkarm()){Close();}

    deciph_only = CheckBox1->IsChecked();
    separator=wxFileName::GetPathTerminators();
    fnam=fnam_ctrl->GetLineText(0);
    //again get pars from file without check and key-actions
    //check for existence
    if(!wxFile::Exists(fnam))
    {
        throwout(_("Chiffredatei existiert nicht!\nKann nichts tun."),3);
        return;
    }
    if(!set_pars_from_file(fnam))
    {
        throwout(_("Ungueltige Chiffredatei\n keine Dechiffrierung!\nDu koenntest versuchen, manuell zu editieren/fixen,\nwenn nur ID oder Domain kaputt sind\n und der Rest ok aussieht."));
        return;
    }
    wxFileName::SplitPath(fnam, &mypath, &myname,NULL);
    //set helper file names
    longnumber hln1;
    hln1.makerandom(6);
    //convert to string;
    hln1.writehex(&uniqnam);
    snamh=_("sh_") + uniqnam;
    //1) recover cipherinfo and split
    snambody= _("sb_")+ uniqnam;
    if(algo == _("Fleas_1_8")) snambody+= _(".ciph_c3");
    else if(algo == _("Fleas_3")) snambody+= _(".ciph_f3");
    else if(algo == _("Fleas_4")) snambody+= _(".ciph_f4");
    else if(algo == _("Fleas_5")) snambody+= _(".ciph_f5");
    else if(algo == _("Fleas_x2")) snambody+= _(".ciph_x2");
    else if(algo == _("Fleas_x5")) snambody+= _(".ciph_x5");
    else if(algo == _("Fleas_o2")) snambody+= _(".ciph_o2");
    else if(algo == _("Fleas_o5")) snambody+= _(".ciph_o5");
    else if(algo == _("Fleas_l")) snambody+= _(".ciph_l");
    else if(algo == _("Fleas_ls")) snambody+= _(".ciph_ls");
    else if(algo == _("Fleas_l3")) snambody+= _(".ciph_l3");
	else if(algo == _("Fleas_lb")) snambody+= _(".ciph_lb");
	else if(algo == _("Fleas_lc")) snambody+= _(".ciph_lc");
	else if(algo == _("Fleas_ld")) snambody+= _(".ciph_ld");
    else if(algo == _("aes")) snambody+= _(".ciph_ae");
	else if(algo == _("F_cnt_1c")) snambody+= _(".ciph_1c");
	else if(algo == _("F_cnt_1d")) snambody+= _(".ciph_1d");
    else if(algo == _("F_cnt_1b")) snambody+= _(".ciph_1b");
	else if(algo == _("flight")) snambody+= _(".ciph_fl");
	else if(algo == _("flightx")) snambody+= _(".ciph_fx");
	else if(algo == _("threefish")) snambody+= _(".ciph_tf");
    else
    {
            throwout(_("unknown symm-algortihm specifier!\ntrying with F_cnt_1c.\n probably won't work.\n\nYou might try again with newer version of Academic Signature"));
            snambody+= _(".ciph_1c");
    }

    if(!splicefile(fnam, snamh, snambody, _("X:"))) //this splitting always hits
    {
        throwout(_("Splitting gescheitert\n keine Dechiffrierung."));
        return;
    }
    //header is no longer needed and can be discarded
    snamh= mypath+separator+snamh;
    wxRemoveFile(snamh);
    //check for matching id "kid = elky.kid"
    if(kid!= elky.id)
    {
        throwout(_("Achtung, Chiffren-Key id: ") + kid +_("\nund lokaler key: ")+elky.id+_("passen nicht\nwenn Dechiffrierung scheitert, versuchs mit anderem Schluessel!"));
    }
    //check for matching domain name
    if(domnam!= elky.domnam)
    {
        throwout(_("Achtung, Chiffren Domain Name: ") + domnam +_("\nund key Domain Name: ")+elky.domnam+_(" passen nicht\nwenns schiefgeht, probier andere Domain!"));
    }
   //check domain accessibility
    if(elky.domnam != gdom.name)
    {
        elfl=e_ls.getelp(&locell,elky.domnam);
        if(elfl<0)
        {
            throwout(_("Unbekannte key Domain\nkann nicht Dechiffrieren!\nverzweifelter Versuch mit dem deafult...!"),7);
            locell.copyell(&gdom);
        }
    }
    else locell.copyell(&gdom);

    //2) rebuild key, B mal inv q
    fl1=(elky.d).get_mod_inv_q(&ke_inv,&(locell.q));
    B.mult_p_qj(&ke_inv,&locell);
    key.copynum(&(B.x));
    key.shrinktofit();
    snambody=mypath + separator + _("sb_") + uniqnam +_(".ciph");
    if(!unlockinplace(snambody,&key,algo,1))
       {
           if(algo== _("Fleas_3")) snambody += _("_f3");
           if(algo== _("Fleas_1_8")) snambody += _("_c3");
           if(algo== _("Fleas_4")) snambody += _("_f4");
           if(algo== _("Fleas_5")) snambody += _("_f5");
           if(algo== _("Fleas_x2")) snambody += _("_x2");
           if(algo== _("Fleas_x5")) snambody += _("_x5");
           if(algo== _("Fleas_o2")) snambody += _("_o2");
           if(algo== _("Fleas_o5")) snambody += _("_o5");
           if(algo== _("Fleas_l")) snambody += _("_l");
           if(algo== _("Fleas_ls")) snambody += _("_ls");
           if(algo== _("Fleas_l3")) snambody += _("_l3");
           if(algo== _("Fleas_lb")) snambody += _("_lb");
           if(algo== _("Fleas_lc")) snambody += _("_lc");
           if(algo== _("Fleas_ld")) snambody += _("_ld");
           if(algo== _("aes")) snambody += _("_ae");
           if(algo== _("F_cnt_1c")) snambody += _("_1c");
           if(algo== _("F_cnt_1d")) snambody += _("_1d");
           if(algo== _("F_cnt_1b")) snambody += _("_1b");
           if(algo== _("flight")) snambody += _("_fl");
           if(algo== _("flightx")) snambody += _("_fx");
           if(algo== _("threefish")) snambody += _("_tf");
            wxRemoveFile(snambody);
           return;
       }
    //final splice recover filename
    s3= _("s3_")+uniqnam;
    rightsplice=false;
    while(!rightsplice)
    {
       metafile= _("metainfo")+uniqnam;
       if(!splicefile(snambody,metafile,s3,_("X:")))
       {
        throwout(_("abschliessendes Splitting gescheitert\n Dechiffrierung gescheitert"));
        return;
       }
       splicecnt++;
       //snambody is no longer needed and can e discarded
       wxRemoveFile(snambody);
    //s3 should be plainfile now or elsehave another X: and be prematurely spliced

    //3) recover origname
       metafile=mypath+separator+metafile;
       if(metafile.Len()>800)
       {
        throwout(_("Achtung! Dateiname sehr/zu lang\nschneide ab!\nBitte pruefe auf einen Angriffsversuch!"));
        metafile=metafile.Left(800);
       }
       strcpy(buff, (const char*)metafile.mb_str(wxConvLocal) );
       mfp=fopen(buff,"r");
       //discard 30 random bytes if splicecount <1;
       //fseek(mfp,29,SEEK_SET);
       if(splicecnt==1)
       {
         for(i=0;i<30;i++)
         {
              lbl=fscanf(mfp,"%c",&c);
         }
       }
       lbl=fscanf(mfp," fnam: %400s ",buff);
       if(lbl !=1)
       {
        for(i=10;i<100;i++)
        {
            fseek(mfp,i,SEEK_SET);
            lbl=fscanf(mfp," fnam: %400s ",buff);
            if(lbl==1)
            {
                throwout(_("found it!!"),3);
                heureka=true;
                rightsplice=true;
            }
            if(heureka) break;
         }
         if(!heureka)
         {
             fclose(mfp);
             throwout(_("Konnte Dateinamen noch nicht bestimmen :-0 "),1);
             if(splicecnt>10)
             {
                throwout(_("Konnte Dateinamen nicht bestimmen?!?\n Abbruch :-0 "));
                return;
             }
             else //reiterate
             {
                 //put spliced file-tail in place of original file
                 if(!wxRenameFile(mypath+separator+s3,snambody))
                 {
                     throwout(_("error renaming file 8_O"));
                     return;
                 }
             }
         }
       }
       else  //found directly
       {
           rightsplice=true;

       }
    }
    fclose(mfp);
    plainfile=wxString::FromUTF8(buff);
    //metafile is no longer needed and can e discarded
    wxRemoveFile(metafile);
    //4) rename original
    //check if fname already present and rename if appropriate
    if(wxFileExists(mypath+separator+plainfile))
       {
           throwout(_("Achtung, Datei mit Originalnamen existiert bereits\nwerde die umbenennen zu *_old und fortfahren"));
           if(wxFileExists(mypath+separator+plainfile+_("_old"))) wxRemoveFile(mypath+separator+plainfile+_("_old"));
           wxRenameFile(mypath+separator+plainfile, mypath+separator+plainfile+_("_old"));
       }
    //clean place for file now...
    if(wxRenameFile(mypath+separator+s3, mypath+separator+plainfile))
      throwout(_("Klardatei erfolgreich hergestellt"),2);
    else
      throwout(_("Sorry, Umbenennung gescheitert"));
    //check if ending is .sf, then suggest splitting  and remove original
    if((plainfile.Right(3) != _(".sf"))||(deciph_only)) return;  //is not compound or should not splice-> return
    //is compound: attempt splitting
    if(verbose) throwout(_("Klardatei ist Compounddatei aus Signature+Document\nwerde Trennung versuchen."),2);
    stlen=plainfile.length();
    if( !splicefile(mypath+separator+plainfile,(plainfile.Left(stlen-3))+_(".ecsg") , (plainfile.Left(stlen-3)), _("split_here:")))
           {
             if(verbose) throwout(_("Sorry, konnte keine Trennung in Signatur und Datei vornehmen"));
           }
    else
    {
        throwout(_("Trennung erfolgreich!\nDu kannst jetzt manuell die Echtheit der Signatur pruefen\naus Sicherheitsgruenden kein Automatismus:\nDu musst den vermuteten Signierer mit Sorgfalt manuell waehlen!!"));
        wxRemoveFile(mypath+separator+plainfile);
    }
    def_privkey=elky.id; //set as default
    return;
}
/*************************************************************/
void deciph_dialog::OnDoDecipherNew(wxCommandEvent& event)
{
    wxString mypath,myname,separator,snamh,snambody,metafile,plainfile,s3,uniqnam, decbody,fnamc,nadakeyword,fnam_dec,endm;
    longnumber key,ke_inv;
    char buff[1602],c,*cnam,*pnam;
    FILE *mfp;
    int lbl,fl1,i,stlen,elfl,res,answer;
    bool heureka=false;
    bool deciph_only=false;
    bool rightsplice,is_cbc=true;
    int splicecnt=0;
    ulong32 payld_begin;
    int fr=4, kr=2, blsiz=65; //defaults for 1_8 and 3
    e_p cap_point;
    bool intr_succ=false, extr_succ=false;
    bool decapresult, islegacy=false;

    if(!checkarm()){Close();}

    deciph_only = CheckBox1->IsChecked();
    separator=wxFileName::GetPathTerminators();
    fnam=fnam_ctrl->GetLineText(0);
    //again get pars from file without check and key-actions
    //check for existence
    if(!wxFile::Exists(fnam))
    {
        throwout(_("Chiffredatei existiert nicht!\nAbbruch."),3);
        return;
    }
    if(!set_pars_from_file(fnam))  //can't access fnam info
    {
       if(elky.domnam != gdom.name)
       {
        elfl=e_ls.getelp(&locell,elky.domnam);
        if(elfl<0)
        {
            throwout(_("Unbekannte Schluesseldomain\nkann nicht dechiffr.!\nletzter Versuch mit default.."),7);
            locell.copyell(&gdom);
        }
       }
       else locell.copyell(&gdom);
       //now domain is in locell
       //load counter
       cap_point.copy_ep(&(locell.d0));
       cap_point.mult_p_qj(&(elky.d),&locell,false);
       fnam_dec=fnam+_("decap");
       nadakeyword=_("intrinsic");
       endm=_("X:");
       if(Make_DeCapped(&nadakeyword, &fnam, &fnam_dec, &endm, &cap_point,&dedhed,false,true)) //success
       {
           intr_succ=true;
           throwout(_("Hat scheinbar intrinsiche NADA-Cap :-)"),2);
           if(!set_pars_from_file(fnam_dec)) //failed to read
           {
               intr_succ=false;
           }

           if(!wxRemoveFile(fnam_dec))
           {
             throwout(_("Fehler, konnte decapped Dateischnipsel nicht entfernen"),5);
           }
       }
       i=0;
       while((!intr_succ)&&(i<20)&&(!extr_succ))//try extrinsic and ask for legacy KDF
       {
           Cap_Questn extrinsicDlg (this,_("Chiffredatei koennte NADA-Cap tragen, gib das NADA-Cap Passwort!"),&nadakeyword, &islegacy);
           res=extrinsicDlg.ShowModal();
           if(res==0)//aborted
           {
               throwout(_("Abbruch!"),3);
               return;
           }
           else
           {
                if(Make_DeCapped(&nadakeyword, &fnam, &fnam_dec, &endm, &cap_point,&dedhed,false,true,islegacy)) //success
                {
                    extr_succ=true;
                    if(!set_pars_from_file(fnam_dec)) //failed to read
                      {
                          extr_succ=false;
                      }
         //if key IDs dont match ask for update order
                   if(kid!= elky.id)
                     {
                        AskDialog d1(this,_("Widerspruechl. IDs 8-O Versuche es mit dem in der Chiffre angegebenen Schluessel?"));
                        answer=d1.ShowModal();
                        if((answer==1)&&(extr_succ))
                        {
                          if(!LoadPrivKey(kid))
                          {
                              throwout(_("Konnte den behaupteten private\nkey im Repository nicht finden.\nversuche den letzten validen. Oh Oh!"),4);
                          }
                          //else{ throwout(_("Cipher claimed private key found in repository :-)"),1);}
                        }
                     }
                   if(!wxRemoveFile(fnam_dec))
                   {
                     throwout(_("Fehler, konnte decapped Dateischnipsel nicht entfernen"),5);
                   }
                }
                if(extr_succ) throwout(_("DECAP erfolgreich!"),1);
                else
                {
                   if(i<3) throwout(_("Versuch gescheitert!\nNeuer Versuch ?"),3);
                   else throwout(_("Versuch gescheitert!\nNeuer Versuch ?"),1);
                }
           }
       }
       //20 attempts
       if(i==20)
       {
          throwout(_("Final abgebrochen!"),3);
          return;
       }
    }
    pars_here=true;

    if(algo ==_("Fleas_4")) {fr=5;kr=3;blsiz=512;}
    else if(algo ==_("Fleas_5")) {fr=5;kr=3;blsiz=512;}
    else if(algo ==_("Fleas_x2")) {fr=5;kr=3;blsiz=512;}
    else if(algo ==_("Fleas_x5")) {fr=5;kr=3;blsiz=512;}
    else if(algo ==_("Fleas_o2")) {fr=4;kr=2;blsiz=512;} //new set for supersecure version
    else if(algo ==_("Fleas_o5")) {fr=4;kr=2;blsiz=512;} //new set for supersecure version
    else if(algo ==_("Fleas_l")) {fr=4;kr=2;blsiz=512;} //new set for supersecure version
    else if(algo ==_("Fleas_ls")) {fr=4;kr=2;blsiz=480;} //new set for supersecure version
    else if(algo ==_("Fleas_l3")) {fr=4;kr=3;blsiz=480;} //new set for supersecure version
    else if(algo ==_("Fleas_lb")) {fr=4;kr=3;blsiz=480;} //new set for supersecure version
    else if(algo ==_("Fleas_lc")) {fr=4;kr=3;blsiz=480;} //new set for supersecure version
    else if(algo ==_("Fleas_ld")) {fr=4;kr=3;blsiz=480;}
    else if(algo ==_("aes")) {fr=0;kr=1;blsiz=16;} //new set aes
    else if(algo ==_("F_cnt_1c")) {fr=4;kr=3;blsiz=480;is_cbc=false;} //new set for counter mode version
    else if(algo ==_("F_cnt_1d")) {fr=4;kr=3;blsiz=480;is_cbc=false;} //new set for counter mode version
    else if(algo ==_("F_cnt_1b")) {fr=4;kr=3;blsiz=480;is_cbc=false;} //new set for counter mode version
    else if(algo ==_("flight")) {fr=2;kr=1;blsiz=480;is_cbc=false;} //new set for counter mode version
    else if(algo ==_("flightx")) {fr=2;kr=1;blsiz=480;is_cbc=false;} //new set for counter mode version
    else if(algo ==_("threefish")) {fr=0;kr=0;blsiz=128;is_cbc=false;} //new set for counter mode version
    else if(algo ==_("chimera")) {fr=2;kr=1;blsiz=512;is_cbc=false;} //new set for counter mode version
    else
    {
        throwout(_("unknown algorithm, aborting!"),3);
        return;
    }
        //branch if cbc-mode
    if((is_cbc)&&(extr_succ||intr_succ)) return( DoDecipherCBC(fnam)); //cbc-mode with NADA cap
    if(is_cbc) return(OnDoDecipher(event)); //plain cbc
    //else go on with one pass- countermode deciphering
    wxFileName::SplitPath(fnam, &mypath, &myname,NULL);
    //set helper file names
    longnumber hln1;

    //determine deadhead if not
    if((!intr_succ)&&(!extr_succ))
    {
       if(!file_pos_past( fnam, _("X:"),&payld_begin))
       {
          throwout(_("Endmarke nicht gefunden!"),3);
       }
    }
    else{  payld_begin= dedhed;}
    if(kid!= elky.id)
    {
        throwout(_("Achtung, Chiffren-Key id: ") + kid +_("\nund lokaler key: ")+elky.id+_(" passen nicht\nwenn keine Dechiffrierung, versuchs vlcht. mit einem anderen key?"));
    }
    //check for matching domain name
    if(domnam!= elky.domnam)
    {
        throwout(_("Achtung, Chiffren-domain Name: ") + domnam +_("\nund key Domain Name: ")+elky.domnam+_(" passen nicht!"));
    }
   //check domain accessibility
    if(elky.domnam != gdom.name)
    {
        elfl=e_ls.getelp(&locell,elky.domnam);
        if(elfl<0)
        {
            throwout(_("unbekannte key Domain\nkeine Dechiffrierung!\njetzt verzweifelter Versuch mit dem Default!"),7);
            locell.copyell(&gdom);
        }
    }
    else locell.copyell(&gdom);

    //2) rebuild key, B mal inv q
    fl1=(elky.d).get_mod_inv_q(&ke_inv,&(locell.q));
    B.mult_p_qj(&ke_inv,&locell);
    key.copynum(&(B.x));
    key.shrinktofit();
    key.setsize(true);

    decbody=_("");
    if(!dec_fil_4ecc(payld_begin,fnam,&decbody,(char *) key.ad, key.size,fr,kr,blsiz,1,algo,1))
    {
        throwout(_("Konnte nicht dechiffrieren, Abbruch!"),3);
        return;
    }

    //check if ending is .sf, then suggest splitting  and remove original
    if((decbody.Right(3) != _(".sf"))||(deciph_only))
    {
        throwout(_("erfolgreich dechiffriert.\nKlardatei liegt im Verzeichnis\n des Chiffretexts."),5);
                return;  //is not compound or should not splice-> return
    }
    //is compound: attempt splitting
    s3=((wxFileName) decbody).GetName();
    throwout(_("Klardatei ist Compound aus Signatur und Dokument\nwerde Trennung versuchen."),2);
    stlen=decbody.length();
    if( !splicefile(decbody,(s3.Left(stlen-3))+_(".ecsg") , (s3.Left(stlen-3)), _("end_sig:"), _("split_here:")))
    {
        //may be legacy cipher? try again
        if( !splicefile(decbody,(s3.Left(stlen-3))+_(".ecsg") , (s3.Left(stlen-3)), _("split_here:")))
            throwout(_("sorry, konnte Compounddatei nicht splitten\n Datei wurde vielleicht im Transit korrumpiert?"));
        else
        {
           throwout(_("Legacy Trennung erfolgreich!\nDu kannst jetzt manuell die Echtheit der Signatur pruefen\naus Sicherheitsgruenden kein Automatismus:\nDu musst den vermuteten Signierer mit Sorgfalt manuell waehlen!!"));
           wxRemoveFile(decbody);
        }
    }

    else
    {
        throwout(_("Trennung erfolgreich!\nDu kannst jetzt manuell die Echtheit der Signatur pruefen\naus Sicherheitsgruenden kein Automatismus:\nDu musst den vermuteten Signierer mit Sorgfalt manuell waehlen!!"));
        wxRemoveFile(decbody);
    }
    def_privkey=elky.id; //set as default
    return;
}
/*************************************************************/
/*************************************************************/
void deciph_dialog::DoDecipherCBC( wxString fnam)
//dedhead, B, key areclass variables
{
    /***wxString mypath,myname,,snamh;
    longnumber key,



     ****/
    bool deciph_only=false;
    wxString separator,mypath,myname,uniqnam,snambody,s3,metafile,plainfile,extns,mymssg;
    int elfl,i,lbl,stlen, fl1, answer;
    bool rightsplice;
    int splicecnt=0;
    char buff[1602],c;
    FILE *mfp;
    bool heureka=false;
    longnumber ke_inv;

    deciph_only = CheckBox1->IsChecked();
    separator=wxFileName::GetPathTerminators();
    //again get pars from file without check and key-actions
    //check for existence
    if(!wxFile::Exists(fnam))
    {
        throwout(_("Chiffredatei existiert nicht!\nAbbruch."),3);
        return;
    }
    //pars are presumed to be set
    if(!pars_here)
    {
        throwout(_("Error, cannot call DoDecipherCBC \nwhen Pars are not set!"));
        return;
    }
    wxFileName::SplitPath(fnam, &mypath, &myname,NULL);
    //set helper file names obsolete??
    longnumber hln1;
    hln1.makerandom(6);
    //convert to string;
    hln1.writehex(&uniqnam);

    //check for matching id "kid = elky.kid"
    if(kid!= elky.id)
    {
        mymssg=_("Achtung, cipher-Key id: ") + kid +_("\nund lokaler key: ")+elky.id+_(" passen nicht\nversuche es trotzdem!");
        throwout(mymssg);
        //if dont match ask for update order
        AskDialog d1(this,_("Widerspruechliche IDs 8-O Versuche, den in der Chiffre angegebenen Key zu holen?"));
        answer=d1.ShowModal();
        if(answer==1)
        {
            if(!LoadPrivKey(kid))
            {
                throwout(_("Konnte den in der Chiffre angegebenen \nSchluessel nicht finden\nversuchs mit dem letzten validen. Oh Oh!"),4);
            }
            //else{ throwout(_("Cipher claimed private key found in repository :-)"),1);}
        }
    }
    //check for matching domain name
    if(domnam!= elky.domnam)
    {
        throwout(_("Achtung, Chiffren-Domain Name: ") + domnam +_("\nund key Domain Name: ")+elky.domnam+_(" passen nicht\nkoennte schiefgehen...!"));
    }
   //check domain accessibility
    if(elky.domnam != gdom.name)
    {
        elfl=e_ls.getelp(&locell,elky.domnam);
        if(elfl<0)
        {
            throwout(_("unbekannte key-Domain\nkeine Dechiffrierung!\nverzweifelter Versuch mit der Default Domain!"),7);
            locell.copyell(&gdom);
        }
    }
    else locell.copyell(&gdom);


    //2) rebuild key, B mal inv q
    fl1=(elky.d).get_mod_inv_q(&ke_inv,&(locell.q));
    B.mult_p_qj(&ke_inv,&locell);
    skey.copynum(&(B.x));
    skey.shrinktofit();
    snambody=mypath + separator + _("sb_") + uniqnam;
   // if(!unlockinplace(snambody,&skey,algo,1))
      {
           if(algo== _("Fleas_3")) extns= _("_f3");
           else if(algo== _("Fleas_1_8")) extns= _("_c3");
           else if(algo== _("Fleas_4")) extns= _("_f4");
           else if(algo== _("Fleas_5")) extns= _("_f5");
           else if(algo== _("Fleas_x2")) extns= _("_x2");
           else if(algo== _("Fleas_x5")) extns= _("_x5");
           else if(algo== _("Fleas_o2")) extns= _("_o2");
           else if(algo== _("Fleas_o5")) extns= _("_o5");
           else if(algo== _("Fleas_l")) extns= _("_l");
           else if(algo== _("Fleas_ls")) extns= _("_ls");
           else if(algo== _("Fleas_l3")) extns= _("_l3");
           else if(algo== _("Fleas_lb")) extns= _("_lb");
           else if(algo== _("Fleas_lc")) extns= _("_lc");
           else if(algo== _("Fleas_ld")) extns= _("_ld");
           else if(algo== _("aes")) extns= _("_ae");
           else if(algo== _("F_cnt_1c")) extns= _("_1c");
           else if(algo== _("F_cnt_1d")) extns= _("_1d");
           else if(algo== _("F_cnt_1b")) extns= _("_1b");
           else if(algo== _("flight")) extns= _("_fl");
           else if(algo== _("flightx")) extns= _("_fx");
           else if(algo== _("threefish")) extns= _("_tf");

           //return;
       }
        //remove headerfile via fronttrunc;
      if(!maketrunc_head(fnam, snambody+extns, dedhed))
       {
           throwout(_("Fehler, konnte nicht den header kappen."),5);
           return;
       }

   // wxRenameFile(fnam,snambody);
    if(!unlockinplace(snambody,&skey,algo,1))
       {
           if(algo== _("Fleas_3")) snambody += _("_f3");
           if(algo== _("Fleas_1_8")) snambody += _("_c3");
           if(algo== _("Fleas_4")) snambody += _("_f4");
           if(algo== _("Fleas_5")) snambody += _("_f5");
           if(algo== _("Fleas_x2")) snambody += _("_x2");
           if(algo== _("Fleas_x5")) snambody += _("_x5");
           if(algo== _("Fleas_o2")) snambody += _("_o2");
           if(algo== _("Fleas_o5")) snambody += _("_o5");
           if(algo== _("Fleas_l")) snambody += _("_l");
           if(algo== _("Fleas_ls")) snambody += _("_ls");
           if(algo== _("Fleas_l3")) snambody += _("_l3");
           if(algo== _("Fleas_lb")) snambody += _("_lb");
           if(algo== _("Fleas_lc")) snambody += _("_lc");
           if(algo== _("Fleas_ld")) snambody += _("_ld");
           if(algo== _("aes")) snambody += _("_ae");
           if(algo== _("F_cnt_1c")) snambody += _("_1c");
           if(algo== _("F_cnt_1d")) snambody += _("_1d");
           if(algo== _("F_cnt_1b")) snambody += _("_1b");
           if(algo== _("flight")) snambody += _("_fl");
           if(algo== _("flightx")) snambody += _("_fx");
           if(algo== _("threefish")) snambody += _("_tf");
            wxRemoveFile(snambody);
           return;
       }
    //final splice recover filename
    s3= _("s3_")+uniqnam;
    rightsplice=false;
    while(!rightsplice)
    {
       metafile= _("metainfo")+uniqnam;
       if(!splicefile(snambody,metafile,s3,_("X:")))
       {
        throwout(_("Finale Trennung gescheitert\n Dechiffrierung gescheitert"));
        return;
       }
       splicecnt++;
       //snambody is no longer needed and can e discarded
       wxRemoveFile(snambody);
    //s3 should be plainfile now or elsehave another X: and be prematurely spliced

    //3) recover origname
       metafile=mypath+separator+metafile;
       if(metafile.Len()>800)
       {
        throwout(_("Achtung! Dateiname excessiv lang\n wird gekappt!\nBitte pruefe auf einen Angriffsversuch!"));
        metafile=metafile.Left(800);
       }
       strcpy(buff, (const char*)metafile.mb_str(wxConvLocal) );
       mfp=fopen(buff,"r");
       //discard 30 random bytes if splicecount <1;
       //fseek(mfp,29,SEEK_SET);
       if(splicecnt==1)
       {
         for(i=0;i<30;i++)
         {
              lbl=fscanf(mfp,"%c",&c);
         }
       }
       lbl=fscanf(mfp," fnam: %400s ",buff);
       if(lbl !=1)
       {
        for(i=10;i<100;i++)
        {
            fseek(mfp,i,SEEK_SET);
            lbl=fscanf(mfp," fnam: %400s ",buff);
            if(lbl==1)
            {
                throwout(_("found it!!"),3);
                heureka=true;
                rightsplice=true;
            }
            if(heureka) break;
         }
         if(!heureka)
         {
             fclose(mfp);
             throwout(_("Dateiname konnte noch nicht bestimmt werden :-0 "),1);
             if(splicecnt>10)
             {
                throwout(_("Dateiname konnte nicht bestimmt werden?!?\n Abbruch :-0 "));
                return;
             }
             else //reiterate
             {
                 //put spliced file-tail in place of original file
                 if(!wxRenameFile(mypath+separator+s3,snambody))
                 {
                     throwout(_("Fehler, Datei konnte nicht umbenannt werden 8_O"));
                     return;
                 }
             }
         }
       }
       else  //found directly
       {
           rightsplice=true;

       }
    }
    fclose(mfp);
    plainfile=wxString::FromUTF8(buff);
    //metafile is no longer needed and can e discarded
    wxRemoveFile(metafile);
    //4) rename original
    //check if fname already present and rename if appropriate
    if(wxFileExists(mypath+separator+plainfile))
       {
           throwout(_("Achtung, Datei mit dem Originalmanem ist bereits vorhanden\nwird in *_old umbenannt, fahre fort."));
           if(wxFileExists(mypath+separator+plainfile+_("_old"))) wxRemoveFile(mypath+separator+plainfile+_("_old"));
           wxRenameFile(mypath+separator+plainfile, mypath+separator+plainfile+_("_old"));
       }
    //clean place for file now...
    if(wxRenameFile(mypath+separator+s3, mypath+separator+plainfile))
      throwout(_("Klardatei erfolgreich wiederhergestellt :-)"),2);
    else
      throwout(_("Sorry, umbenennung gescheitert"));
    //check if ending is .sf, then suggest splitting  and remove original
    if((plainfile.Right(3) != _(".sf"))||(deciph_only)) return;  //is not compound or should not splice-> return
    //is compound: attempt splitting
    throwout(_("Klardatei ist Compound aus Signatur und Dokumentdatei\nwerde Trennung versuchen."),2);
    stlen=plainfile.length();
    if( !splicefile(mypath+separator+plainfile,(plainfile.Left(stlen-3))+_(".ecsg") , (plainfile.Left(stlen-3)), _("end_sig:"), _("split_here:")))
        //may be legacy cipher? try again
        if( !splicefile(mypath+separator+plainfile,(plainfile.Left(stlen-3))+_(".ecsg") , (plainfile.Left(stlen-3)), _("split_here:")))
            throwout(_("sorry, konnte Compounddatei nicht splitten\n Datei wurde vielleicht im Transit korrumpiert?"));
        else
        {
           throwout(_("Legacy Trennung erfolgreich!\nDu kannst jetzt manuell die Echtheit der Signatur pruefen\naus Sicherheitsgruenden kein Automatismus:\nDu musst den vermuteten Signierer mit Sorgfalt manuell waehlen!!"));
           wxRemoveFile(mypath+separator+plainfile);
        }
    else
    {
        throwout(_("Trennung erfolgreich!\nDu kannst jetzt die Gueltigkeit der Signatur manuell pruefen\nkein automatischer Check(Sicherheit!):\nDu must mit Sorgfalt den unterstellten Signierschluessel aussuchen!!"));
        wxRemoveFile(mypath+separator+plainfile);
    }
    def_privkey=elky.id; //set as default
    return;
}
/*************************************************************/
