/*
 *   Copyright (C) 2011-2016, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#include "changPasphr.h"
#include "helpersxx.h"
#include "globals.h"
#include "AskDialog.h"

//(*InternalHeaders(changPasphr)
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/font.h>
//*)

//(*IdInit(changPasphr)
const long changPasphr::ID_BUTTON1 = wxNewId();
const long changPasphr::ID_STATICTEXT1 = wxNewId();
const long changPasphr::ID_TEXTCTRL1 = wxNewId();
const long changPasphr::ID_STATICTEXT2 = wxNewId();
const long changPasphr::ID_TEXTCTRL2 = wxNewId();
const long changPasphr::ID_STATICTEXT3 = wxNewId();
const long changPasphr::ID_TEXTCTRL3 = wxNewId();
const long changPasphr::ID_BUTTON2 = wxNewId();
const long changPasphr::ID_BUTTON3 = wxNewId();
const long changPasphr::ID_STATICTEXT5 = wxNewId();
const long changPasphr::ID_TEXTCTRL5 = wxNewId();
const long changPasphr::ID_STATICTEXT4 = wxNewId();
const long changPasphr::ID_SPINCTRL1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(changPasphr,wxDialog)
	//(*EventTable(changPasphr)
	//*)
END_EVENT_TABLE()

changPasphr::changPasphr(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
    wxString s_str;

    if(!checkarm()){Close();}

	//(*Initialize(changPasphr)
	wxFlexGridSizer* FlexGridSizer1;

	Create(parent, wxID_ANY, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("wxID_ANY"));
	SetBackgroundColour(wxColour(221,183,183));
	FlexGridSizer1 = new wxFlexGridSizer(0, 2, 0, 0);
	Button1 = new wxButton(this, ID_BUTTON1, _("Abbrechen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	Button1->SetBackgroundColour(wxColour(249,200,200));
	wxFont Button1Font(11,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button1->SetFont(Button1Font);
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Alte Passphrase eingeben:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	wxFont StaticText1Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText1->SetFont(StaticText1Font);
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	oldpw_ctrl = new wxTextCtrl(this, ID_TEXTCTRL1, wxEmptyString, wxDefaultPosition, wxSize(422,22), wxTE_PASSWORD, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	oldpw_ctrl->SetFocus();
	wxFont oldpw_ctrlFont(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	oldpw_ctrl->SetFont(oldpw_ctrlFont);
	FlexGridSizer1->Add(oldpw_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText2 = new wxStaticText(this, ID_STATICTEXT2, _("Neue Passphrase:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT2"));
	wxFont StaticText2Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText2->SetFont(StaticText2Font);
	FlexGridSizer1->Add(StaticText2, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	new_pw_ctrl1 = new wxTextCtrl(this, ID_TEXTCTRL2, wxEmptyString, wxDefaultPosition, wxSize(422,22), wxTE_PASSWORD, wxDefaultValidator, _T("ID_TEXTCTRL2"));
	wxFont new_pw_ctrl1Font(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	new_pw_ctrl1->SetFont(new_pw_ctrl1Font);
	FlexGridSizer1->Add(new_pw_ctrl1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText3 = new wxStaticText(this, ID_STATICTEXT3, _("Wiederholen:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT3"));
	wxFont StaticText3Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText3->SetFont(StaticText3Font);
	FlexGridSizer1->Add(StaticText3, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	new_pw_ctrl2 = new wxTextCtrl(this, ID_TEXTCTRL3, wxEmptyString, wxDefaultPosition, wxSize(422,22), wxTE_PASSWORD, wxDefaultValidator, _T("ID_TEXTCTRL3"));
	wxFont new_pw_ctrl2Font(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	new_pw_ctrl2->SetFont(new_pw_ctrl2Font);
	FlexGridSizer1->Add(new_pw_ctrl2, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button2 = new wxButton(this, ID_BUTTON2, _("uebernehmen"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	Button2->SetBackgroundColour(wxColour(121,245,165));
	wxFont Button2Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button2->SetFont(Button2Font);
	FlexGridSizer1->Add(Button2, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button3 = new wxButton(this, ID_BUTTON3, _("Salt aendern"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON3"));
	wxFont Button3Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button3->SetFont(Button3Font);
	FlexGridSizer1->Add(Button3, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText5 = new wxStaticText(this, ID_STATICTEXT5, _("Salt:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT5"));
	wxFont StaticText5Font(8,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText5->SetFont(StaticText5Font);
	FlexGridSizer1->Add(StaticText5, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	salt_ctrl = new wxTextCtrl(this, ID_TEXTCTRL5, wxEmptyString, wxDefaultPosition, wxSize(470,22), 0, wxDefaultValidator, _T("ID_TEXTCTRL5"));
	salt_ctrl->Disable();
	wxFont salt_ctrlFont(7,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	salt_ctrl->SetFont(salt_ctrlFont);
	FlexGridSizer1->Add(salt_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_TOP, 5);
	StaticText4 = new wxStaticText(this, ID_STATICTEXT4, _("Stretch Faktor:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT4"));
	wxFont StaticText4Font(10,wxFONTFAMILY_SWISS,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText4->SetFont(StaticText4Font);
	FlexGridSizer1->Add(StaticText4, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	StrechtCtrl1 = new wxSpinCtrl(this, ID_SPINCTRL1, _T("1"), wxDefaultPosition, wxDefaultSize, 0, 1, 100, 1, _T("ID_SPINCTRL1"));
	StrechtCtrl1->SetValue(_T("1"));
	FlexGridSizer1->Add(StrechtCtrl1, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	SetSizer(FlexGridSizer1);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&changPasphr::OnCancel);
	Connect(ID_TEXTCTRL3,wxEVT_COMMAND_TEXT_ENTER,(wxObjectEventFunction)&changPasphr::OnChange);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&changPasphr::OnChange);
	Connect(ID_BUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&changPasphr::OnChangeSalt);
	//*)
	salt.writehex(&s_str);
	salt_ctrl->SetValue(s_str);
	StrechtCtrl1->SetValue(stretch);
}

changPasphr::~changPasphr()
{
	//(*Destroy(changPasphr)
	//*)
}

/************************************************************/
void changPasphr::OnCancel(wxCommandEvent& event)
{
       EndModal(0);//caller doesn't recall
}
/*******************************************************************/
void changPasphr::OnChange(wxCommandEvent& event)
{
    wxString pw1,pw2,olpw,ns_str;
    longnumber hky,olky,newky,newsalt;
    int res, nstretch;
    FILE *fp;

    //check if identical entries -> if not message and return
    pw1=new_pw_ctrl1->GetLineText(0);
    pw2=new_pw_ctrl2->GetLineText(0);
    olpw=oldpw_ctrl->GetLineText(0);
    ns_str=salt_ctrl->GetLineText(0);
    nstretch=StrechtCtrl1->GetValue();
    // check for empty passwd
    if(pw1 ==_(""))
    {
        AskDialog dialog(this,_("Willst Du wirklich ein leeres Passwort??\nDas waere sehr unueblich!"));
        res=dialog.ShowModal();
        if(res == 0)
        {
            throwout(_("Abbruch, versuchen Sies nochmal"),2);
            return;
        }
        else
        {
            throwout(_("Nun denn, so sei es dann eben.....\nBeschweren Sie sich aber nicht spaeter bei mir!"));
        }
    }
    if(pw1 != pw2)
    {
        throwout(_("Die beiden neuen Passworteingaben sind verschieden"));
        return;
    }
    //rework with old salt
    if(!kyprep(&hky, &olpw, &salt, &stretch_ell, stretch,ss_klen ))  //make ky
    {
        throwout(_("Fatal error in kyprep!!"));
        return;
    }

    //do round
    hky.randomize(5,NULL,32,0,0); //runden, mateadresse, outlength, cagesize, warnflag
    hky.setsize(true);
    hky.shrinktofit();
    //save to "paphr_hash.flea"
    olky.lonu_from_file(sec_path + _("/paphr_hash.flea"));
    olky.setsize(true);
    olky.shrinktofit();
    //recode all files from "default to new key
    if(olky.compare(&hky) != 0)
    {
        throwout(_("Aktuelles Passwort war falsch!\n keine Aenderung"));
        return;
    }
    //alle files umcodieren
    //zuerst neues salt setzen
    if(!newsalt.storhex(&ns_str))
    {
        throwout(_("Fataler Fehler!\nNeuer Salt konnte nicht korrekt gelesen werden"));
        return;
    }
    if(!kyprep(&newky, &pw1, &newsalt, &stretch_ell, nstretch,ss_klen ))  //make ky
    {
        throwout(_("Fatal error in kyprep!!"));
        return;
    }

    if(! recode_all(&newky,&zugang))
    {
        throwout(_("Fehler bei der Recodierung! \n keine Aenderung von PW und Coding"));
        EndModal(0);
        return;
    }
    if( (salt.compare(&newsalt) !=0 )||(nstretch != stretch) ) //update saltfile when salt or stretch has been changed
    {
        //updating necessary
        salt.copynum(&newsalt);
        fp=fopen((const char*)(sec_path + _("/salt.txt")).mb_str(wxConvLocal), "w");
        fprintf(fp," salt:%s \n",(const char*)(ns_str.mb_str(wxConvUTF8)));
        fprintf(fp," stretchfactor: %i \n",nstretch);
        fclose(fp);
        stretch = nstretch;  //set new stretchfactor

        fp=fopen((const char*)(sec_path + _("/old_salts.txt")).mb_str(wxConvLocal), "a");
        fprintf(fp,"\n salt:%s \n",(const char*)(ns_str.mb_str(wxConvUTF8)));
        fclose(fp);

    }
    zugang.copynum(&newky);
    newky.randomize(5,NULL,32,0,0); //runden, mateadresse, outlength, cagesize, warnflag
    newky.setsize(true);
    newky.shrinktofit();
    newky.lonu_to_file(sec_path + _("/paphr_hash.flea"));

    EndModal(1);
    return;
}
/***********************************************************************/
void changPasphr::OnChangeSalt(wxCommandEvent& event)
{
    longnumber newsalt;
    wxString ns_str;

    newsalt.makerandom(32);
    newsalt.writehex(&ns_str);
    salt_ctrl->SetValue(ns_str);
    return;
}
/************************************************************************/
