/*
 *   Copyright (C) 2011-2012, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#include <wx/process.h>
#include <wx/string.h>


#include <wx/listimpl.cpp>
#include <wx/txtstrm.h>
#include <wx/filename.h>


#include "gpg_wrap.h"
#include "gnupg_globals.h"
#include "helpersxx.h"
#include "globals.h"
#include "pw_request.h"


wxProcess *m_gpgProcess; //my add

		wxArrayString kyid;
		wxArrayString kyname;
		wxArrayString kytype;
		wxArrayString kylength;
		wxArrayString kylabel;
		wxArrayString kyfprint;
		wxString privkey;
		int pk_sel=0;


        wxArrayString pb_kyid;
        wxArrayString pb_kyname;
        wxArrayString pb_kytype;
        wxArrayString pb_kylength;
        wxArrayString pb_kylabel;
        wxString pubkey;

        int pubk_sel=0;


        bool logging = false;  //set true to obtain logfile of gnupg outputs
/***************************************************/
bool find_in_array(wxString key, wxArrayString liste)
{
    int i,count;

    count=liste.GetCount();
    if( (count<1)||(key.IsEmpty()) ) return false;

    for(i=0;i<count;i++)
    {
        if( liste[i].Contains(key) ) return true;
    }
    return false;
}
/***************************************************/
bool writelog(wxString chann, wxString msg)
//bare log_safety
{
    FILE *fp;

    if(!logging) return false;
    if(msg==_("")) return false;
    fp= fopen("gpg.log", "a");
    fprintf(fp,"\n**%s****",(const char *)(chann.mb_str(wxConvUTF8)));
    fprintf(fp,"\n %s",(const char *)(msg.mb_str(wxConvUTF8)) );
    fclose(fp);
    return true;
}
/***************************************************/
bool writelog(wxString chann, wxArrayString msgs)
//bare log_safety
{
    FILE *fp;
    int i,count;

    if(!logging) return false;
    count=msgs.GetCount();
    if(count<1) return false;
    fp= fopen("gpg.log", "a");
    fprintf(fp,"\n**%s****",(const char *)(chann.mb_str(wxConvUTF8)));
    for(i=0;i<count;i++) fprintf(fp,"\n %s ",(const char *)(msgs[i].mb_str(wxConvUTF8)) );
    //fprintf(fp,"\n--\n");
    fclose(fp);
    return true;
}
/***************************************************//****************************************************/
wxString _OpenGPGProcess(const wxString cmdLine, wxOutputStream * &in, wxInputStream * &out, wxInputStream * &err)
{
   // wxString path = m_gpgPath; my blank

/**
#ifdef __WXMSW__
    if (m_gpgPath[m_gpgPath.Len()-1] != wxT('/')) {
        path.Append(wxT('/'));
    }
    path.Append(m_gpgCmd);
    wxString cmd = wxString::Format(wxT("%s %s"), path.GetData(), cmdLine.GetData());
#else
    wxString cmd = wxString::Format(wxT("%s %s"), m_gpgCmd.GetData(), cmdLine.GetData());
#endif
***/
    wxString cmd; //my add
    cmd=cmdLine; //my add
    m_gpgProcess = wxProcess::Open(cmd);  //my mod

    if (!m_gpgProcess) {
        return wxEmptyString;
    }
    m_gpgProcess->Redirect();

    out = m_gpgProcess->GetInputStream();
    err = m_gpgProcess->GetErrorStream();
    in = m_gpgProcess->GetOutputStream();

    if (!out) {
        return wxEmptyString;
    }
    return cmd;
}
/**********************************************/
bool _CallGPGInt(const wxString cmdLine, wxArrayString &stdIn, wxArrayString &stdOut, wxArrayString &stdErr, wxString suc_code)
{
    wxInputStream *out = NULL;
    wxInputStream *err = NULL;
    wxOutputStream *in = NULL;
    bool success = false;
    int it,itno;


    stdOut.Clear();
    wxString cmd = _OpenGPGProcess(cmdLine, in, out, err);
    //_WriteLog(wxT("[CMD] ") + cmd); my add

    if ((cmd != wxEmptyString)) {
        wxString msg;

        // Write to gpg
        wxTextOutputStream inText(*in);
        wxTextInputStream outText(*out);
        wxTextInputStream errText(*err);
        stdErr.Clear();

        itno=stdIn.GetCount();
        for (it = 0; it < itno; it++) {
            inText.WriteString(stdIn[it]);
        }
        m_gpgProcess->CloseOutput();


        while ( m_gpgProcess->IsInputOpened() ) {
            // Read from stdout...
            while (out->CanRead()){
                msg = outText.ReadLine();
                if (!msg.IsEmpty()) {
                    stdOut.Add(msg);
//                    _WriteLog(msg);
                    if (!success)
                     {
                      if (msg.Contains(suc_code))  success = true;
                     }
                }
            }

            // ...then from stderr
            while (err->CanRead()) {
                msg = errText.ReadLine();
                if (!msg.empty()) {
                    stdErr.Add(msg);
                    if (!success)
                     {
                      if (msg.Contains(suc_code))  success = true;
                     }
                }
            }
            if( (suc_code==_("no error")) && (stdErr.GetCount()==0)&& (stdOut.GetCount()==0)) success=true;
        }
    } // END if (cmd != wxEmptyString)

    return success; // if errors
} // END _CallGPGInt
/*******************************************************************************/
/**********************************************/
bool _CallGPGInt_pw(const wxString cmdLine, wxArrayString &stdIn, wxArrayString &stdOut, wxArrayString &stdErr, wxString suc_code)
{
    wxInputStream *out = NULL;
    wxInputStream *err = NULL;
    wxOutputStream *in = NULL;
    bool success = false;
    int it,itno,pwret;
    int d_i=0;
    wxString d_c;
    wxString pw,hint;


    stdOut.Clear();
    wxString cmd = _OpenGPGProcess(cmdLine, in, out, err);

    if (cmd != wxEmptyString) {
        wxString msg;

        // Write to gpg
        wxTextOutputStream inText(*in);
        wxTextInputStream outText(*out);
        wxTextInputStream errText(*err);
        stdErr.Clear();

        itno=stdIn.GetCount();
        for (it = 0; it < itno; it++) {
            inText.WriteString(stdIn[it]);
        }
        //check for passwd request
        while ( m_gpgProcess->IsInputOpened() ) {
            // Read from stdout...
            while (out->CanRead()){
                msg = outText.ReadLine();
                if (!msg.IsEmpty()) {
                    stdOut.Add(msg);
                    d_c.Printf(_("gpg_pw_out %d :"),d_i);
                    d_i++;
                    writelog(d_c,msg);
                    if (!success)
                     {
                      //check for pw_request
                      if(msg.Contains(_("_HINT")))
                      {
                         hint= msg;
                      }
                      if(msg.Contains(_("GET_HIDDEN passphrase.enter"))||(msg.Contains(_("passphrase to unlock"))))
                      {
                          //start pw dialog
                          pw_request dialog(NULL, _("Enter password for GnuPG private key access! \n")+hint, &pw);
                          pwret=dialog.ShowModal();
                          //write pw to inText
                          inText.WriteString(pw  +_("\n"));
                    d_c.Printf(_("gpg_pw_in : "));
                    writelog(d_c,pw +_("\n"));

                      }
                      if (msg.Contains(suc_code))  success = true;
                    }
                }
            }
        }

        //no more input to the process
        m_gpgProcess->CloseOutput();


        while ( m_gpgProcess->IsInputOpened() ) {
            // Read from stdout...
            while (out->CanRead()){
                msg = outText.ReadLine();
                    d_c.Printf(_("gpg_pw_out_sec %d :"),d_i);
                    d_i++;
                    writelog(d_c,msg);
                if (!msg.IsEmpty()) {
                    stdOut.Add(msg);
//                    _WriteLog(msg);
                    if (!success)
                     {
                      if (msg.Contains(suc_code))  success = true;
                     }
                }
            }

            // ...then from stderr
            d_i=0; //reset counter
            while (err->CanRead()) {
                msg = errText.ReadLine();
                    d_c.Printf(_("gpg_pw_err %d :"),d_i);
                    d_i++;
                    writelog(d_c,msg);
                if (!msg.empty()) {
                    stdErr.Add(msg);
                    //throwout((_("errmsg: ")+ msg),3);
//                    _WriteLog(msg);
                }
            }
        }
    } // END if (cmd != wxEmptyString)

    return success; // if errors
} // END _CallGPGInt
/*******************************************************************************/
bool prog_is_win_present(wxString progname)
{
    FILE *fp;
#ifdef __WXMSW__
    wxString cmdlin;
    bool retval,where_here;
    wxArrayString stdIn,stdOut,stdErr;

//    cmdlin = _("hash ") + progname + _(" &> /dev/null \n"");
//    cmdlin = _("@echo off\nsetlocal\nset found=\nset prog=")+progname+_(".exe \nfor %%i in (%path%) do if exist %%i\%prog% set found=%%i\nif \"%found%\" == "" goto notfound\necho %prog% found in path\ngoto mycomend\n:notfound ECHO on\necho absent in path\n:mycomend endlocal");
//    cmdlin = _("which ") + progname +_(" \n");// + _(" &> /dev/null \n");
//write whichcommand file to disk
    fp=fopen("my_which.cmd","w");
    if(fp==NULL) return false;
    fprintf(fp,"@echo off &setlocal &set found=&set prog=%%1%%.exe\n");
    fprintf(fp,"for %%%%i in (%%path%%) do if exist %%%%i\\%%prog%% set found=%%%%i\n");
    fprintf(fp,"if \"%%found%%\" == \"\" goto notfound\n");
    fprintf(fp,"echo %%prog%% found in path\ngoto mycomend\n:notfound ECHO on\n");
    fprintf(fp,"echo absent in path\n");
    fprintf(fp,":mycomend endlocal\n");
 //   fprintf(fp,"Exit\n");
    fclose(fp);

//call whichcommand
//delete Whichcommand-file
    //check if where here
    cmdlin = _("CMD /C \"my_which where \" \n");
    where_here= _CallGPGInt(cmdlin, stdIn, stdOut, stdErr, _("where"));
    if(where_here) // in newer win 7
    {
        cmdlin = _("CMD /C \"where ") + progname + _(" \" \n");
        retval= _CallGPGInt(cmdlin, stdIn, stdOut, stdErr, progname);
    }
    else  //in old XP
    {
    cmdlin = _("CMD /C \"my_which ") + progname + _(" \" \n");
    //check if where here

    //stdIn.Add(progname + _(" \n"));
    retval= _CallGPGInt(cmdlin, stdIn, stdOut, stdErr, progname);
    }
    wxRemoveFile(_("my_which.cmd"));
    return retval;
#else
    return prog_is_present(progname);
#endif
}
/****************alternativ****************/
bool prog_is_win_present(wxString progname, wxString ext, wxString *pfullnam)
{
    wxString cmdlin,p_string,testnam,psep;
    wxArrayString stdIn,stdOut,stdErr,path_a;
    bool retval;
    int count,entryno,i,plen;

// pfad abfragen und in stringvariablen ablegen
	    cmdlin = _("CMD /C path \n");
        retval= _CallGPGInt(cmdlin, stdIn, stdOut, stdErr, _(";"));
// pfadantwortlines bestimmen
        count=stdOut.Count();
        if(count<1){throwout(_("error empty answer on path command...?")); return false;}
        if(count>1){throwout(_("error more3 than one answer line on path command...?")); return false;}
// pfadeintragsno bestimmen
	p_string= stdOut[0];
//remove first five chars: Path=
    plen=p_string.Length();
    p_string = p_string.Right(plen-5);
	do
	{
		path_a.Add(p_string.BeforeFirst(';'));
		p_string=p_string.AfterFirst(';');
	}while(!p_string.IsEmpty());
	entryno=path_a.Count();
//fuer jede No: Filenamen bilden, auf wxFile::Exists testen
	i=0;
	psep=wxFileName::GetPathSeparator();
	while(i<entryno)
	{
		testnam= path_a[i] + psep + progname +_(".") + ext;
		if(wxFile::Exists(testnam)) break;
		i++;
	}
//wenn nix gefunden -> return false
	if(i==entryno) return false;
//wenn gefunden -> return volle Pfadangabe
    *pfullnam= testnam;
    return true;
}
 /*****************************************/
/*******************************************************************************/
bool prog_is_present(wxString progname)
{
    bool retval;
    wxString fullnam;
#ifdef __WXMSW__
    retval= prog_is_win_present(progname,_("exe"),&fullnam);
    throwout(_("testing for presence of:") + progname + _("in Path"),1 );
    if(retval) throwout( fullnam + _("  found!"),1 );
    else throwout( progname + _(".exe") + _(" not  found!"),1 );
    return retval;
#else
    wxString cmdlin;
    wxArrayString stdIn,stdOut,stdErr;

//    cmdlin = _("hash ") + progname + _(" &> /dev/null \n"");
//    cmdlin = _("type ") + progname + _(" &> /dev/null \n"");
    cmdlin = _("which ") + progname + _(" \n");
    retval= _CallGPGInt(cmdlin, stdIn, stdOut, stdErr, progname);
    //retval=system((const char*)(cmdlin.mb_str(wxConvUTF8)));
#endif
    return retval;
}
/********************************************/
bool gpg_version(wxString *pver)
//if both present, use gpg
{
    wxString cmdlin=_("gpg --version");
    wxArrayString stdIn,stdOut,stdErr;
    wxString msg;
    int no,i;

    gpg_here= _CallGPGInt(cmdlin,stdIn,stdOut,stdErr);
/*    if(find_in_array(_("gpg (GnuPG) 2.0.17"), stdOut))
    {
        throwout(_("found dysfunctional version GnuPG 2.0.17\ntry to fall back to gpg version 1.x"),5);
        success=false;
    }*/
    if(!gpg_here)
    {
        //throwout(_("could not find PGP2!\nNow checking for (old)PGP."),2);
        cmdlin=_("gpg2 --version");
        gpg2_here= _CallGPGInt(cmdlin,stdIn,stdOut,stdErr,_("Supported algorithms:"));
        if(!gpg2_here)
        {
            msg=_("could not find any GnuPG!\nDisabling \"invoke GnuPG\" entry:\n\n");
            no=stdErr.GetCount();
            i=0;
            while((i<10) && (i<no))
            {int get_priv_labels();
                msg += _("\n") + stdErr[i];
                i++;
            }
            pver->empty();
            //throwout(msg,20);
        }
        else
        {
            msg=_("Found GnuPG2.\n\n");
            no=stdOut.GetCount();
            i=0;
            while((i<2) && (i<no))
            {
                msg += _("\n") +stdOut[i];
                i++;
            }
            throwout(msg,20);
            *pver=_("gpg2 ");
        }
        return gpg2_here;
    }
    else
    {
            msg=_("Found GnuPG.\n");
            no=stdOut.GetCount();
            i=0;
            while((i<2) && (i<no))
            {
                msg += _("\n") +stdOut[i];
                i++;
            }
            //throwout(msg,20);
            *pver=_("gpg ");
            gpg_here=true;
            cmdlin=_("gpg2 --version");
            gpg2_here= _CallGPGInt(cmdlin,stdIn,stdOut,stdErr,_("Supported algorithms:"));
    }
    //pp= wxProcess::Open(_("gpgxxxx --version"));
    //throwout(_("function not implemented yet"),3);

    return (gpg_here||gpg2_here);
}
/**********************************************************/
bool gpg_get_name(wxString *name)
{
    bool success;
    wxArrayString stdIn,stdOut,stdErr;

    success= _CallGPGInt(_("gpg --version"),stdIn,stdOut,stdErr,_("Copyright"));
    if(success)
    {
        *name=stdOut[0];
    }
    else *name= _("not present");
    return success;
}
/***********************************************************/
bool gpg2_get_name(wxString *name)
{
    bool success;
    wxArrayString stdIn,stdOut,stdErr;

    success= _CallGPGInt(_("gpg2 --version"),stdIn,stdOut,stdErr,_("Copyright"));
    if(success)
    {
        *name=stdOut[0];
    }
    else *name= _("not present");
    return success;
}
/**********************************************/
int get_priv_labels(wxArrayString &lablz)
{
    int ki,i;

    ki=get_priv_labels();
    lablz.Clear();
    for(i=0;i<ki;i++) lablz.Add(kylabel[i]);
    return ki;
}
/************************************************/
int get_priv_labels()
{
    int i,lineno,en_no,ki=-1;
    bool drin=false;
	wxArrayString rawlist,templ;

	if(!gpg_get_prilist(&rawlist))
	{
	    throwout(_("Error in get privkeylist"));
	    return -1;
	}
	//clear all arrays
	kylength.Clear();
	kytype.Clear();
	kyid.Clear();
	kyname.Clear();
	kylabel.Clear();
	kyfprint.Clear();
	//evaluate rawlist
	lineno=rawlist.GetCount();
	i=0;ki=0;
	while(i< lineno)
	{
        if(ki>99)
        {
            throwout(_("More than 100 privet keys!?!\nAre you nuts?\ntruncating."));
            break;
        }
        en_no=splitstring(rawlist[i], &templ, ':');
	    if(templ[0]== _("sec"))
	    {
	        //relevant line found, read in
            if(drin) ki++; //Last one not finished increment index here
	        //kylen,type,id,crdate
            kylength.Add(templ[1]);
            kytype.Add(templ[2]);
                if(kytype[ki]==_("1")) kytype[ki]=_("RSA");
                if(kytype[ki]==_("17")) kytype[ki]=_("DSA");
                if(kytype[ki]==_("16")) kytype[ki]=_("elGamal(no sig)");
                if(kytype[ki]==_("20")) kytype[ki]=_("elGamal");
            kyid.Add(templ[3]);
            //now waiting for name
            kyname.Add(_("empty"));
            kyfprint.Add(_("empty"));
            drin=true;
	    }
	    else if((templ[0]== _("fpr"))&&drin)
	    {
	        if(drin) kyfprint[ki]=templ[1];
	        //drin=false;
	        //ki++;  //reading key fibished set next index
	    }
	    else if((templ[0]== _("uid"))&&drin)
	    {
	        if(drin) kyname[ki]=templ[2];
	        drin=false;
	        ki++;  //reading key fibished set next index
	    }
	    i++;
	}
	ki=kyid.GetCount();
	//set labels
	for(i=0;i<ki;i++) kylabel.Add( kyid[i].Right(8) + _("   ") + kytype[i] +_(" ") + kylength[i] + _("   ")+ kyname[i] );
	if(ki>=pk_sel) privkey=kyid[pk_sel];
	return ki;
	}

/**********************************************/
int get_pub_labels(wxArrayString &lablz)
{
    int ki,i;

    ki=get_pub_labels();
    lablz.Clear();
    for(i=0;i<ki;i++) lablz.Add(kylabel[i]);
    return ki;
}
/************************************************/
int get_pub_labels()
{
    int i,lineno,en_no,ki;
    bool drin=false;
	wxArrayString rawlist,templ;

	if(!gpg_get_publist(&rawlist))
	{
	    throwout(_("Error in get privkeylist"));
	    return -1;
	}
	//clear all arrays
	pb_kylength.Clear();
	pb_kytype.Clear();
	pb_kyid.Clear();
	pb_kyname.Clear();
	pb_kylabel.Clear();
	//evaluate rawlist
	lineno=rawlist.GetCount();
	i=0;ki=0;
	while(i< lineno)
	{
        if(ki>500)
        {
            throwout(_("More than 500 public keys!?!\nAre you nuts?\ntruncating."));
            break;
        }
        en_no=splitstring(rawlist[i], &templ, ':');
	    if(templ[0]== _("pub"))
	    {
	        //relevant line found, read in
            if(drin) ki++; //Last one not finished increment index here
	        //kylen,type,id,crdate
            pb_kylength.Add(templ[2]);
            pb_kytype.Add(templ[3]);
                if(pb_kytype[ki]==_("1")) pb_kytype[ki]=_("RSA");
                if(pb_kytype[ki]==_("17")) pb_kytype[ki]=_("DSA");
                if(pb_kytype[ki]==_("16")) pb_kytype[ki]=_("elGamal(no sig)");
                if(pb_kytype[ki]==_("20")) pb_kytype[ki]=_("elGamal");
            pb_kyid.Add(templ[4]);
            //now waiting for name
            pb_kyname.Add(_("empty"));
            drin=true;
	    }
	    else if((templ[0]== _("uid"))&&drin)
	    {
	        if(drin) pb_kyname[ki]=templ[4];
	        drin=false;
	        ki++;  //reading key fibished set next index
	    }
	    i++;
	}
	ki=pb_kyid.GetCount();
	//set labels
	for(i=0;i<ki;i++) pb_kylabel.Add( pb_kyid[i].Right(8) + _("   ") + pb_kytype[i] +_(" ") + pb_kylength[i] + _("   ")+ pb_kyname[i] );
	if(ki>=pk_sel) pubkey=pb_kyid[pk_sel];
	return ki;
	}

/********************************************//********************************************/
bool gpg_get_prilist(wxArrayString *plist)
{
    bool success;
    wxString cmdlin;
    wxArrayString stdIn,stdOut,stdErr;
    wxString msg;
    int no,i;

    cmdlin = gpg_name +_(" -K --with-colons --fingerprint --fixed-list-mode");
    success= _CallGPGInt(cmdlin,stdIn,stdOut,stdErr,_("sec"));
    if(!success)
    {
            msg=_("Error: \ncould not get private Keylist!\n\n");
            no=stdErr.GetCount();
            i=0;
            while((i<10) && (i<no))
            {
                msg += _("\n") + stdErr[i];
                i++;
            }
            plist->Clear();
            throwout(msg,20);
    }
    else
    {
            plist->Clear();
            no=stdOut.GetCount();
            i=0;
            while((i<100) && (i<no))
            {
                plist->Add(stdOut[i]);
                i++;
            }
    }
    return success;
}
/**********************************************/
/********************************************/
/********************************************/
bool gpg_get_publist(wxArrayString *plist)
{
    bool success;
    wxString cmdlin;
    wxArrayString stdIn,stdOut,stdErr;
    wxString msg;
    int no,i;

    cmdlin = gpg_name +_(" -k --with-colons --fixed-list-mode");
    success= _CallGPGInt(cmdlin,stdIn,stdOut,stdErr,_("pub:"));
    if(!success)
    {
            msg=_("Error: \ncould not get private Keylist!\n\n");
            no=stdErr.GetCount();
            i=0;
            while((i<10) && (i<no))
            {
                msg += _("\n") + stdErr[i];
                i++;
            }
            plist->Clear();
            throwout(msg,20);
    }
    else
    {
            plist->Clear();
            no=stdOut.GetCount();
            i=0;
            while((i<500) && (i<no))
            {
                plist->Add(stdOut[i]);
                i++;
            }
    }
    return success;
}
/**********************************************/
bool gpg_select_key(wxString id)
{
return false;
//dummy yet
}
/******************************************************/
bool gpg_create_sig(wxString k_id, wxString fnam, wxString snam)
{
    bool success;
    wxString cmdlin;
    wxArrayString stdIn,stdOut,stdErr;
    wxString msg;

    cmdlin= gpg_name + _(" --local-user ") + k_id + _(" --yes --status-fd 1 --no-tty --command-fd 0 --output ");
    cmdlin += snam;
    cmdlin += (_(" -b ") + fnam);

    success= _CallGPGInt_pw(cmdlin,stdIn,stdOut,stdErr,_("SIG_CREATED"));
    if(logging)
    {
        writelog(_("cmdlin"),cmdlin);
        writelog(_("in"),stdIn);
        writelog(_("out"),stdOut);
        writelog(_("err"),stdErr);
    }
    if(success)
    {
        return true;
    }
    else
    {
        //check for reason wrong password
        if(find_in_array(_("bad passphrase"),stdErr))
          throwout(_("Bad Passphrase"),2);
    }
    return false;
}
/******************************************************/
bool gpg_sign_pubkey(wxString k_id)
{
    bool success;
    wxString cmdlin;
    wxArrayString stdIn,stdOut,stdErr;
    wxString msg;

    cmdlin= gpg_name + _(" --local-user ") + _(" --sign-key ") + k_id + _(" --yes --status-fd 1 --no-tty ");

    success= _CallGPGInt_pw(cmdlin,stdIn,stdOut,stdErr,_("already signed"));
    if(logging)
    {
        writelog(_("cmdlin"),cmdlin);
        writelog(_("in"),stdIn);
        writelog(_("out"),stdOut);
        writelog(_("err"),stdErr);
    }
    if(success)
    {
        return true;
    }
    else
    {
        //check for reason wrong password
        if(find_in_array(_("bad passphrase"),stdErr))
          throwout(_("Bad Passphrase"),2);
    }
    return false;
}
/************************************************************/
/************************************************************/
bool gpg_verify_signature(wxString k_id, wxString fnam, wxString snam, wxString *msg)
{
    bool success,truesig=false;
    wxString cmdlin,hlp,p_f_no;
    wxArrayString stdIn,stdOut,stdErr;
    int erc,oc,i,icnt=0;
    cmdlin= gpg_name  + _("--always-trust --status-fd 1 ") + _( "--verify ");
    hlp= _(" ") + snam + _(" ") + fnam;
    cmdlin += hlp;
    success= _CallGPGInt(cmdlin,stdIn,stdOut,stdErr,k_id);
    if(logging)
    {
        writelog(_("cmdlin"),cmdlin);
        writelog(_("in"),stdIn);
        writelog(_("out"),stdOut);
        writelog(_("err"),stdErr);
    }
    //verify communicates via the error channel

    if((erc=stdErr.GetCount())<1)
        {
            throwout(_("Error, should have lines in stdErr ???"),3);
        }
    if((oc=stdOut.GetCount())<1)
        {
            throwout(_("Should have lines in stdOut ???"),3);
            return false;
        }
    //check for success in stdErr
    success=false;

    for (i=0;i<oc;i++)
    {
        if(stdOut[i].Contains(_("GOODSIG")))
        {
            success=true;
            icnt=i;
            break;
        }
        if(stdOut[i].Contains(_("BADSIG")))
        {
            success=false;
            icnt=i;
             *msg= _("Bad Signature!"); //could not verify
            return success;
        }
        if(stdOut[i].Contains(_("ERRSIG")))
        {
            success=false;
            icnt=i;
             *msg= _("Could not determine\nvalidity of Signature!"); //could not verify
            return success;
        }
        if(success) break;
    }


    if(!success)
    {
            *msg= _("Could not verify!"); //could not verify
            return false;
    }
    else
    {
        //check for right ky_id
      for (i=0;i<oc;i++)
      {
        if(stdOut[i].Contains(k_id.Right(8)))
        {
            truesig=true;
            break;
        }
        if(truesig) break;
      }
      if(!truesig)
        {
            *msg=_("Signature rejected!\nFile was signed with other key than presumed signers\n");
            *msg += stdErr[icnt].Right(((stdErr[icnt]).Len())-10) +_("\n");
            if(erc>(icnt+1)) *msg += stdErr[icnt+1];
            return false;
        }
    else
        {
                throwout(_("Signature accepted!"),3);
                *msg=_("Signature verified!\n\n");
                for(i=0;i<oc;i++)
                {
                    if(stdOut[i].Contains(_("GOODSIG")) )
                    {
                         *msg  += stdErr[i] + _("\n");
                         *msg += _("\nYou hopefully did check trustworthyness of the used public key....\n");
                         break;
                    }
                }
                for(i=0;i<erc;i++)
                {
                    if(!stdErr[i].Contains(_("WARNING:"))&&!(stdErr[i].Contains(_("no indication")))    )
                       *msg  += stdErr[i] + _("\n");
                }
                return truesig;
        }
    return truesig;
    }
}
/************************************************************/
bool gpg_import_pubkey(wxString fnam)
{
    bool success;
    wxString cmdlin;
    wxArrayString stdIn,stdOut,stdErr;
    wxString msg;

    cmdlin= gpg_name + _(" --batch --import \"") + fnam + _("\"");

    success= _CallGPGInt(cmdlin,stdIn,stdOut,stdErr,_("imported:"));

    if(logging)
    {
        writelog(_("cmdlin"),cmdlin);
        writelog(_("in"),stdIn);
        writelog(_("out"),stdOut);
        writelog(_("err"),stdErr);
    }
    if(success)
    {
        get_pub_labels();
        return true;
    }
    else
    {
        //check for reason
        if(  (find_in_array(_("No such file"),stdErr))||(find_in_array(_("No such file"),stdOut)))
          throwout(_("Keyfile not found"),2);
        else if(find_in_array(_("unchanged:"),stdOut))
          throwout(_("public key already in GnuPG"),2);
    }
    return false;
}
/***************************************************/
bool gpg_remove_pubkey(wxString keyid)
{
    bool success;
    wxString cmdlin;
    wxArrayString stdIn,stdOut,stdErr;
    wxArrayString prior,past;
    wxString msg;
    wxArrayString prlst;
    int i,prinum,pubnum,rindx=-1,pr,pa;

    //first check whether priv key with this id exixts
    if(!gpg_get_prilist(&prlst)){throwout(_("Error, could not get\nprivate key list"),2); return false;}
    prinum=prlst.GetCount();
    for(i=0;i<prinum;i++)
    {
        if( (prlst[i]).Contains(keyid.Right(8)) )
        {
            throwout(_("will not delete,\nprivate key associated!"),2);
            return false;
        }
    }
    //check if last key
    pubnum=pb_kylabel.GetCount();
    if(pubnum ==1)
    {
        throwout(_("will not delete last public key!"),2);
        return false;
    }

    cmdlin= gpg_name + _(" --no-secmem-warning --no-tty --batch --yes --delete-key  ") + keyid;

    gpg_get_publist(&prior);pr=prior.GetCount();
    success= _CallGPGInt(cmdlin,stdIn,stdOut,stdErr,_("\\")+keyid.Right(8));
    if(logging)
    {
        writelog(_("cmdlin"),cmdlin);
        writelog(_("in"),stdIn);
        writelog(_("out"),stdOut);
        writelog(_("err"),stdErr);
    }
    //does not return any message if successful so success has to be checked externally
    gpg_get_publist(&past);pa=past.GetCount();
    if(pa<pr) success=true;
    if(success)
    {
        get_pub_labels();
        return true;
    }
    else
    {
        //check for reason
        if(find_in_array(_("not found"),stdErr))
          throwout(_("Key not found"),2);
    }
    return false;
}
/****************************************************/
bool gpg_export_pubkey(wxString fnam, wxString kyd)
{
    bool success;
    wxString cmdlin;
    wxArrayString stdIn,stdOut,stdErr;
    wxString msg;

    cmdlin= gpg_name + _(" --batch --yes -a --export --output \"") + fnam + _("\" ") + kyd;
    success=_CallGPGInt(cmdlin,stdIn,stdOut,stdErr,_("no error"));//no output on success

    if(logging)
    {
        writelog(_("cmdlin"),cmdlin);
        writelog(_("in"),stdIn);
        writelog(_("out"),stdOut);
        writelog(_("err"),stdErr);
    }
    if(success)
    {
        return true;
    }
    else
    {
        //check for reason
        if(  (find_in_array(_("nothing exported"),stdErr)))
          throwout(_("nothing exported"),2);
    }
    return false;
}
/***************************************************/
/************************************************************/
bool gpg_import_privkey(wxString fnam)
{
    bool success;
    wxString cmdlin;
    wxArrayString stdIn,stdOut,stdErr;
    wxString msg;

    cmdlin= gpg_name + _(" --batch --import \"") + fnam + _("\"");

    success= _CallGPGInt(cmdlin,stdIn,stdOut,stdErr,_("imported:"));

    if(logging)
    {
        writelog(_("cmdlin"),cmdlin);
        writelog(_("in"),stdIn);
        writelog(_("out"),stdOut);
        writelog(_("err"),stdErr);
    }
    if(success)
    {
        get_priv_labels();
        return true;
    }
    else
    {
        //check for reason
        if(  (find_in_array(_("No such file"),stdErr))||(find_in_array(_("No such file"),stdOut)))
          throwout(_("Keyfile not found"),2);
        else if(find_in_array(_("unchanged:"),stdOut))
          throwout(_("private key already in GnuPG"),2);
    }
    return false;
}
/***************************************************/
bool gpg_remove_privkey(wxString keyid)
{
    bool success;
    wxString cmdlin;
    wxArrayString stdIn,stdOut,stdErr;
    wxArrayString prior,past;
    wxString msg;
    wxArrayString prlst;
    int i,prinum,pubnum,rindx=-1,pr,pa;

    //check if last key
    prinum=kylabel.GetCount();
    if(prinum ==1)
    {
        throwout(_("will not delete last private key!"),2);
        return false;
    }

    cmdlin= gpg_name + _(" --no-secmem-warning --batch --no-tty --yes --delete-secret-key  ") + keyid;
    //stdIn.Add(_("y\n"));
    gpg_get_prilist(&prior);pr=prior.GetCount();
    success= _CallGPGInt(cmdlin,stdIn,stdOut,stdErr,_("\\")+keyid.Right(8));
    if(logging)
    {
        writelog(_("cmdlin"),cmdlin);
        writelog(_("in"),stdIn);
        writelog(_("out"),stdOut);
        writelog(_("err"),stdErr);
    }
    //does not return any message if successful so success has to be checked externally
    gpg_get_prilist(&past);pa=past.GetCount();
    if(pa<pr) success=true;
    if(success)
    {
        get_priv_labels();
        return true;
    }
    else
    {
        //check for reason
        if(find_in_array(_("not found"),stdErr))
          throwout(_("Key not found"),2);
    }
    return false;
}
/****************************************************/
bool gpg_export_privkey(wxString fnam, wxString kyd)
{
    bool success;
    wxString cmdlin;
    wxArrayString stdIn,stdOut,stdErr;
    wxString msg;

    cmdlin= gpg_name + _(" --batch --yes -a --export-secret-keys --output \"") + fnam + _("\" ") + kyd;
    success=_CallGPGInt(cmdlin,stdIn,stdOut,stdErr,_("no error"));//no output on success

    if(logging)
    {
        writelog(_("cmdlin"),cmdlin);
        writelog(_("in"),stdIn);
        writelog(_("out"),stdOut);
        writelog(_("err"),stdErr);
    }
    if(success)
    {
        return true;
    }
    else
    {
        //check for reason
        if(  (find_in_array(_("nothing exported"),stdErr)))
          throwout(_("nothing exported"),2);
    }
    return false;
}
/***************************************************/
/****************************************************/
bool gpg_make_key(wxString nam, wxString cmnt, wxString imehl, wxString type, wxString klen, wxString pw, wxString expiry )
{
    bool success;
    wxString cmdlin;
    wxArrayString stdIn,stdOut,stdErr;

    cmdlin= gpg_name + _(" --no-secmem-warning --batch --status-fd 1 --gen-key");
    if (type == wxT("RSA")) {
        stdIn.Add(wxT("Key-Type: RSA\n"));
    } else {
        stdIn.Add(wxT("Key-Type: DSA\n"));
        stdIn.Add(wxT("Subkey-Type: ELG-E\n"));
        stdIn.Add(wxT("Subkey-Length: 1024\n"));
    }
    stdIn.Add(_("Passphrase: ")   + pw    + wxT("\n"));
    stdIn.Add(_("Key-Length: ")   + klen  + wxT("\n"));
    stdIn.Add(_("Name-Real: ")    + nam   + wxT("\n"));
    if (cmnt != wxEmptyString) {
        stdIn.Add(_("Name-Comment: ") + cmnt + wxT("\n"));
    }
    stdIn.Add(_("Name-Email: ")   + imehl   + wxT("\n"));
    stdIn.Add(_("Expire-Date: ")  + expiry  + wxT("\n"));
    stdIn.Add(_("%commit\n"));
    stdIn.Add(_("%echo Done\n"));

    success=_CallGPGInt(cmdlin,stdIn,stdOut,stdErr,_("Done"));//no output on success
    if(logging)
    {
        writelog(_("cmdlin"),cmdlin);
        writelog(_("in"),stdIn);
        writelog(_("out"),stdOut);
        writelog(_("err"),stdErr);
    }
    return success;
}
/********************************************************/
bool gpg_encode( wxString k_id, wxString fnam, wxString snam, wxString *msg)
{
    bool success,truesig=false;
    wxString cmdlin,hlp;
    wxArrayString stdIn,stdOut,stdErr;
    int erc,i,icnt=0;

    // gpg --armor --batch --always-trust --encrypt --recipient <id> --output <out_file> <in_file>
    cmdlin= gpg_name + _( " --armor --batch --always-trust --encrypt --recipient ");
    hlp= k_id + _(" --output ") + snam + _(" ") + fnam;
    cmdlin += hlp;
    success= !_CallGPGInt(cmdlin,stdIn,stdOut,stdErr,_("encryption failed"));
    if(logging)
    {
        writelog(_("cmdlin"),cmdlin);
        writelog(_("in"),stdIn);
        writelog(_("out"),stdOut);
        writelog(_("err"),stdErr);
    }
    //check stdErr for message and throwout
    erc=stdErr.GetCount(); //gpg communicates via error channel
    *msg=_("");
    for(i=0;i<erc;i++)
    {
       *msg += stdErr[i];
       *msg += _("\n");
    }
    return success;
}
/******************************************************/
bool gpg_decrypt( wxString fnam, wxString outfile)
{
    bool success;
    wxString cmdlin;
    wxArrayString stdIn,stdOut,stdErr;
    wxString msg;

    cmdlin= gpg_name + _("--decrypt --yes --no-sk-comment --status-fd 1 --no-tty --command-fd 0 --output ");
    cmdlin += outfile +_(" ") + fnam;
// in case needs overwriting does it!
    //stdIn.Add(  _("y\n"));
    success= _CallGPGInt_pw(cmdlin,stdIn,stdOut,stdErr,_("DECRYPTION_OKAY"));
    if(logging)
    {
        writelog(_("cmdlin"),cmdlin);
        writelog(_("in"),stdIn);
        writelog(_("out"),stdOut);
        writelog(_("err"),stdErr);
    }
    if(success)
    {
        return true;
    }
    else
    {
        //check for reason wrong password
        if(find_in_array(_("bad passphrase"),stdErr))
          throwout(_("Bad Passphrase"),2);
    }
    return false;
}
/************************************************************/
void gpg_blank() //disable gnupg on error
{
            throwout(_("Invoking GnuPG failed\n disabling ")+ gpg_name,2);
            gpg_name=_("none");
            gpg_pres_checked=false;
            gpg_here=false;
            gpg2_here=false;
            return;
}
/************************************************************/
