/*
 *   Copyright (C) 2011-2012, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
 

#include "DeletePrivEllky.h"
#include "elliptic1.h"

//(*InternalHeaders(DeletePrivEllky)
#include <wx/intl.h>
#include <wx/string.h>
//*)
#include <wx/filedlg.h>


#include "globals.h"



//(*IdInit(DeletePrivEllky)
const long DeletePrivEllky::ID_STATICTEXT1 = wxNewId();
const long DeletePrivEllky::ID_LISTBOX1 = wxNewId();
const long DeletePrivEllky::ID_BUTTON1 = wxNewId();
const long DeletePrivEllky::ID_BUTTON2 = wxNewId();
const long DeletePrivEllky::ID_BUTTON3 = wxNewId();
//*)

BEGIN_EVENT_TABLE(DeletePrivEllky,wxDialog)
	//(*EventTable(DeletePrivEllky)
	//*)
END_EVENT_TABLE()

DeletePrivEllky::DeletePrivEllky(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
    FILE *knfp;
    char buff1[1000], buff2[1000];
    int lbl,count;
    wxString fn;


	//(*Initialize(DeletePrivEllky)
	wxFlexGridSizer* FlexGridSizer1;

	Create(parent, id, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("id"));
	SetClientSize(wxDefaultSize);
	Move(wxDefaultPosition);
	FlexGridSizer1 = new wxFlexGridSizer(0, 3, 0, 0);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Choose Private\nelliptic key to delete"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	ListBox1 = new wxListBox(this, ID_LISTBOX1, wxDefaultPosition, wxSize(225,397), 0, 0, wxVSCROLL, wxDefaultValidator, _T("ID_LISTBOX1"));
	FlexGridSizer1->Add(ListBox1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button1 = new wxButton(this, ID_BUTTON1, _("Delete Key"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_TOP|wxALIGN_CENTER_HORIZONTAL, 5);
	Button2 = new wxButton(this, ID_BUTTON2, _("Exit"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	Button2->SetDefault();
	FlexGridSizer1->Add(Button2, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button3 = new wxButton(this, ID_BUTTON3, _("Import Private Elliptic\nKey from File"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON3"));
	FlexGridSizer1->Add(Button3, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	SetSizer(FlexGridSizer1);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&DeletePrivEllky::OnDeleteKey);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&DeletePrivEllky::OnExit);
	Connect(ID_BUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&DeletePrivEllky::Import_el_Privky);
	//*)

		    // zuerst Namensliste Laden
    wxArrayString wxstrad; //wxStringarray initialisieren
    fn=sec_path + _("/ell_knamfile.knf");
    if(S_FIL) unlockinplace(fn,&zugang);
    knfp=fopen((const char*) fn.mb_str(wxConvUTF8), "r");
    count=0;
    do{
        lbl=fscanf(knfp, " id: %s Name: %s\n",buff1,buff2);
        //in wxstrad einpflegen
        if(lbl==2) {
            wxstrad.Add( (wxString::FromAscii(buff1)) + _("  ") + (wxString::FromAscii(buff2)) );
            ids.Add(wxString::FromAscii(buff1)); //ids ist eine class-variable
            count++;
        }
    }while(lbl == 2);
 	// Jetzt die Listbox initialisieren
    ListBox1->InsertItems(wxstrad,0);
    //als Menu in neuem Dialog anbieten und auswählen

    fclose(knfp);
    if(S_FIL) lockinplace(fn,&zugang);
}

DeletePrivEllky::~DeletePrivEllky()
{
	//(*Destroy(DeletePrivEllky)
	//*)
}


void DeletePrivEllky::Import_el_Privky(wxCommandEvent& event)
{
 /*   wxString importfile,h;
    el_priv loky;
    wxString txa,tya;
    FILE *knamfil, *kfil;
    bool oldname=false;
    char buff1[400],buff2[400];
    int lbl;

*/
    throwout(_(" Inactive for security reasons\n must manually copy and paste from dialog window \nif necessary!"));
    return;
/*
    importfile = wxFileSelector(_("Choose a file to import"),NULL,NULL,_("pvl"),_("*.pvl"));
    if(importfile.IsEmpty())
    {
        wxMessageBox(_("importfile doesn't exist!\nDo nothing!"));
        return;
    }
    if(!loky.get_from_file(importfile))
    {
        wxMessageBox(_("invalid importfile\nDo nothing!"));
        return;
    }
    //check validity
    if(! loky.A.is_in_ellipse(&gdom))
    {
        wxMessageBox(_("key is incompatible with current domain\n will not import!\n"));
        return;
    }
    //open keynamfile, append name and id, close keynamfile

    if(S_FIL) unlockinplace(_("e_ell_knamfile.knf"),&zugang);
    knamfil=fopen("e_ell_knamfile.knf", "r");
    do{
        lbl=fscanf(knamfil, " id: %s Name: %s ",buff1,buff2);// zweite ist hier dummy
        strcpy(buff2, (const char*) (loky.id).mb_str(wxConvUTF8));
        if(strcmp(buff1,buff2) ==0)
        {
            oldname = true;
            break;
        }
    }while(lbl == 2);
    fclose(knamfil);
    if(S_FIL) lockinplace(_("e_ell_knamfile.knf"),&zugang);
    if(oldname)
    {
        throwout(_(" This ext_key ID is already in use \n Please change ID in editable importfile!"));
        return;
    }
    if(S_FIL) unlockinplace(_("e_ell_knamfile.knf"),&zugang); // unlock keynamefile
    if((knamfil = fopen("e_ell_knamfile.knf", "a"))== NULL) return;
    fprintf(knamfil, "id: %s  Name: %s  \n",(const char*)(loky.id).mb_str(wxConvUTF8),
                  (const char*)(loky.fullnam).mb_str(wxConvUTF8));
    fclose(knamfil);
    if(S_FIL) lockinplace(_("e_ell_knamfile.knf"),&zugang); // lock again

    //open keyfile, store all data and close
    if(S_FIL) unlockinplace(_("e_ell_Keyfile.kyf"),&zugang); // unlock keynamefile
    if((kfil = fopen("e_ell_Keyfile.kyf", "a"))== NULL) return;
    fprintf(kfil, "id: %s  Name: %s DomName: %s\n",(const char*)(loky.id).mb_str(wxConvUTF8),
                  (const char*)(loky.fullnam).mb_str(wxConvUTF8),(const char*)(loky.domnam).mb_str(wxConvUTF8) );
    (loky.A.x).writehex(&txa);
    (loky.A.y).writehex(&tya);

    fprintf(kfil,"Ax: %s \n Ay: %s \n \n", (const char*)txa.mb_str(wxConvUTF8), (const char*)tya.mb_str(wxConvUTF8));
    fclose(kfil);
    if(S_FIL) lockinplace(_("e_ell_Keyfile.kyf"),&zugang); // unlock keynamefile
    //set flag to recall dialog
    EndModal(1); //caller has to recall
    return;
    */
}

void DeletePrivEllky::OnExit(wxCommandEvent& event)
{
    EndModal(0);//caller doesn't recall
}
/*******************  helperfunction  ************************************/
bool liberatekylist(int keyz,el_priv **zz)
{
    int i;

    if(zz==NULL) return false;
    for(i=keyz-1; i>=0; i--)
    {
       delete( *(zz+i));
    }
    free(zz);
    return true;
}
/***********************************************************************/
void DeletePrivEllky::OnDeleteKey(wxCommandEvent& event)
{
    wxString del_id,hlp,txa;
    el_priv **ppt=NULL;
    int keyno,indx,i,lbl;
    el_priv tmpky;
    char buff[400];
    FILE *kfp,*knfp;
    unsigned long fpos;

    //get id of file to delete
    indx=ListBox1->GetSelection();
    del_id= ids.Item(indx);  //kann nachher weg, ist
    //unlock keyfile and keynamfile
    if(S_FIL) unlockinplace(sec_path + _("/ell_knamfile.knf"),&zugang);
    if(S_FIL) unlockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang);
    keyno=0;
    kfp=fopen("secrets/ell_Keyfile.kyf","r");
// load all keys into memory
    ppt= (el_priv**)malloc(sizeof(el_priv**));
    do{
        lbl=fscanf(kfp," id: %s \n",buff);
        if( lbl == EOF) break;
        if(lbl==0)
        {
             fpos=ftell(kfp);
             fpos++;
             fseek ( kfp , fpos , SEEK_SET );
        }
        else
        {
          //make wxstring from buff
          hlp= wxString::FromAscii(buff);
          //mache platz in der Liste
          keyno++;
          ppt= (el_priv **) realloc(ppt,keyno*sizeof(el_priv *));
          *(ppt+keyno-1)= new(el_priv);
          (*(ppt+keyno-1))->id=hlp;
    //lade alle anderen

        if( (lbl=fscanf(kfp,"Name: %s ",buff)) !=1)
        { throwout(_("Name read Error!"));
         fclose(kfp);
         if(S_FIL) lockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // lock keynamefile
         liberatekylist(keyno,ppt);
         return;
        }

    //make wxstring from buff
    hlp= wxString::FromAscii(buff);
    (*(ppt+keyno-1))->fullnam=hlp;

        if( (lbl=fscanf(kfp," DomainName: %s ",buff)) !=1)
        { throwout(_("Domain read Error!"));
         fclose(kfp);
         if(S_FIL) lockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // lock keynamefile
         liberatekylist(keyno,ppt);
           return;
        }

    //make wxstring from buff
    hlp= wxString::FromAscii(buff);
    (*(ppt+keyno-1))->domnam= hlp;


        if( (lbl=fscanf(kfp,"d: %s ",buff)) !=1 )
        { throwout(_("Private Key d: read Error!"));
            fclose(kfp);
            if(S_FIL) lockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // lock keynamefile
            liberatekylist(keyno,ppt);
            return;
        }

    // d: in den key schreiben
    hlp=wxString::FromAscii(buff);
    if( !(((*(ppt+keyno-1))->d).storhex(&hlp))){throwout(_("error reading Key d")); fclose(kfp);
         if(S_FIL) lockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // lock keynamefile
         liberatekylist(keyno,ppt);
         return;}
    (*(ppt+keyno-1))->d.setsize(); (*(ppt+keyno-1))->d.shrinktofit();

        }
    } while( true);
    fclose(kfp);
   //jetzt sollte die Liste komplett sein
    kfp=fopen("secrets/ell_Keyfile.kyf","w");
    knfp=fopen("secrets/ell_knamfile.knf","w");

    del_id=(*(ppt+indx))->id;  //wird hier noch nicht benutzt, aber spaeter vielleicht nach sortierung etc.
    for(i=0;i<keyno;i++)
    {
       if(i==indx) continue; //wenns der zu loeschende ist, ueberspringen
       //sonst einfach alle rausschreiben
       lbl=fprintf(knfp,"id: %s  Name: %s  \n",(const char*)( (*(ppt+i))->id).mb_str(wxConvUTF8),
                  (const char*)((*(ppt+i))->fullnam).mb_str(wxConvUTF8));
       lbl=fprintf(kfp,"id: %s  Name: %s DomainName: %s\n",(const char*)((*(ppt+i))->id).mb_str(wxConvUTF8),
                  (const char*)((*(ppt+i))->fullnam).mb_str(wxConvUTF8),(const char*)((*(ppt+i))->domnam).mb_str(wxConvUTF8) );
      ((*(ppt+i))->d).writehex(&txa);
      lbl=fprintf(kfp,"d: %s  \n \n", (const char*)txa.mb_str(wxConvUTF8));
    }
    fclose(knfp); fclose(kfp);
    if(S_FIL) lockinplace(sec_path + _("/ell_Keyfile.kyf"),&zugang); // lock keynamefile
    if(S_FIL) lockinplace(sec_path + _("/ell_knamfile.knf"),&zugang); // lock keynamefile
    liberatekylist(keyno,ppt);
    EndModal(1);
}
