/*
 *   Copyright (C) 2011-2019, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#ifndef HELPERS_H
#define HELPERS_H

#include "dolonu.h"

#ifndef __cplusplus
#define __cplusplus
#endif

#include "sha2.h"
#include "sha4.h"
#include "aes.h"
//#include "elliptic1.h"

/*********** security hilfsfuns ***************/
/**********************************************/
bool arm();
bool unarm();
bool checkarm();
//meine anderen Hilfsfuns
/************************************************/
class rsakey
{
    public:
    rsakey(); //constructor
    rsakey(wxString id, wxString name, unsigned int blsiz, longnumber *e, longnumber *n); //ext constructor
    rsakey(wxString id, wxString name, unsigned int blsiz, longnumber *e, longnumber *n,longnumber *d); // full constructor
    rsakey(wxString id, wxString name, unsigned int blsiz, longnumber *e, longnumber *p,longnumber *q, longnumber *d); // full constructor 2
    bool selftest(); //Selbsttest eines kompletten incl. privaten Schlüssels erfolgreich->type=2
    bool selftest_3(); //Selbsttest eines kompletten privaten Schlüssels incl. pq ->type=3
    unsigned int blsiz_check();
    void copykey(rsakey *well);
    bool exportpublicpart();

    ~rsakey(); //destructor

    char type; //0-unproven, 1-external, 2-full,icl. privkeys, 3- extended for efficient computing

    longnumber e,n; //public keys
    longnumber d, p,q,fi; //private key d, for efficiency p,q,fi
    unsigned int blosiz;
    wxString kid,rname,ver_webst;
};
/**************************************************************/
class memblo
{
    public:
        memblo(int size_of_blocks, int number_of_blocks);
        ~memblo();
        char* get_mb(int indx_of_block);
        bool reassgn(int size_of_blocks, int number_of_blocks);

        bool is_sound;
        char **ppmb;  //pointer to pointers
        int blono;  //blocksize
        int no_of_mb; //no of memblocks

};
/*******************************************************************/
bool lockinplace(wxString fnam, longnumber *keyadress, wxString algo=_("Fleas_1_8"), unsigned char shoprog=0);
//verschlüsselt file mit longnumber und loescht original
/*******************************************************************/
bool lockfile(wxString fnam, longnumber *keyadress, wxString algo=_("Fleas_1_8"), unsigned char shoprog=0);
//verschlüsselt file mit longnumber falls chiffre nicht da und loescht immer original
/***************************************************************/
bool unlockfile(wxString fnam, longnumber *keyadress, wxString algo=_("Fleas_1_8"), unsigned char shoprog=0);
//entschlüsselt file mit longnumber und loescht original
/***************************************************************/
bool unlockinplace(wxString fnam, longnumber *keyadress, wxString algo=_("Fleas_1_8"), unsigned char shoprog=0,bool del_ciph=true);
//entschlüsselt file mit longnumber und loescht original
/****************************************************************/
/*******************************************************************/
bool lockinplace_eax(wxString fnam, longnumber *keyadress, wxString algo=_("F_cnt_1b"), unsigned char shoprog=0);
//verschlüsselt file mit longnumber und loescht original
/***************************************************************/
bool unlockinplace_eax(wxString fnam, longnumber *keyadress, unsigned char shoprog=0, bool strict=true, bool del_ciph=true);
//entschlüsselt file mit longnumber und loescht original
/****************************************************************/
bool lockfile_eax(wxString fnam, longnumber *keyadress, wxString algo=_("F_cnt_1b"), unsigned char shoprog=0);
//verschlüsselt file mit longnumber falls chiffre nicht da und loescht original
/***************************************************************/
bool unlockfile_eax(wxString fnam, longnumber *keyadress, unsigned char shoprog=0, bool strict=true);
//entschlüsselt file mit longnumber und loescht chiffre nicht
/****************************************************************/


/**************************************************************/
inline unsigned char rotbyte(unsigned char byt, unsigned char rotval);
//rotiert ein byte um rotval nach oben
/**************************************************************/
inline ulong32 rot32(ulong32 val, unsigned char rotval);
//rotiert ein 32 bit int um rotval nach oben
/**************************************************/
bool bytinteg(int blolen, char* blo, int keylen, char* keytxt, unsigned char offs, unsigned char inc);
// integriert einmal rauf und einmal runter, add offset am Start und add inc bei jedem Schritt
// dient zum "entcodieren" von Textinfo
// dient auch zur Bitdispersion:Ändere ein Bit am Anfang -> beeinglusse jedes Byte
/**************************************************/
bool bytinteg(int blolen, char* blo, unsigned char offs, unsigned char inc);
//hier die variante ohne key
// integriert einmal rauf und einmal runter, add offset am Start und add inc bei jedem Schritt
// dient zum "entcodieren" von Textinfo
// dient auch zur Bitdispersion:Ändere ein Bit am Anfang -> beeinglusse jedes Byte
/**************************************************************/
void reverse_wxstring(wxString *);    //dreht die Zeichenfolge um
/**************************************************/
int throwout(wxString);    //liegt oben in helpers.cpp
int throwout(wxString,int seconds);    //liegt oben in helpers.cpp
/*********************************************/
bool erasieve(int possprim); //billiger Primzahltest
/*********************************************/
long double factorial(ulong32 n); //Fakultät
/*********************************************/
double foxes(double a, double xold); // Chaos fuer a >2.53
/*********************************************/
bool dofeistel(int bllen, int keylen, char* intxt,
               char* outxt, char* key, char frounds, int kangrounds, int cpa_blen=0, char* cpa_bl=NULL, wxString algo=_("Fleas_1_8"));
// Feistel Netzwerk Funktion macht neuen Block aus altem Block + key
//frounds=1,2,3 fur encipher, -1,-2,-3 für decipher
/*********************************************/
bool dofeistel_n(int bllen, int keylen, char* intxt,
               char* outxt, char* key, char frounds, int kangrounds, int cpa_blen=0, char* cpa_bl=NULL, unsigned int algocode=18);
// Feistel Netzwerk Funktion macht neuen Block aus altem Block + key
//frounds=1,2,3 fur encipher, -1,-2,-3 für decipher
/*********************************************/
/*********************************************/
bool roundfun(int bllen, int keylen, char* ptxt, char* key, int laps, int cpa_blen=0, char* cpa_bl=NULL, wxString algo=_("Fleas_1_8"));
// Rundenfunktion fürs Feistel Netzwerk
/*********************************************/
bool roundfun(int bllen, int keylen, char* ptxt, char* key, int laps, int cpa_blen=0, char* cpa_bl=NULL, unsigned int algoflag=0);
// overloaded Rundenfunktion fürs Feistel Netzwerk mit switch und Zahlencode für algorithmus
/*********************************************/
/*********************************************/
bool bytxor_128(int blolen, char* bladwell, char* pertxt, int rounds);
/*********************************************/
bool comblock(int blolen, char* bladwell, int rounds);
//Funktion setzt einen blolen großen Block in
//einen blolengroßen kreuz und quer xorten um, aufgeräumte Neuversion
/*********************************************/
bool comblock_128(int blolen, char* bladwell, int rounds);
/*********************************************/
bool bytxor(int blolen, char* bladwell, char* xortxt, int rounds);
//Funktion setzt einen blolen großen Block in
//einen blolengroßen kreuz und quer xorten um, aufgeräumte Neuversion
bool bytadd(int blolen, char* bladwell, char* pertxt, int rounds); //geglaettetes bytxor
bool bytadd_128(int blolen, char* bladwell, char* pertxt, int rounds); //ditto
bool bytadd_a(int blolen, char* bladwell, char* pertxt, int rounds, int spice=1, char fleareps=3); //optimiertes bytxor
//neue statistisch optimierte, "gewürzte" und erweiterte Variante
bool bytadd_a_128(int blolen, char* bladwell, char* pertxt, int rounds, int spice=1, char fleareps=3); //optimiertes bytxor
bool dbytadd_a(int blolen, char* bladwell, char* pertxt, int rounds, int spice=1, double fleareps=1.5); //optimiertes bytxor
//neue statistisch optimierte, "gewürzte" und erweiterte Variante
bool dbytadd_a_l(ulong32 blolen, char* bladwell,  char* pertxt, int rounds, int spice, double fr=1); //fuer extra lange bloecke
bool dbytadd_ax(int blolen, char* bladwell, char* pertxt, int rounds, int spice=1, double fleareps=1.5); //Variante für 4byte blocks, has excess allocation zeroed already
bool dbytadd_ay(int blolen, char* bladwell, char* pertxt, int rounds, int spice=1, double fleareps=1.5); //Variante für 4byte blocks, has excess allocation zeroed already
bool dbytadd_a_128(int blolen, char* bladwell, char* pertxt, int rounds, int spice=1, double fleareps=1.5); //optimiertes bytxor
/*********************************************/
bool bytperm(int blolen, char* bladwell, char* pertxt, int rounds);
//Funktion setzt einen blolen großen Block in
//einen blolengroßen Permutationsarray um, aufgeräumte Neuversion
bool bytperm_128(int blolen, char* bladwell, char* pertxt, int rounds);
//Schnellversion für 128 lockgroesse/
bool bytmult_128(int blolen, char* bladwell, char* pertxt, int rounds);
//neue entwanzte variante von bytperm_128
bool bytmult(int blolen, char* bladwell, char* pertxt, int rounds);
//neue entwanzte variante von bytperm
bool bytmult_a(int blolen, char* bladwell, char* pertxt, int rounds, int spice=1, char fleareps = 3);
//neue statistisch optimierte "gewürzte" und erweiterte variante
bool bytmult_a_128(int blolen, char* bladwell, char* pertxt, int rounds, int spice=1, char fleareps = 3);
//neue statistisch optimierte "gewürzte" und erweiterte variante
bool bbytmult_a(int blolen, char* bladwell, char* pertxt, int rounds, int spice=1, double fleareps = 1.5);
//neue statistisch optimierte "gewürzte" und erweiterte variante
bool bbytmult_ax(int blolen, char* bladwell, char* pertxt, int rounds, int spice=1, double fleareps = 1.5);
//4byte unit variant, has excess allocation zeroed already
bool bbytmult_a_128(int blolen, char* bladwell, char* pertxt, int rounds, int spice=1, double fleareps = 1.5);
//neue statistisch optimierte "gewürzte" und erweiterte variante
/***************************************************/
bool develop_a( char* ad, int blolen, int rounds); //neue develop-funktion p1:integ,bytxor,comblock p2:comblock,bytxor,integ
bool develop_b( char* ad, int blolen, int rounds); //p1:perm, p2:xor
bool develop_c( char* ad, int blolen, int rounds); //p1:xor, p2:perm
bool develop_d( char* ad, int blolen, int rounds); //p1:perm, p2: perm
bool develop_e( char* ad, int blolen, int rounds); //neue develop-funktion
bool develop_f( char* ad, int blolen, int rounds); //neue develop-funktion
bool develop_x( char* ad, int blolen, int rounds, int paths); //neue develop-funktion
bool develop_x1( char* ad, int blolen, int rounds, int paths); //neue develop-funktion
bool develop_l( char* ad, int blolen, int rounds,memblo *memblo_pt=NULL); //brand new LEAN! developer
bool co_develop_l( char* ad, int blolen, char* coad, int colen, int rounds); //brand new LEAN! co_developer
bool develop_ls( char* ad, int blolen, int rounds, int paths, unsigned char spice, unsigned char inc=1);
bool develop_ls2( char* ad, int blolen, int rounds, int paths, unsigned char spice, unsigned char inc=1);
bool co_develop_ls( char* ad, int blolen, char* coad, int colen, int rounds, int paths, unsigned char spice=1); //brand new LEAN! co_developer
bool develop_ln( char* ad, int blolen, int rounds, int paths, unsigned char spice, unsigned char inc=1);
bool co_develop_ln( char* ad, int blolen, char* coad, int colen, int rounds, int paths, unsigned char spice=1); //brand new LEAN! co_developer
bool develop_ln2( char* ad, int blolen, int rounds, int paths, unsigned char spice, unsigned char inc=1); //brand new LEAN! developer
bool develop_ln2_mt( char* ad, int blolen, int rounds, int paths, unsigned char spice, unsigned char inc=1); //brand new LEAN! developer
bool co_develop_ln2( char* ad, int blolen, char* coad, int colen, int rounds, int paths, unsigned char spice=1); //brand new LEAN! co_developer
bool develop_flight( char* ad, int blolen, unsigned char spice = 1);
bool develop_flightx( char* ad, int blolen, unsigned char spice = 1,float intensity=1.5);
bool develop_longblock( char* ad, ulong32 blolen, unsigned char spice=1);

bool develop_flightx_onearm( char* ad, int blolen, unsigned char spice=1);
//p1: intg,bytperm,comblock,  p2: comblock,bytperm,integ, xor together
bool develop_o( char* ad, int blolen, int rounds, int paths,char alg_flag=0); //brand new developer
//path: integrate, [bytadd_a], [bytmult_a], comblock, spiced with path number
//one of add and mult can be opted out by setting alg_flag
//algflag 0: bytadd_a solo,  algflag 1: bytmulta_solo, algflag 2 or other: both algorithms

char * develop_b_malloc(int blolen, char* bladwell, int rounds, int outlen);
char * develop_l_malloc(int blolen, char* bladwell, int rounds, int outlen);//brand new lean!
char * develop_x_malloc(int blolen, char* bladwell, int rounds, int paths, int outlen);
char * develop_o_malloc(int blolen, char* bladwell, int rounds, int paths, int outlen,char alg_flag=0);
// Funktion mixert und permutiert den block massiv durch
// output erfolgt in der Länge outlen,

bool k_develop_a( char* ad, int blolen, char* ky, int kylen, int rounds); //neue develop-funktion p1:integ,bytxor,comblock p2:comblock,bytxor,integ
bool k_develop_b( char* ad, int blolen, char* ky, int kylen, int rounds); //p1:perm, p2:xor
bool k_develop_c( char* ad, int blolen, char* ky, int kylen, int rounds); //p1:xor, p2:perm
bool k_develop_d( char* ad, int blolen, char* ky, int kylen, int rounds); //p1:perm, p2: perm

bool k_develop_b_f3(int blolen, char* bladwell, int keylen, char* keytxt, int rounds, unsigned int cagesize,int cpa_blen=0, char* cpa_bl=NULL);
// Funktion mixert und permutiert den block massiv durch mit keyblock
//jetzt wird der keyblock auch im Algorithmus verwendet, um stärker zu verschlüsseln

bool k_develop_f4(int blolen, char* bladwell, int cpa_blen, char* cpa_bl, int keylen, char* keytxt, int rounds, int algonum=0, memblo* mb=NULL );
//flexible keyed propagator, should be fed a cpa_bl of length blolen
/*********************************************/
bool bytxor_x1_128(int blolen, char* bladwell, char* pertxt, int rounds);
/*********************************************/
bool bytxor_x1(int blolen, char* bladwell, char* xortxt, int rounds);
//Funktion setzt einen blolen großen Block in
//einen blolengroßen kreuz und quer xorten um, aufgeräumte Neuversion
/*********************************************/
bool bytxor_x2(int blolen, char* bladwell, char* xortxt,int keylen, char* keytxt, int rounds);
//Funktion setzt einen blolen großen Block in
//einen blolengroßen kreuz und quer xorten um, aufgeräumte Neuversion
// jetzt mit keybeteiligung
/**************************************************************/
bool getsignature(wxString fnam, longnumber* signo, int blocksize=65);
/**************************************************************/
/**************************************************************/
/**************************************************************/
bool kbytmixx(int blolen, char* bladwell, char* pertxt, int keylen, char* keytxt, int rounds);
// Funktion mixert und permutiert den block massiv durch mit keyblock
// keyblock mnuss gleiches format haben(blolen) wie die anderen
/**************************************************************/
bool kbytmixx2(int blolen, char* bladwell, char* pertxt, int keylen, char* keytxt, int rounds=1, unsigned int cagesize=20,int cpa_blockerlen=0, char* cpa_blocker=NULL);
// Funktion mixert und permutiert den block massiv durch mit keyblock
// keyblock mnuss gleiches format haben(blolen) wie die anderen, ausser keytxt
//jetzt wird der keyblock auch im Algorithmus verwendet, um stärker zu verschlüsseln
/**************************************************************/
bool bytmixx(int blolen, char* bladwell, char* pertxt, int rounds);
// Funktion mixert und permutiert den block massiv durch
// verwendet dabei im Wechsel bytxor und bytperm
/*********************************************/
bool bytmixx_d(int blolen, char* bladwell, char* pertxt, int rounds);
// Funktion mixert und permutiert den block massiv durch
// verwendet dabei im Wechsel bytxor und bytperm
/*********************************************/
/**************************************************************/
char * bytmixxmalloc(int blolen, char* bladwell, int rounds, int outlen);
// Funktion mixert und permutiert den block massiv durch
// output erfolgt in der Länge outlen,
/*********************************************/
bool bytperm_x1(int blolen, char* bladwell, char* pertxt, int rounds);
//Funktion setzt einen blolen großen Block in
//einen blolengroßen Permutationsarray um, aufgeräumte Neuversion
bool bytperm_x1_128(int blolen, char* bladwell, char* pertxt, int rounds);
//Schnellversion für 128 lockgroesse/
/*********************************************/
bool bytperm_x2(int blolen, char* bladwell, char* pertxt,int keylen, char* keytxt, int rounds);
//Funktion setzt einen blolen großen Block in
//einen blolengroßen Permutationsarray um, aufgeräumte Neuversion
/*********************************************/
/*********************************************/
float diffalzbytejump(int blolen,int inbit,
        int outbit,int tries,float *inave, float *outave);
// Differenzielle Cryptoanalyse von bytejump
// bzgl inbit und outbit return-> correlation coefficient
// nach inave wird der inaverage geschrieben out ditto
/*********************************************/
/*********************************************/
bool getbit(char* blad, ulong32 ind);
//Funktion gibt den Wert des ind´ten bits zurück
/****************************************/
bool flipbit(char* blad, ulong32 ind);
//Funktion flippt den Wert des ind´ten bits, neu-> zurück
/****************************************/
void setbit(char* blad, ulong32 ind, bool val);
//Funktion gibt den Wert des ind´ten bits zurück
/****************************************/
void recodebits(char* blad, ulong32 bitno);
//Funktion recodiert bis bitno nach:
//1.bit bleibt, unverändert gegen letztes ->1 (sonst 0)
/****************************************/
unsigned int getnum(char* blad, ulong32 maxbytes, ulong32 indx,char bitzahl=16);
//holt eine referenzzahl durch wildes auslesen im bitraster
/***********************************************************/
bool encipher_file_cntmode(char* fnam, char* key, int keylen, int k_steps, int blolen, int mode, wxString algo, unsigned char shoprog);
//k_steps: number of owf-steps,   mode:0-clear number, 1number of lonulock steps for number
bool encipher_file_threefish(char* fnam, char* key, int keylen, int k_steps, int blolen, int mode, wxString algo, unsigned char shoprog);
//mirror version for threefish (countermode)
bool encipher_file_fleafish(char* fnam, char* key, int keylen, int k_steps, int blolen, int mode, wxString algo, unsigned char shoprog);

/**********************************************/
bool encipher_pair(wxString appendto, wxString header1, wxString plainwxfile, char* key, int keylen, char feistelsteps, int kangoroohsteps, int d_blolen,int mode=1, wxString algo=_("Fleas_1_8"),unsigned char shoprog=0);
/***********************************************************************/
bool encipher_file_cntmode_mt(char* fnam, char* key, int keylen, int k_steps, int blolen, int mode, wxString algo, unsigned char shoprog);
//k_steps: number of owf-steps,   mode:0-clear number, 1number of lonulock steps for number
/****************************************/
bool encipher_cnt_pair(wxString appendto, wxString header1, wxString plainwxfile, char* key, int keylen, char feistelsteps, int kangoroohsteps, int d_blolen,int mode=1, wxString algo=_("Fleas_1_8"),unsigned char shoprog=0);
bool encipher_cnt_pair_mono(wxString appendto, wxString header1, wxString plainwxfile, char* key, int keylen, int k_steps, int blolen,int mode=1, wxString algo=_("Fleas_1_8"),unsigned char shoprog=0);
/***********************************************************************/
int eax_enc_file(wxString fnam, wxString outnam, char* key, int keylen, wxString algo=_("Fleas_lc"),unsigned char shoprog=0);
int eax_dec_file(wxString fnam, wxString outnam,char* key, int keylen,unsigned char shoprog=0, bool strict=true);
/****************************************/
bool encipher_file(char* fnam, char* key, int keylen, char feistelsteps, int kangoroohsteps, int d_blolen,int mode=1, wxString algo=_("Fleas_1_8"),unsigned char shoprog=0);
// verschlüsselt ein File mit key mode 0 ECB, 1 CBC
/****************************************/
bool decipher_file(char* fnam, char* key, int keylen, char feistelsteps, int kangoroohsteps, int d_blolen, int mode=1, wxString algo=_("Fleas_1_8"),unsigned char shoprog=0);
// entschlüsselt ein File mit key
/**************************************************************/
bool decipher_file_cntmode(ulong32 deadhead, char* fnam, char* key, int keylen, int k_steps, int blolen, int mode, wxString algo, unsigned char shoprog);
//k_steps: number of owf-steps,   mode:0-clear number, 1number of lonulock steps for number
bool decipher_file_threefish(ulong32 deadhead, char* fnam, char* key, int keylen, int k_steps, int blolen, int mode, wxString algo, unsigned char shoprog);
// threefish mirror version
bool decipher_file_fleafish(ulong32 deadhead, char* fnam, char* key, int keylen, int k_steps, int blolen, int mode, wxString algo, unsigned char shoprog);
/**************************************************************/
bool decipher_file_cntmode_mt(ulong32 deadhead, char* fnam, char* key, int keylen, int k_steps, int blolen, int mode, wxString algo, unsigned char shoprog);
//k_steps: number of owf-steps,   mode:0-clear number, 1number of lonulock steps for number

/*********************************************/
bool decipher_file_cntmode_mt(ulong32 deadhead, char* fnam, char * plainname, char* key, int keylen, int k_steps, int blolen, int mode, wxString algo, unsigned char shoprog);
//k_steps: number of owf-steps,   mode:0-clear number, 1number of lonulock steps for number
// with explicit plaintext nam
/****************************************************/
bool decipher_file_cntmode_mt4ecc(ulong32 deadhead, wxString cnam, wxString* pnampt, char* key, int keylen, int k_steps, int blolen, int mode, wxString algo, unsigned char shoprog);
//nightmarish spaghetti to do head cutting and interpretation all in one
/**************************************************************/
bool decipher_file_cntmode_4ecc(ulong32 deadhead, wxString cnam, wxString* pnampt, char* key, int keylen, int k_steps, int blolen, int mode, wxString algo, unsigned char shoprog);
//k_steps: number of owf-steps,   mode:0-clear number, 1number of lonulock steps for number
/*********************************************/
bool dec_fil(ulong32 deadhead, char* fnam, char* pnam, char* key, int keylen, char feistelsteps, int kangoroohsteps, int d_blolen, int mode=1, wxString algo=_("Fleas_1_8"),unsigned char shoprog=0);
//neue entschl-version für dead-header und beliebige namen
/******************************************************************************/
bool dec_fil_4ecc(ulong32 deadhead, wxString cnam, wxString* pnampt, char* key, int keylen, char feistelsteps, int kangoroohsteps, int d_blolen, int mode=1, wxString algo=_("Fleas_1_8"),unsigned char shoprog=0);
//entschl-hub für dead-header und one pass ecc entschluesselung
/******************************************************************************/
bool rsa_encipher_file(char* fnam, rsakey* rsak, char feistelsteps, int k_steps, int blolen);
// verschlüsselt ein File mit dem RSA Verfahren
// wahre Blocklänge 2*blolen, blolen muss größer 25 sein
// alte filelänge long len wird vorangestellt
/**************************************************************/
/****************************************/
bool rsa_decipher_file(char* fnam, rsakey *rsak,  char feistelsteps, int ksteps, int blolen);
// entschlüsselt ein File mit dem rsa-Verfahren nach aktuellem Schlüssel
// wahre Blocklänge 2*blolen
// alte filelänge wird vorangestellt len: long
/**************************************************/
/**************************************************/
bool storrsig(wxString fnam,longnumber * psig, rsakey* pkey, int sigsiz);
/**************************************************/
int prep_rsa(longnumber *pln, int rsa_len, int padsiz=2);
  //prepariert formatinformation(=size) vorne dran, setzt die letzten 2 bytes jedes blockes mit zufallszahlen und füllt ab size mit Zufallszahlen auf
  // gib Blockzahl zurueck(-1 bei error)
/**************************************************/
ulong32 clean_rsa(longnumber *pln,int rsa_len, int padsiz=2);
  //prepariert longnumber zurueck und returned den alten wert "size"
/**************************************************/
bool enciph_d_rsa(longnumber *pln,rsakey *ky);
  //prepariert und vermuckelt alle bloecke, aendert lonu in rsa_cipher
/**************************************************/
bool deciph_e_rsa(longnumber *pln,rsakey *ky);
  //rueckmuckelt alle Bloecke und putzt auf Ursprungsformat, icl. shrinktofit
//neue Chiffriermodule END
/**************************************************/
bool get_hash_from_filename(wxString *hstr, wxString *pfnam,int preflag=1, bool mss=true);
//hashwert bestimmen und nach *hstr schreiben
/***************************************************/
bool get_lonu_hash_from_filename(longnumber *ph, wxString *pfnam, unsigned int blono, bool mss=true, int deadhead=0);
//hashwert bestimmen und binär nach *ph schreiben
/***************************************************/
/***************************************************/
bool get_lonu_hash_from_filename_3(longnumber *ph, wxString *pfnam, unsigned int blono, bool mss=true,  int deadhead=0);
//hashwert bestimmen und binär nach *ph schreiben
/***************************************************/
bool get_lonu_hash_from_filename_4(longnumber *ph, wxString *pfnam, unsigned int blono, bool mss=true,  int deadhead=0);
/***************************************************/
bool get_lonu_hash_from_filename_5(longnumber *ph, wxString *pfnam, unsigned int blono,bool shobar=true,  int deadhead=0);
/***************************************************/
bool get_lonu_hash_from_filename_x(longnumber *ph, wxString *pfnam, unsigned int blono, wxString algo,bool shobar=true, int deadhead=0);

/***************************************************
bool get_lonu_JH_from_filename2(longnumber *ph, wxString *pfnam, int rhlen, bool mss=true, int deadhead=0);
***************************************************/
unsigned int JH_from_file(unsigned int rhlen, char* fnambuff, char* rhbuff, int deadhead, unsigned int chunksize=4000 );
//above is used by below
/****************************************************************/
bool get_lonu_JH_from_filename(longnumber *ph, wxString *pfnam, int rhlen, bool mss=true, int deadhead=0);
/****************************************************************/
/* calculate JH HMAC type from file -> needs rh's header file*/
unsigned int JHMAC_from_file(longnumber *pk, unsigned int rhlen, char* fnambuff, char* rhbuff, int deadhead,  unsigned int chunksize=4000 );
/****************************************************************/
bool get_lonu_JHMAC_from_filename(longnumber *ph, longnumber *pk, wxString *pfnam, int rhlen_b,  bool mss=true, int deadhead=0);
/***************************************************/

bool get_lonu_skein1024_from_filename(longnumber *ph, wxString *pfnam, bool mss=true, int deadhead=0);
/***************************************************/
bool get_lonu_skein1024_mac_from_filename(longnumber *ph, wxString *pfnam, unsigned int keylen, char *key, bool mss=true, int deadhead=0);
/***************************************************/
unsigned int skein1024_from_file( wxString* pfnam, char* skbuff, int deadhead=0, unsigned int chunksize=4000, bool shobar=true );
/***************************************************/
unsigned int skein1024_mac_from_file( char* fnambuff, char* skbuff, unsigned int keylen, char *key, int deadhead=0, unsigned int chunksize=4000 );
/***************************************************/
bool get_lonu_sha2_from_filename(longnumber *ph, wxString *pfnam, int shalen=256, bool mss=true, int deadhead=0);
//hashwert bestimmen und binär nach *ph schreiben, bei shalen 256 -> sha2, bei 512 -> sha4
/**********************************************************/
bool get_lonu_hmac_from_filename_x(longnumber *ph, wxString *pfnam, longnumber *pky, unsigned int blono, wxString algo, bool shobar, int deadhead=0);
//HMAC bestimmen
/*******************************************************************/
bool get_lonu_sha2_HMAC_from_filename(longnumber *ph, wxString *pfnam, longnumber *pky, int shalen, bool mss, int deadhead=0);


/***************************************************/

int read_hex_bytes_from_file(FILE* fp, unsigned char* buffer, int maxbytes);
// maximal maxbytes leerzeichengetrennte Hex-bytes von einem File lesen und in den buffer hineinschreiben
/*****************************************************/
char konv_lett_to_hex(unsigned char lett);
// letter in eine hexzahl umwandeln
/***************************************************/
bool ispowof2(int blolen);
// check auf power of two
/**********************************************************/
bool name_enciph(wxString ofnam, longnumber* pky,wxString* pnn=NULL);
//neuen filenamen generieren und bei *cryptnam ablegen
/**********************************************************/
bool name_deciph(wxString ofnam,  longnumber* pky);
bool testrenaming();
/****************************************************************/
bool file_pos_past(wxString fnam, wxString terminator, ulong32 *firstpast, ulong32 maxcount=1000);
//report first ocurrence of terminator and deposit first position past in *firstpast
//check till maxcount, return true on found, false on not found til maxcount
/****************************************************************/
bool file_pos_past2(wxString fnam, wxString terminator, ulong32 *firstpast, ulong32 maxcount=1000);
//report first ocurrence of terminator and deposit first position past in *firstpast
//check till maxcount, return true on found, false on not found til maxcount
/***********************************************************/
bool splicefile(wxString o_nam, wxString fnam1, wxString fnam2, wxString terminator);
//splice file o_nam into fnam1 and fnam2, cutmark is terminator which is discarded
bool splicefile(wxString o_nam, wxString fnam1, wxString fnam2, wxString terminator1, wxString restarter);
//splice file o_nam into fnam1 and fnam2, cutmark1 is head-terminator which is discarded. cutmark2 is tail-restarter, also discarded
/*************************************************************************************/
bool fileconcat(wxString fn1, wxString fn2, wxString outnam);
bool fileconcat(wxString fn1, wxString fn2, wxString outnam, wxString stopsig, ulong32 decoy=0);//includes a stop marker between files
//does what name tells, returns true on success
/*********************************************************/
bool filetrunc_head(wxString fn1, unsigned int hedlen);  //head-truncate file itself
bool maketrunc_head(wxString fn_in, wxString fn_out, unsigned int hedlen);   //produce headtruncated copy
/*************************************************************************************/
bool eval_freq_list(ulong32 *oa, float *pchi, float *pbpb);
//oa is pointerarray (256 els) to put frequencies in, targetno is expected hitno, blocksize, Testtype sets testtype
/************************************************************/
bool counter_chain_freq(ulong32 *oa, ulong32 targetno, int blsiz, wxString tt, int rounds);
//oa is pointerarray (256 els) to put frequencies in, targetno is expected hitno, blocksize, Testtype sets testty
/***********************************************************************/
int splitstring(wxString in, wxArrayString *p_out, wxChar sep);
//separates in into return value outstrings with sep as separator, deleted in out-array
/******************************************************************/
bool mac_from_file(longnumber *ph, wxString *pfnam, longnumber *lonukey, wxString hash_algo=_("Fleas_lx"),wxString ciph_algo=_("Fleas_ls") );
//does what it says, calculates a MAC from a file and deposits it in *ph
/********************************************************************/
bool make_mac_file(longnumber *pkey, wxString *pfnam, wxString h_algo=_("Fleas_lx"), wxString c_algo=_("Fleas_ls") );
//does what it says, writes a mac file
/**********************************************************************/
bool check_mac(longnumber *pky, wxString fnam, wxString macnam=_("default"), bool stumm=false);
//does what it says
/*******************************************************/
unsigned int get_code_4_algo(wxString algo);
//gets the number code for a named algorithm for faster roundfunction
/*********************************************************/
int keyid_free(wxString nknam, bool verbose);
//returns bit 0 set if private present, bit 1 set if public, -1 on error
/**************************************************************/
bool pub_keyid_free(wxString nknam, bool verbose);
/**************************************************************/
bool priv_keyid_free(wxString nknam, bool verbose);
/**************************************************************/
bool extr_initials(wxString *pinstr, wxString *poutstr);
/**************************************************************/

#endif
