/*
 *   Copyright (C) 2011-2012, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#ifndef GNUPG_SIGN_H
#define GNUPG_SIGN_H

//(*Headers(gnupg_sign)
#include <wx/dialog.h>
#include <wx/sizer.h>
#include <wx/button.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/timer.h>
//*)

class gnupg_sign: public wxDialog
{
	public:

		gnupg_sign(wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		virtual ~gnupg_sign();

		//(*Declarations(gnupg_sign)
		wxTextCtrl* kyinf_ctrl;
		wxButton* Button4;
		wxButton* Button1;
		wxButton* Button2;
		wxButton* Button3;
		wxStaticText* StaticText1;
		wxTimer Timer1;
		wxStaticText* StaticText3;
		wxTextCtrl* signam_ctrl;
		wxStaticText* StaticText4;
		wxStaticText* StaticText5;
		wxStaticText* StaticText2;
		wxTextCtrl* kyid_ctrl;
		wxTextCtrl* fnam_ctrl;
		//*)

	protected:

		//(*Identifiers(gnupg_sign)
		static const long ID_BUTTON3;
		static const long ID_STATICTEXT1;
		static const long ID_STATICTEXT2;
		static const long ID_STATICTEXT3;
		static const long ID_TEXTCTRL1;
		static const long ID_TEXTCTRL2;
		static const long ID_BUTTON1;
		static const long ID_STATICTEXT4;
		static const long ID_TEXTCTRL3;
		static const long ID_BUTTON2;
		static const long ID_STATICTEXT5;
		static const long ID_TEXTCTRL6;
		static const long ID_BUTTON4;
		static const long ID_TIMER1;
		//*)

	private:

		//(*Handlers(gnupg_sign)
		void OnExit(wxCommandEvent& event);
		void OnSelectKey(wxCommandEvent& event);
		void OnSelectFile(wxCommandEvent& event);
		void OnDoSign(wxCommandEvent& event);
		void OnTimer1Trigger(wxTimerEvent& event);
		//*)

		bool tellerror;


		DECLARE_EVENT_TABLE()
};

#endif
