/*
 *   Copyright (C) 2011-2016, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
 

#ifndef TIMSTAMP_H
#define TIMSTAMP_H

//(*Headers(timstamp)
#include <wx/dialog.h>
#include <wx/sizer.h>
#include <wx/button.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/choice.h>
#include <wx/timer.h>
//*)

#include <wx/datetime.h>

class timstamp: public wxDialog
{
	public:

		timstamp(wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		virtual ~timstamp();

		//(*Declarations(timstamp)
		wxTextCtrl* cli_nam_ctrl;
		wxButton* Button4;
		wxButton* Button1;
		wxTextCtrl* kydom_ctrl;
		wxButton* Button2;
		wxTextCtrl* tim_inf_ctrl;
		wxButton* Button3;
		wxStaticText* StaticText1;
		wxStaticText* StaticText10;
		wxTimer Timer1;
		wxTextCtrl* tim_sig_fil_ctrl;
		wxStaticText* StaticText3;
		wxTextCtrl* comment_ctrl;
		wxChoice* Choice1;
		wxButton* Button5;
		wxStaticText* StaticText8;
		wxStaticText* StaticText7;
		wxTextCtrl* stmpee_ctrl;
		wxTextCtrl* ky_fullnam_ctrl;
		wxStaticText* StaticText4;
		wxStaticText* StaticText5;
		wxStaticText* StaticText2;
		wxStaticText* StaticText6;
		wxTextCtrl* currdom_ctrl;
		wxTextCtrl* zone_ctrl;
		wxStaticText* StaticText9;
		wxTextCtrl* kyid_ctrl;
		wxStaticText* StaticText11;
		//*)

	protected:

		//(*Identifiers(timstamp)
		static const long ID_BUTTON1;
		static const long ID_STATICTEXT1;
		static const long ID_STATICTEXT2;
		static const long ID_STAMPEE_CTRL;
		static const long ID_BUTTON3;
		static const long ID_STATICTEXT5;
		static const long ID_TIM_SIG_FIL_CTRL;
		static const long ID_STATICTEXT3;
		static const long ID_TIM_INF_CTRL;
		static const long ID_BUTTON4;
		static const long ID_STATICTEXT10;
		static const long ID_CLI_NAM;
		static const long ID_STATICTEXT4;
		static const long ID_STATICTEXT11;
		static const long ID_COMM_CTRL;
		static const long ID_TEXTCTRL3;
		static const long ID_STATICTEXT6;
		static const long ID_BUTTON5;
		static const long ID_STATICTEXT9;
		static const long ID_KYID_CTRL;
		static const long ID_KYFULLNAM_CTRL;
		static const long ID_CHOICE1;
		static const long ID_STATICTEXT7;
		static const long ID_BUTTON2;
		static const long ID_STATICTEXT8;
		static const long ID_TEXTCTRL1;
		static const long ID_TEXTCTRL2;
		static const long ID_TIMER1;
		//*)

		wxString fnam;
        wxString tstring;
        wxString client;
        wxString hash;
        wxString timefile;


	private:

		//(*Handlers(timstamp)
		void OnCancel(wxCommandEvent& event);
		void OnSelect_stampee(wxCommandEvent& event);
		void On_Refresh_Timing(wxCommandEvent& event);
		void MakeDateFile();
		void OnTimer(wxTimerEvent& event);
		void OnStamp(wxCommandEvent& event);
		void OnSelPriv(wxCommandEvent& event);
		void OnChangeClient(wxCommandEvent& event);
		//*)
		int half_min_counter;
		bool nostop;
		bool keyselected;
		wxDateTime jetzt;
		
		void OnDropFile(wxDropFilesEvent& event);
        bool drop_succ;  //provide Feedback


		DECLARE_EVENT_TABLE()
};

#endif
