/*
 *   Copyright (C) 2011-2016, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
 

#ifndef TIME_VERIFY_H
#define TIME_VERIFY_H

#include <wx/filedlg.h>
#include <wx/filename.h>
#include <wx/file.h>
#include <wx/colour.h>

//(*Headers(time_verify)
#include <wx/sizer.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/button.h>
#include <wx/dialog.h>
#include <wx/timer.h>
//*)

#include "elliptic1.h"

class time_verify: public wxDialog
{
	public:

		time_verify(wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		virtual ~time_verify();

		//(*Declarations(time_verify)
		wxStaticText* StaticText9;
		wxStaticText* StaticText2;
		wxTextCtrl* tim_inf_ctrl;
		wxButton* Button1;
		wxStaticText* StaticText6;
		wxStaticText* StaticText8;
		wxTextCtrl* ssignam_ctrl;
		wxStaticText* StaticText1;
		wxStaticText* StaticText3;
		wxButton* Button2;
		wxButton* Button5;
		wxTextCtrl* stmpee_ctrl;
		wxButton* Button3;
		wxStaticText* StaticText5;
		wxStaticText* StaticText7;
		wxTextCtrl* eval_ctrl;
		wxTextCtrl* tim_sig_fil_ctrl;
		wxTextCtrl* currdom_ctrl;
		wxTextCtrl* kydom_ctrl;
		wxTextCtrl* kyid_ctrl;
		wxTextCtrl* ky_fullnam_ctrl;
		wxStaticText* StaticText4;
		wxTimer Timer1;
		//*)

        wxColor redcol,grencol,neutcol;


	protected:

		//(*Identifiers(time_verify)
		static const long ID_BUTTON1;
		static const long ID_STATICTEXT1;
		static const long ID_STATICTEXT2;
		static const long ID_STAMPEE_CTRL;
		static const long ID_BUTTON3;
		static const long ID_STATICTEXT5;
		static const long ID_TIM_SIG_FIL_CTRL;
		static const long ID_STATICTEXT4;
		static const long ID_STATICTEXT3;
		static const long ID_TIM_INF_CTRL;
		static const long ID_TEXTCTRL3;
		static const long ID_BUTTON5;
		static const long ID_STATICTEXT6;
		static const long ID_STATICTEXT7;
		static const long ID_KYID_CTRL;
		static const long ID_KYFULLNAM_CTRL;
		static const long ID_TEXTCTRL1;
		static const long ID_BUTTON2;
		static const long ID_STATICTEXT8;
		static const long ID_STATICTEXT9;
		static const long ID_EVALCTRL;
		static const long ID_TEXTCTRL2;
		static const long ID_TIMER1;
		//*)

	private:

		//(*Handlers(time_verify)
		void OnExit(wxCommandEvent& event);
		void DoVerify(wxCommandEvent& event);
		void OnSelFile(wxCommandEvent& event);
		void OnTimer(wxTimerEvent& event);
		void OnSelPublic(wxCommandEvent& event);
		//*)


		int half_min_counter;
		bool nostop;
        wxString timefile,fnam;
		el_pub loky;
		
		void OnDropFile(wxDropFilesEvent& event);
        bool drop_succ;  //provide Feedback


		DECLARE_EVENT_TABLE()
};

#endif
