/*
 *   Copyright (C) 2011-2012, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#ifndef ELLIP_KY_SAV_H
#define ELLIP_KY_SAV_H

//(*Headers(ellip_ky_sav)
#include <wx/checkbox.h>
#include <wx/dialog.h>
#include <wx/sizer.h>
#include <wx/button.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/timer.h>
//*)


class ellip_ky_sav: public wxDialog
{
	public:

		ellip_ky_sav(wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		virtual ~ellip_ky_sav();

		//(*Declarations(ellip_ky_sav)
		wxTextCtrl* domnam_ctrl;
		wxTextCtrl* d_ctrl;
		wxTextCtrl* Ax_ctrl;
		wxButton* Button4;
		wxCheckBox* allDomains;
		wxButton* Button1;
		wxButton* Button2;
		wxButton* Button3;
		wxTextCtrl* id_ctrl;
		wxStaticText* StaticText1;
		wxStaticText* StaticText10;
		wxTimer Timer1;
		wxCheckBox* PubAlso;
		wxButton* Button8;
		wxStaticText* StaticText3;
		wxButton* Button5;
		wxStaticText* StaticText8;
		wxButton* Button9;
		wxStaticText* StaticText7;
		wxStaticText* StaticText4;
		wxStaticText* StaticText5;
		wxStaticText* StaticText2;
		wxTextCtrl* Ay_ctrl;
		wxStaticText* StaticText6;
		wxTextCtrl* fullname_ctrl;
		wxButton* Button7;
		wxTextCtrl* currdom_ctrl;
		wxStaticText* StaticText9;
		wxButton* Button6;
		wxButton* Button10;
		wxStaticText* StaticText11;
		//*)

	protected:

		//(*Identifiers(ellip_ky_sav)
		static const long ID_BUTTON1;
		static const long ID_STATICTEXT1;
		static const long ID_STATICTEXT11;
		static const long ID_STATICTEXT10;
		static const long ID_STATICTEXT2;
		static const long ID_TEXTCTRL1;
		static const long ID_STATICTEXT3;
		static const long ID_TEXTCTRL2;
		static const long ID_STATICTEXT4;
		static const long ID_TEXTCTRL3;
		static const long ID_STATICTEXT9;
		static const long ID_TEXTCTRL7;
		static const long ID_STATICTEXT5;
		static const long ID_TEXTCTRL4;
		static const long ID_BUTTON9;
		static const long ID_BUTTON6;
		static const long ID_BUTTON4;
		static const long ID_STATICTEXT6;
		static const long ID_STATICTEXT7;
		static const long ID_TEXTCTRL5;
		static const long ID_STATICTEXT8;
		static const long ID_TEXTCTRL6;
		static const long ID_BUTTON5;
		static const long ID_CHECKBOX1;
		static const long ID_BUTTON2;
		static const long ID_CHECKBOX2;
		static const long ID_BUTTON3;
		static const long ID_BUTTON8;
		static const long ID_BUTTON10;
		static const long ID_BUTTON7;
		static const long ID_TIMER1;
		//*)


	private:

		//(*Handlers(ellip_ky_sav)
		void OnCancel(wxCommandEvent& event);
		void OnStore(wxCommandEvent& event);
		void OnPublicElPartExport(wxCommandEvent& event);
		void On_A_refresh(wxCommandEvent& event);
		void OnMakeNewKey(wxCommandEvent& event);
		void OnLoadFromFile(wxCommandEvent& event);
		void OnExportSecret(wxCommandEvent& event);
		void OnImportprivkey(wxCommandEvent& event);
		void OnTimer1Trigger(wxTimerEvent& event);
		void OnShowprivkey(wxCommandEvent& event);
		void OnMakePubEntry(wxCommandEvent& event);
		//*)

        int half_min_counter;
        bool nostop;
        bool alldomains;
        int elfl;
        ellipse locell;
        wxString idext;
        int stretchfac;

		DECLARE_EVENT_TABLE()
};

#endif
