/*
 *   Copyright (C) 2011-2012, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#ifndef SETTINGS_H
#define SETTINGS_H

//(*Headers(Settings)
#include <wx/sizer.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/choice.h>
#include <wx/button.h>
#include <wx/dialog.h>
//*)

class Settings: public wxDialog
{
	public:

		Settings(wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		virtual ~Settings();

		//(*Declarations(Settings)
		wxButton* Button4;
		wxStaticText* StaticText2;
		wxButton* Button1;
		wxChoice* Choice_hash;
		wxStaticText* StaticText1;
		wxStaticText* StaticText3;
		wxButton* Button2;
		wxTextCtrl* SignDirCtrl;
		wxButton* Button3;
		wxStaticText* StaticText5;
		wxStaticText* StaticText4;
		wxChoice* Choice_ciph;
		wxTextCtrl* EncDirCtrl;
		//*)

	protected:

		//(*Identifiers(Settings)
		static const long ID_BUTTON3;
		static const long ID_STATICTEXT2;
		static const long ID_BUTTON1;
		static const long ID_STATICTEXT1;
		static const long ID_TEXTCTRL1;
		static const long ID_BUTTON2;
		static const long ID_STATICTEXT3;
		static const long ID_TEXTCTRL2;
		static const long ID_BUTTON4;
		static const long ID_STATICTEXT4;
		static const long ID_CHOICE1;
		static const long ID_STATICTEXT5;
		static const long ID_CHOICE2;
		//*)

	private:

		//(*Handlers(Settings)
		void OnExAccept(wxCommandEvent& event);
		void OnExCancel(wxCommandEvent& event);
		void OnSelSignDir(wxCommandEvent& event);
		void OnSelEncDir(wxCommandEvent& event);
		//*)

		DECLARE_EVENT_TABLE()
};

#endif
