/*
 *   Copyright (C) 2011-2019, Michael Anders, FH-Wedel
 *
 *  This file is part of the ECC-Implementation "Academic Signature"
 *  Maintainer: Michael Anders
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#include "DomainSelector.h"

//(*InternalHeaders(DomainSelector)
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/font.h>
//*)

#include "globals.h"
#include "dom_mac.h"


// (*IdInit(DomainSelector)
const long DomainSelector::ID_BUTTON1 = wxNewId();
const long DomainSelector::ID_TEXTCTRL1 = wxNewId();
const long DomainSelector::ID_BUTTON2 = wxNewId();
const long DomainSelector::ID_STATICTEXT1 = wxNewId();
const long DomainSelector::ID_LISTBOX1 = wxNewId();
const long DomainSelector::ID_BUTTON9 = wxNewId();
const long DomainSelector::ID_BUTTON3 = wxNewId();
const long DomainSelector::ID_BUTTON4 = wxNewId();
const long DomainSelector::ID_BUTTON5 = wxNewId();
const long DomainSelector::ID_BUTTON7 = wxNewId();
const long DomainSelector::ID_BUTTON6 = wxNewId();
const long DomainSelector::ID_BUTTON8 = wxNewId();
const long DomainSelector::ID_BUTTON10 = wxNewId();
const long DomainSelector::ID_BUTTON11 = wxNewId();
const long DomainSelector::ID_BUTTON12 = wxNewId();
const long DomainSelector::ID_BUTTON13 = wxNewId();
//*)

BEGIN_EVENT_TABLE(DomainSelector,wxDialog)
	//(*EventTable(DomainSelector)
	//*)
END_EVENT_TABLE()

DomainSelector::DomainSelector(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
    unsigned int count;
	//(*Initialize(DomainSelector)
	wxFlexGridSizer* FlexGridSizer1;
	Create(parent, wxID_ANY, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("wxID_ANY"));
	FlexGridSizer1 = new wxFlexGridSizer(0, 3, 0, 0);
	Button1 = new wxButton(this, ID_BUTTON1, _("Ok/\naccept changes\nfor session"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	Button1->SetBackgroundColour(wxColour(149,250,143));
	wxFont Button1Font(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button1->SetFont(Button1Font);
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	TextCtrl1 = new wxTextCtrl(this, ID_TEXTCTRL1, _("Chose Domain!"), wxDefaultPosition, wxSize(270,23), 0, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	TextCtrl1->Disable();
	wxFont TextCtrl1Font(11,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	TextCtrl1->SetFont(TextCtrl1Font);
	FlexGridSizer1->Add(TextCtrl1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button2 = new wxButton(this, ID_BUTTON2, _("Exit\ndiscard sessions\nchanges"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	Button2->SetBackgroundColour(wxColour(240,226,141));
	wxFont Button2Font(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button2->SetFont(Button2Font);
	FlexGridSizer1->Add(Button2, 1, wxALL|wxALIGN_LEFT|wxALIGN_TOP, 5);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Select Domain!"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	wxFont StaticText1Font(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText1->SetFont(StaticText1Font);
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	ellps_ctrl = new wxListBox(this, ID_LISTBOX1, wxDefaultPosition, wxSize(288,273), 0, 0, 0, wxDefaultValidator, _T("ID_LISTBOX1"));
	wxFont ellps_ctrlFont(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	ellps_ctrl->SetFont(ellps_ctrlFont);
	FlexGridSizer1->Add(ellps_ctrl, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	Button9 = new wxButton(this, ID_BUTTON9, _("Set as new\ndefault"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON9"));
	wxFont Button9Font(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button9->SetFont(Button9Font);
	FlexGridSizer1->Add(Button9, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	Button3 = new wxButton(this, ID_BUTTON3, _("Delete\nDomain"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON3"));
	wxFont Button3Font(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button3->SetFont(Button3Font);
	FlexGridSizer1->Add(Button3, 1, wxALL|wxALIGN_LEFT|wxALIGN_TOP, 5);
	Button4 = new wxButton(this, ID_BUTTON4, _("Sort for\nsize asc"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON4"));
	wxFont Button4Font(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button4->SetFont(Button4Font);
	FlexGridSizer1->Add(Button4, 1, wxALL|wxALIGN_TOP|wxALIGN_CENTER_HORIZONTAL, 5);
	Button5 = new wxButton(this, ID_BUTTON5, _("Sort for\nsize desc"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON5"));
	wxFont Button5Font(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button5->SetFont(Button5Font);
	FlexGridSizer1->Add(Button5, 1, wxALL|wxALIGN_LEFT|wxALIGN_TOP, 5);
	Button7 = new wxButton(this, ID_BUTTON7, _("Import new\ndomain(s)"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON7"));
	wxFont Button7Font(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button7->SetFont(Button7Font);
	FlexGridSizer1->Add(Button7, 1, wxALL|wxALIGN_LEFT|wxALIGN_TOP, 5);
	Button6 = new wxButton(this, ID_BUTTON6, _("Move to top"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON6"));
	wxFont Button6Font(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button6->SetFont(Button6Font);
	FlexGridSizer1->Add(Button6, 1, wxALL|wxALIGN_TOP|wxALIGN_CENTER_HORIZONTAL, 5);
	Button8 = new wxButton(this, ID_BUTTON8, _("Move to\nbottom"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON8"));
	wxFont Button8Font(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button8->SetFont(Button8Font);
	FlexGridSizer1->Add(Button8, 1, wxALL|wxALIGN_LEFT|wxALIGN_TOP, 5);
	Button10 = new wxButton(this, ID_BUTTON10, _("Export domain"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON10"));
	wxFont Button10Font(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button10->SetFont(Button10Font);
	FlexGridSizer1->Add(Button10, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	Button11 = new wxButton(this, ID_BUTTON11, _("Analyze/check\ndomain"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON11"));
	wxFont Button11Font(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button11->SetFont(Button11Font);
	FlexGridSizer1->Add(Button11, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button12 = new wxButton(this, ID_BUTTON12, _("Make changes\npermanent"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON12"));
	Button12->SetForegroundColour(wxColour(195,10,10));
	Button12->SetBackgroundColour(wxColour(255,224,254));
	wxFont Button12Font(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button12->SetFont(Button12Font);
	FlexGridSizer1->Add(Button12, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	Button13 = new wxButton(this, ID_BUTTON13, _("show domain\nparameters"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON13"));
	wxFont Button13Font(7,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	Button13->SetFont(Button13Font);
	FlexGridSizer1->Add(Button13, 1, wxALL|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	SetSizer(FlexGridSizer1);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&DomainSelector::OnOk);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&DomainSelector::OnDiscard);
	Connect(ID_LISTBOX1,wxEVT_COMMAND_LISTBOX_DOUBLECLICKED,(wxObjectEventFunction)&DomainSelector::OnOk);
	Connect(ID_BUTTON9,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&DomainSelector::OnNewDefault);
	Connect(ID_BUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&DomainSelector::OnDelDomain);
	Connect(ID_BUTTON4,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&DomainSelector::OnSort_Siz_asc);
	Connect(ID_BUTTON5,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&DomainSelector::OnSort_siz_desc);
	Connect(ID_BUTTON7,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&DomainSelector::OnImportNewDomain);
	Connect(ID_BUTTON6,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&DomainSelector::MovTop);
	Connect(ID_BUTTON8,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&DomainSelector::OnMoveBottom);
	Connect(ID_BUTTON10,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&DomainSelector::OnExportCurrDom);
	Connect(ID_BUTTON11,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&DomainSelector::OnAnalyzCurr);
	Connect(ID_BUTTON12,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&DomainSelector::OnPermanence);
	Connect(ID_BUTTON13,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&DomainSelector::OnShowPars);
	//*)

    wxArrayString wxstrad; //wxStringarray initialisieren
    wxString adddm;
    for(count=0;count<e_ls.noel;count++)
    {
        adddm.Printf(_("      %ld bit group order"),(*((e_ls.rpt)+count))->giv_siz());
        wxstrad.Add(  (*((e_ls.rpt)+count))->name +adddm);
    }
 	// Jetzt die Listbox initialisieren
    ellps_ctrl->InsertItems(wxstrad,0);

}
/*********************************************************************/
DomainSelector::~DomainSelector()
{
	//(*Destroy(DomainSelector)
	//*)
}
/*********************************************************************/
void DomainSelector::OnOk(wxCommandEvent& event)
{
    int indx;

    indx=ellps_ctrl->GetSelection();
    EndModal(indx);
    return;
}
/*********************************************************************/
void DomainSelector::OnDiscard(wxCommandEvent& event)
{

           wxString ellst;
           bool goodmac;
           int fl1;
           ellipse *plargell;

           ellst=sec_path + _("/ellipse_list.els");
           goodmac=check_mac(&zugang, ellst, ellst + _(".mac"));
           if(goodmac)
           {
               e_ls.empty_list();
               e_ls.addfromfile(ellst);
           }
           else
           {
                dom_mac dialog(this);
                fl1=dialog.ShowModal();
                switch(fl1)
                {
                    case 0:
                      //load skeleton
                      e_ls.add_ellps(&gdom);
                      e_ls.add_ellps(&stretch_ell);
                      //load 1024 bit domain also
                      plargell=new ellipse();
                      plargell->ellipse_set_stretch1024();
                      e_ls.add_ellps(plargell);
                      delete plargell;
                      break;

                    case 1:
                      //check all
                      throwout(_("not implemented yet"),2);
                      break;

                    case 2:
                      //accept
                      make_mac_file(&zugang,&ellst,_("sha4"),_("Fleas_l3"));
                      e_ls.addfromfile(ellst);
                      break;

                    default:
                      e_ls.add_ellps(&gdom);
                      e_ls.add_ellps(&stretch_ell);
                }
           }

//restore ellipse
    ellipse defell;
    gdom.copyell(&defell);
    EndModal(-1);
    return;
}
/*********************************************************************/
void DomainSelector::OnDelDomain(wxCommandEvent& event)
{
    int indx;

    indx=ellps_ctrl->GetSelection();
    e_ls.cut_ellps(indx);
    //renew list_box
    ellps_ctrl->Delete(indx);
    //EndModal(-2);
}
/*********************************************************************/
void DomainSelector::OnSort_Siz_asc(wxCommandEvent& event)
{
    int j;
    bool chng=false;
    long s1;

    do
    {
        chng=false;
        for(j=0;j<(int)e_ls.noel-1;j++)
        {
            s1=(*(e_ls.rpt+j))->q.giv_siz();
            if( (*(e_ls.rpt+j+1))->giv_siz() < s1 )
            {
                chng=true;
                e_ls.swap_ell(j,j+1);
            }
        }
    }while(chng==true);
    EndModal(-2);
    return;
}
/*********************************************************************/
void DomainSelector::MovTop(wxCommandEvent& event)
{
    int indx;

    indx=ellps_ctrl->GetSelection();
    e_ls.mov_top_ell(indx);
    //renew list_box
    EndModal(-2);
    return;
}
/*********************************************************************/
void DomainSelector::OnImportNewDomain(wxCommandEvent& event)
{
    wxString fnam;
    unsigned int nnoel,onoel;

    fnam = wxFileSelector(_("Choose a domain-file to load"),kytray, _(""),_("els|*"),_("dom_files(*.els)|*.els|all_files(*.*)|*"));
    if(fnam.empty()) return;
    if(fnam.Len()>600){throwout(_("malformed filename too long\naborting!"),3); return;}
    // auf notexist testen
    if(! wxFile::Exists(fnam))
    {
        throwout(_("Error, File does not exist!\n do nothing"),4);
        return;
    }
    onoel=e_ls.noel;
    nnoel=e_ls.addfromfile(fnam,true);
    if(onoel!=nnoel) EndModal(-2);
    return;
}
/*********************************************************************/
void DomainSelector::OnMoveBottom(wxCommandEvent& event)
{
    int indx;

    indx=ellps_ctrl->GetSelection();
    e_ls.mov_bott_ell(indx);
    //renew list_box
    EndModal(-2);
    return;

}
/*********************************************************************/
void DomainSelector::OnNewDefault(wxCommandEvent& event)
{
    int indx;
    wxString dnm;

    indx=ellps_ctrl->GetSelection();
    if((indx<0)||(indx>(int)e_ls.noel-1)||(e_ls.noel==0)) return;

    gdom.copyell( *(e_ls.rpt+indx) );
    (gdom.p).try_rare();
    dnm= _("Domain \"") + gdom.name +_("\"\nset as new default domain ");
    throwout(dnm,3);
    return;
}
/*********************************************************************/

void DomainSelector::OnExportCurrDom(wxCommandEvent& event)
{
    int indx;
    wxString dnm,fnam;
    wxString os;
    FILE *fp;

    indx=ellps_ctrl->GetSelection();
    if((indx<0)||(indx>(int)e_ls.noel-1)||(e_ls.noel==0)) return;

    fnam= kytray + (*(e_ls.rpt +indx))->name + _(".els");
    fp=fopen(fnam.mb_str(wxConvLocal),"w");
    if(fp==NULL)
    {
        throwout(_("could not open domain file for writing"));
        return;
    }
    fprintf(fp," \n");

    fprintf(fp,"ID: %s \n",(const char*)((*(e_ls.rpt +indx))->name).mb_str(wxConvUTF8));
    ((*(e_ls.rpt +indx))->p).writehex(&os);
    fprintf(fp,"MODUL: %s \n", (const char*)os.mb_str(wxConvUTF8) );
    ((*(e_ls.rpt +indx))->a).writehex(&os);
    fprintf(fp,"coeff_A: %s \n",(const char*)os.mb_str(wxConvUTF8));
    ((*(e_ls.rpt +indx))->b).writehex(&os);
    fprintf(fp,"coeff_B: %s \n", (const char*)os.mb_str(wxConvUTF8) );
    ((*(e_ls.rpt +indx))->q).writehex(&os);
    fprintf(fp,"q_MODUL: %s \n",(const char*)os.mb_str(wxConvUTF8) );
    ((*(e_ls.rpt +indx))->d0.x).writehex(&os);
    fprintf(fp,"X0: %s \n",(const char*)os.mb_str(wxConvUTF8) );
    ((*(e_ls.rpt +indx))->d0.y).writehex(&os);
    fprintf(fp,"Y0: %s \n \n",(const char*)os.mb_str(wxConvUTF8));

    fprintf(fp," END ");
    fclose(fp);
    throwout(_("wrote domain file named: ") + (*(e_ls.rpt +indx))->name + _(".els\n to keytray directory"),4);
    return;
}
/***********************************************************************/
void DomainSelector::OnAnalyzCurr(wxCommandEvent& event)
{
    int indx;

    indx=ellps_ctrl->GetSelection();
    if((indx<0)||(indx>(int)(e_ls.noel)-1)||(e_ls.noel==0)) return;
    if(!(*(e_ls.rpt+indx))->el_selftest())
    {
        throwout(_("Domain is not even sound!\nrecommended to delete domain!\ntry temporary fix!"),10);
        if(!((*(e_ls.rpt+indx))->d0).get_point_in_ellipse(*(e_ls.rpt+indx)))
        {
            throwout(_("cannot fix!"),4);
            return;
        }
        if( !(*(e_ls.rpt+indx))->el_selftest())
        {
            throwout(_("Could not fix!"),4);
            return;

        }
    }

    if(!(*(e_ls.rpt+indx))->el_safety())
    {
        throwout(_("Domain seems sound\nbut failed crypto-strength test"));
        return;
    }
    else{
    throwout(_("Domain passed all Tests"));
    }
    return;
}
/************************************************************************/

void DomainSelector::OnPermanence(wxCommandEvent& event)
{
    wxString fn;

    fn=sec_path + _("/ellipse_list.els");
    //save old one
    e_ls.write_list2file(fn);
    //remac file
    make_mac_file(&zugang,&fn,_("sha4"),_("Fleas_l3"));
    throwout(_("Wrote new domains-file\nand secured it with MAC."),2);
    return;
}
/***********************************************************************/
void DomainSelector::OnSort_siz_desc(wxCommandEvent& event)
{
    int j;
    bool chng=false;
    long s1;

    do
    {
        chng=false;
        for(j=0;j<(int)(e_ls.noel)-1;j++)
        {
            s1=(*(e_ls.rpt+j))->q.giv_siz();
            if( (*(e_ls.rpt+j+1))->q.giv_siz() > s1 )
            {
                chng=true;
                e_ls.swap_ell(j,j+1);
            }
        }
    }while(chng==true);
    EndModal(-2);
    return;

}
/**************************************************************************/
void DomainSelector::OnShowPars(wxCommandEvent& event)
{
    int indx;
    wxString message,scratch;

    indx=ellps_ctrl->GetSelection();
    if((indx<0)||(indx>(int)e_ls.noel-1)||(e_ls.noel==0))
    {
        throwout(_("No domain selected!\nAborting"),3);
        return;
    }
    scratch= _("Domain Name:   ") + (*(e_ls.rpt+indx))->name +_("\n");
    message+=scratch;
    (*((e_ls.rpt)+indx))->a.writehex(&scratch);
    scratch = _("CurvePar A: ") + scratch +_("\n");
    message+=scratch;
    (*((e_ls.rpt)+indx))->b.writehex(&scratch);
    scratch = _("CurvePar B: ") + scratch +_("\n");
    message+=scratch;

    (*((e_ls.rpt)+indx))->p.writehex(&scratch);
    scratch = _("Prime Module p: ") + scratch +_("\n");
    message+=scratch;

    (*((e_ls.rpt)+indx))->q.writehex(&scratch);
    scratch = _("Galois Group order q: ") + scratch +_("\n");
    message+=scratch;

    (*((e_ls.rpt)+indx))->d0.x.writehex(&scratch);
    scratch = _("Start with primitive Point X0: ") + scratch +_("\n");
    message+=scratch;
    (*((e_ls.rpt)+indx))->d0.y.writehex(&scratch);
    scratch = _("and Y0: ") + scratch +_("\n");
    message+=scratch;
    wxMessageBox(message, _("The Parameters of the selected Domain are:"));
    return;
}
/****************************************************************/
