#include "CapDialog.h"
#include "LoadEllKey.h"
#include <wx/ffile.h>


//(*InternalHeaders(CapDialog)
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/font.h>
//*)

//(*IdInit(CapDialog)
const long CapDialog::ID_BUTTON2 = wxNewId();
const long CapDialog::ID_STATICTEXT1 = wxNewId();
const long CapDialog::ID_STATICTEXT2 = wxNewId();
const long CapDialog::ID_TEXTCTRL1 = wxNewId();
const long CapDialog::ID_BUTTON_Filesel = wxNewId();
const long CapDialog::ID_STATICTEXT3 = wxNewId();
const long CapDialog::ID_CAPKYCTRL = wxNewId();
const long CapDialog::ID_STATICTEXT4 = wxNewId();
const long CapDialog::ID_BUTTON1 = wxNewId();
const long CapDialog::ID_Separator = wxNewId();
const long CapDialog::ID_BUTTON_DeCap = wxNewId();
//*)

BEGIN_EVENT_TABLE(CapDialog,wxDialog)
	//(*EventTable(CapDialog)
	//*)
END_EVENT_TABLE()

CapDialog::CapDialog(wxWindow* parent,wxWindowID id)
{
	//(*Initialize(CapDialog)
	wxFlexGridSizer* FlexGridSizer1;
	Create(parent, id, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("id"));
	FlexGridSizer1 = new wxFlexGridSizer(0, 3, 0, 0);
	Button2 = new wxButton(this, ID_BUTTON2, _("Exit/Close"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	FlexGridSizer1->Add(Button2, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	TitleText = new wxStaticText(this, ID_STATICTEXT1, _("Nada Cap Dialog"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	wxFont TitleTextFont(15,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	TitleText->SetFont(TitleTextFont);
	FlexGridSizer1->Add(TitleText, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT2, _("File to Cap/Uncap"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT2"));
	FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	fnam_ctrl = new wxTextCtrl(this, ID_TEXTCTRL1, wxEmptyString, wxDefaultPosition, wxSize(310,22), 0, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	FlexGridSizer1->Add(fnam_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Butt_filesel = new wxButton(this, ID_BUTTON_Filesel, _("Select File to op on"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON_Filesel"));
	FlexGridSizer1->Add(Butt_filesel, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText2 = new wxStaticText(this, ID_STATICTEXT3, _("Cap keyphrase"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT3"));
	FlexGridSizer1->Add(StaticText2, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Capky_ctrl = new wxTextCtrl(this, ID_CAPKYCTRL, _("intrinsic"), wxDefaultPosition, wxSize(307,22), 0, wxDefaultValidator, _T("ID_CAPKYCTRL"));
	FlexGridSizer1->Add(Capky_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText3 = new wxStaticText(this, ID_STATICTEXT4, _("Separator Mark"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT4"));
	FlexGridSizer1->Add(StaticText3, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button_EnCap = new wxButton(this, ID_BUTTON1, _("EnCap"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	FlexGridSizer1->Add(Button_EnCap, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	sep_ctrl = new wxTextCtrl(this, ID_Separator, _("X:"), wxDefaultPosition, wxSize(180,22), 0, wxDefaultValidator, _T("ID_Separator"));
	FlexGridSizer1->Add(sep_ctrl, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button1 = new wxButton(this, ID_BUTTON_DeCap, _("DeCap"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON_DeCap"));
	FlexGridSizer1->Add(Button1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	SetSizer(FlexGridSizer1);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);

	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&CapDialog::OnExit);
	Connect(ID_BUTTON_Filesel,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&CapDialog::OnFileSel);
	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&CapDialog::OnEnCap);
	Connect(ID_BUTTON_DeCap,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&CapDialog::OnDeCap);
	//*)

	cur_cry_path=cry_path;
}
/*****************************************************************************/
CapDialog::~CapDialog()
{
	//(*Destroy(CapDialog)
	//*)
}
/*****************************************************************************/

/*****************************************************************************/
void CapDialog::OnEnCap(wxCommandEvent& event)
{
    wxString newfnam, messg, keyid;
    longnumber salt, counter, key;
    int endmsiz,i, readflag;
    int saltlen=256, counterlen = 512;
    ellipse el1024;
    char buff[400],cbuf[400],c,*otpbuff;
    ulong32 usecnt=0,useblock=0;
    int mode=13; //10 for fleas ld mt, 13 for monothread
    int stretch=13;
    bool intrinsic=false;
    el_pub pbky;
    FILE *pfile;

    //get file name in
    fnam = fnam_ctrl->GetLineText(0);
    //check for existence
    if(!wxFile::Exists(fnam))
    {
        throwout(_("file to cap does not exist!\nDo Nothing."),3);
        return;
    }
    newfnam=fnam+_(".cap");
    //get separator
    endmark = sep_ctrl->GetLineText(0);
    //get Cap Key
    keyword = Capky_ctrl->GetLineText(0);
    if(keyword==_("intrinsic")) intrinsic=true;
    else intrinsic=false;
    //get match buffer
    //open file to read
    wxFFile capfile(fnam, _("rb"));
    if(!capfile.IsOpened())
    {
        throwout(_("Error\ncould not open file to cap!\nDo Nothing."),3);
        return;
    }
    //open capped file to write
    wxFFile nadafile(newfnam,_("wb"));
    if(!nadafile.IsOpened())
    {
        throwout(_("Error\ncould not open cappedfile!\nDo Nothing."),3);
        capfile.Close();
        return;
    }
    if(!intrinsic)
    {
       //write salt and counter to outfile
       salt.makerandom(saltlen);
       readflag=nadafile.Write(salt.ad,saltlen);
    }
    counter.makerandom(counterlen);
    readflag=nadafile.Write(counter.ad,counterlen);
    if(!intrinsic)
    {
        el1024.ellipse_set_stretch1024();
        //prepare cap data structure for extrinsic cap
        if(!cap_prep_from_String(&keyword, &salt, &counter, (ulong32)counterlen, &key,  &el1024, stretch,counterlen,true))
        {
           throwout(_("Error in cap preparation!\naborting!"),5);
           nadafile.Close(); capfile.Close();
          return;
        }
    }
    else //if intrinsic
    {
        //determine public key id
             // read kid: ID
             pfile=capfile.fp();
             readflag = fscanf(pfile,"kid: %100s", buff);
             if(readflag != 1)
             {
                 throwout(_("cannot cap intrinsically!\nno key ID found in file"),5);
                 nadafile.Close(); capfile.Close();
                 return;
             }
             //convert to wxString
             keyid=wxString::FromUTF8(buff);
             if(readflag==1)
                {
                    throwout(_("Capping for pubkey: ")+keyid, 3);
                }
            //rewind capfile
             capfile.Seek(0);
        //load public key
       if(!load_pub_ell_ky(&pbky, &keyid))
       {
           throwout(_("could not find public key \nin internal storage!\nAborting."),10);
           nadafile.Close(); capfile.Close();
           return;
       }
        //determine cap key and true counter from pubkey
       if(!cap_prep_from_pubky(&pbky, &counter, (ulong32) counterlen, &key, counterlen))
       {
           throwout(_("could not determine cap key \nfrom public key\nAborting."),10);
           nadafile.Close(); capfile.Close();
           return;
       }
    }
    counter.inc();
    //set up endmark buffer
    endmsiz= endmark.Len();
    if(endmsiz > 50)
    {
        throwout(_("Are you Nuts!\nMore than 50 chars Endmark is crazy\nAborting!"),5);
        nadafile.Close(); capfile.Close();
        return;
   }
   strcpy(buff, (const char*) endmark.mb_str(wxConvUTF8));
   strcpy(cbuf, (const char*) endmark.mb_str(wxConvUTF8));//easiest way to ensure \0 termination
   endmsiz=strlen(buff);
   //fill compare buffer
   capfile.Read(cbuf,endmsiz); //overwrite content
   //fill xorblock
   otpbuff=(char*)malloc(counterlen);
   memcpy(otpbuff,counter.ad,counterlen);
   if(! k_develop_f4(counterlen, otpbuff, 0, NULL, counterlen, (char*) key.ad, 2, mode ))  //0,NULL means no cpablocker, algo 10 is fleas Ld 4 Path
   {
       throwout(_("Alert, keydevelop failed for cap!"),5);
       free(otpbuff);
       nadafile.Close(); capfile.Close();
       return;
   }
   // writeout xored compbuffer first
   for(i=0;i<endmsiz;i++)
   {
       if(useblock==counterlen) //refresh bufer
       {
           counter.inc();
           memcpy(otpbuff,counter.ad,counterlen);
           if(! k_develop_f4(counterlen, otpbuff, 0, NULL, counterlen, (char *)key.ad, 2, mode ))  //0,NULL means no cpablocker, algo 10 is fleas Ld 4 Path
            {
                throwout(_("Alert, keydevelop failed for cap!"),5);
                free(otpbuff);
                nadafile.Close(); capfile.Close();
                return;
            }
            useblock=0;
       }
       c= *(cbuf+i);
       c ^= *(otpbuff+useblock);
       useblock++; usecnt++;
       readflag=nadafile.Write(&c,1);
   }
    //read in byte , check mark match, xor and writeout
   while((strcmp(buff,cbuf)!=0)&&(usecnt<4000))
   {
       memmove(cbuf,cbuf+1,endmsiz-1); //moveone down
       readflag=capfile.Read(&c,1);  //get next byte
       if(readflag != 1) //EOF reached or error
            {
                throwout(_("Error, file to cap exhausted!\n end mark not encountered!"),5);
                free(otpbuff);
                nadafile.Close(); capfile.Close();
                return;
            }
       *(cbuf+endmsiz-1)=c;  //put into compare buffer
       if(useblock==counterlen) //refresh buffer if necessary
       {
           counter.inc();
           memcpy(otpbuff,counter.ad,counterlen);
           if(! k_develop_f4(counterlen, otpbuff, 0, NULL, counterlen, (char *)key.ad, 2, mode ))  //0,NULL means no cpablocker, algo 10 is fleas Ld 4 Path
            {
                throwout(_("Alert, keydevelop failed for cap!"),5);
                free(otpbuff);
                nadafile.Close(); capfile.Close();
                return;
            }
            useblock=0;
       }
       c ^= *(otpbuff+useblock); //xor with OTP
       useblock++; usecnt++;
       readflag=nadafile.Write(&c,1);  //writeout cap byte
   }
   free(otpbuff);
   if(usecnt<4000)
   {
       messg.Printf(_("Capping done\nEnd Mark found at byte %i"), usecnt);
       //throwout(messg,3);
   }
   else
   {
       messg.Printf(_("Could not encap, \nend mark not found after 400 byte!\nAborted!"));
       throwout(messg,3);
       nadafile.Close(); capfile.Close();
       return;
   }
    //after match transfer rest
    while(readflag==1)
    {
        readflag=capfile.Read(&c,1);  //get next byte
        if(readflag==1)nadafile.Write(&c,1);
    }
    nadafile.Close(); capfile.Close();
    throwout(messg);
    return;
}
/*****************************************************************************/
void CapDialog::OnDeCap(wxCommandEvent& event)
{
    wxString newfnam, messg;
    longnumber salt, counter, key;
    int endmsiz,i, readflag;
    int saltlen=256, counterlen = 512;
    ellipse el1024;
    char buff[100],cbuf[100],c,*otpbuff;
    ulong32 usecnt=0,useblock=0;
    int mode=13; //10 for fleas ld mt, 13 for monothread
    int stretch=13;
    bool intrinsic=false;
    el_pub pbky;

    //get file name in
    fnam = fnam_ctrl->GetLineText(0);
    //check for existence
    if(!wxFile::Exists(fnam))
    {
        throwout(_("file to cap does not exist!\nDo Nothing."),3);
        return;
    }
    newfnam=fnam+_("_decap");
    //get separator
    endmark = sep_ctrl->GetLineText(0);
    //get Cap Key
    keyword = Capky_ctrl->GetLineText(0);
    if(keyword==_("intrinsic")) intrinsic=true;
    //get match buffer
    //open capped file to read
    wxFFile capfile(fnam);
    if(!capfile.IsOpened())
    {
        throwout(_("Error\ncould not open file to cap!\nDo Nothing."),3);
        return;
    }
    //open decapped file to write
    wxFFile decapfile(newfnam, _("wb"));
    if(!decapfile.IsOpened())
    {
        throwout(_("Error\ncould not open cappedfile!\nDo Nothing."),3);
        capfile.Close();
        return;
    }
    //read in salt and counter from file
    if(!intrinsic)
    {
       salt.resizelonu(saltlen+2);
       readflag=capfile.Read(salt.ad,saltlen);
       if(readflag<saltlen)
       {
        throwout(_("Could not even read salt!\naborting"),3);
        capfile.Close();decapfile.Close();
        return;
       }
    }
    counter.resizelonu(counterlen+2);
    readflag=capfile.Read(counter.ad,counterlen);
    if(readflag<counterlen)
    {
        throwout(_("Could not read counter primer!\naborting"),3);
        capfile.Close();decapfile.Close();
        return;
    }
    counter.setsize(true);
    if(!intrinsic)
    {
       salt.setsize(true);
       el1024.ellipse_set_stretch1024();
    //prepare cap data structure
       if(!cap_prep_from_String(&keyword, &salt, &counter, (ulong32)counterlen, &key,  &el1024, stretch,counterlen,true))
       {
        throwout(_("Error in cap preparation!\naborting!"),5);
        decapfile.Close(); capfile.Close();
        return;
       }
    }
    if(intrinsic)
    {
        //sel pubky
        throwout(_("for intrinsic decap\nyou need to give pub key ID"),10);
        LoadEllKey dialog(this,&pbky);
        dialog.ShowModal();
        if(pbky.id==_("Trivial")) //unsuccessful
        {
            throwout(_("No valid key selected\nAborting"),3);
            decapfile.Close(); capfile.Close();
            return;
        }
        //prepare cap key from pubky
       if(!cap_prep_from_pubky(&pbky, &counter, (ulong32) counterlen, &key, counterlen))
       {
           throwout(_("could not determine cap key \nfrom public key\nAborting."),10);
           decapfile.Close(); capfile.Close();
           return;
       }

    }
    counter.inc();
    //set up endmark buffer
    endmsiz= endmark.Len();
    if(endmsiz > 50)
    {
        throwout(_("Are you Nuts!\nMore than 50 chars Endmark is crazy\nAborting!"),5);
        decapfile.Close(); capfile.Close();
        return;
   }
   strcpy(buff, (const char*) endmark.mb_str(wxConvUTF8));
   strcpy(cbuf, (const char*) endmark.mb_str(wxConvUTF8));//easiest way to ensure \0 termination
   endmsiz=strlen(buff);
   //fill compare buffer
   capfile.Read(cbuf,endmsiz); //overwrite content
   //fill xorblock
   otpbuff=(char*)malloc(counterlen);
   memcpy(otpbuff,counter.ad,counterlen);
   if(! k_develop_f4(counterlen, otpbuff, 0, NULL, counterlen, (char*) key.ad, 2, mode ))  //0,NULL means no cpablocker, algo 10 is fleas Ld 4 Path
   {
       throwout(_("Alert, keydevelop failed for cap!"),5);
       free(otpbuff);
       decapfile.Close(); capfile.Close();
       return;
   }
   // treat compbuffer first
   for(i=0;i<endmsiz;i++)
   {
       if(useblock==counterlen) //refresh bufer
       {
           counter.inc();
           memcpy(otpbuff,counter.ad,counterlen);
           if(! k_develop_f4(counterlen, otpbuff, 0, NULL, counterlen, (char *)key.ad, 2, mode ))  //0,NULL means no cpablocker, algo 10 is fleas Ld 4 Path
            {
                throwout(_("Alert, keydevelop failed for cap!"),5);
                free(otpbuff);
                decapfile.Close(); capfile.Close();
                return;
            }
            useblock=0;
       }
       *(cbuf+i) ^= *(otpbuff+useblock);
       useblock++; usecnt++;
       readflag=decapfile.Write(cbuf+i,1);
   }
    //read in byte , check mark match, xor and writeout
   while((strcmp(buff,cbuf)!=0)&&(usecnt<5000))
   {
       memmove(cbuf,cbuf+1,endmsiz-1); //moveone down
       readflag=capfile.Read(&c,1);  //get next byte
       if(readflag != 1) //EOF reached or error
            {
                throwout(_("Error, file to cap exhausted!\n end mark not encountered!"),5);
                free(otpbuff);
                decapfile.Close(); capfile.Close();
                return;
            }
       if(useblock==counterlen) //refresh buffer if necessary
       {
           counter.inc();
           memcpy(otpbuff,counter.ad,counterlen);
           if(! k_develop_f4(counterlen, otpbuff, 0, NULL, counterlen, (char *)key.ad, 2, mode))  //0,NULL means no cpablocker, algo 10 is fleas Ld 4 Path
            {
                throwout(_("Alert, keydevelop failed for cap!"),5);
                free(otpbuff);
                decapfile.Close(); capfile.Close();
                return;
            }
            useblock=0;
       }
       c ^= *(otpbuff+useblock); //xor with OTP
       *(cbuf+endmsiz-1)=c;  //put into compare buffer
       useblock++; usecnt++;
       readflag=decapfile.Write(&c,1);  //writeout cap byte
   }
   free(otpbuff);
   if(usecnt<5000) messg.Printf(_("Successful decapping :-)\nEnd Mark was found at byte %i"), usecnt);
   else
   {
       messg.Printf(_("Could not decap, \nend mark not found after 5 kbyte!\nAborted!"));
       throwout(messg,3);
       decapfile.Close(); capfile.Close();
       //remove broken decap file
       wxRemoveFile(newfnam);
       return;
   }
   throwout(messg,3);
    //after match transfer rest
    while(readflag==1)
    {
        readflag=capfile.Read(&c,1);  //get next byte
        if(readflag==1) decapfile.Write(&c,1);
    }
    decapfile.Close(); capfile.Close();
    return;
}
/*****************************************************************************/
void CapDialog::OnFileSel(wxCommandEvent& event)
{
    fnam = wxFileSelector(_("Choose a file to en/decap"),cry_path);
    if ( !fnam.empty() )
    {
        fnam_ctrl->SetValue(fnam);
        cur_cry_path= ((wxFileName)fnam).GetPath(); //get new path and store into cur_doc_path
    }
}
/*****************************************************************************/
void CapDialog::OnExit(wxCommandEvent& event)
{
        Close();
}
/*****************************************************************************/
